/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.panel;

import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import com.dbeaver.ee.runtime.internal.ui.editors.EntityEditorInput;
import com.dbeaver.ee.runtime.internal.ui.editors.ObjectDataEditor;
import com.dbeaver.model.document.data.DBCDocumentHierarchical;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DataEditorFeatures;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelRefresher;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class SubCollectionsPanel
implements IResultSetPanel {
    private static final Log log = Log.getLog(SubCollectionsPanel.class);
    public static final String PANEL_ID = "subcollections_panel";
    private final List<DBSObject> subCollectionsList = new ArrayList<DBSObject>();
    private final DBRFeature resultSetPanelSubCollection = DBRFeature.createFeature((DBRFeature)DataEditorFeatures.CATEGORY_RESULT_SET_VIEWER, (String)"Use SubCollection panel");
    private IResultSetPresentation presentation;
    private SubEntitiesTable subcollectionsTable;
    private ResultSetRow currentPanelRow = null;
    private Text filterTextBox;
    private Action addAction;
    private Action deleteAction;
    private Action refreshAction;

    public void contributeActions(IContributionManager manager) {
        this.addAction = new Action("Create collection", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ADD)){

            /*
             * WARNING - void declaration
             */
            public void run() {
                Object object;
                if (SubCollectionsPanel.this.currentPanelRow == null) {
                    return;
                }
                String colName = EnterNameDialog.chooseName((Shell)UIUtils.getActiveWorkbenchShell(), (String)UiMessages.panel_subcollections_create_subcollection);
                Object[] values = SubCollectionsPanel.this.currentPanelRow.getValues();
                if (colName == null) {
                    return;
                }
                if (values.length == 1 && (object = values[0]) instanceof DBCDocumentHierarchical) {
                    void dbcDocumentHierarchical;
                    DBCDocumentHierarchical dBCDocumentHierarchical = (DBCDocumentHierarchical)object;
                    DBCDocumentHierarchical cfr_ignored_0 = (DBCDocumentHierarchical)object;
                    new AbstractJob("Add Collection", (DBCDocumentHierarchical)dbcDocumentHierarchical, colName){
                        private final /* synthetic */ DBCDocumentHierarchical val$dbcDocumentHierarchical;
                        private final /* synthetic */ String val$colName;
                        {
                            this.val$dbcDocumentHierarchical = dBCDocumentHierarchical;
                            this.val$colName = string;
                            super($anonymous0);
                        }

                        protected IStatus run(DBRProgressMonitor monitor) {
                            try {
                                this.val$dbcDocumentHierarchical.createChildEntity(this.val$colName, monitor);
                                UIUtils.syncExec(() -> SubCollectionsPanel.this.refresh(false));
                                return Status.OK_STATUS;
                            }
                            catch (DBCException e) {
                                log.error((Object)"Error adding collection", (Throwable)e);
                                return new Status(4, "org.jkiss.dbeaver.model", e.getMessage());
                            }
                        }
                    }.schedule();
                }
            }
        };
        manager.add((IAction)this.addAction);
        this.deleteAction = new Action("Delete collection", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE)){

            public void run() {
                SubCollectionsPanel.this.deleteSubCollection();
            }
        };
        manager.add((IAction)this.deleteAction);
        this.refreshAction = new Action("Refresh", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

            public void run() {
                SubCollectionsPanel.this.refresh(true);
            }
        };
        manager.add((IAction)this.refreshAction);
    }

    /*
     * WARNING - void declaration
     */
    private void deleteSubCollection() {
        Object object;
        ISelection selection = this.subcollectionsTable.getSelectionProvider().getSelection();
        if (selection == null) {
            return;
        }
        Object[] values = this.currentPanelRow.getValues();
        if (values.length == 1 && (object = values[0]) instanceof DBCDocumentHierarchical) {
            DBCDocumentHierarchical dBCDocumentHierarchical = (DBCDocumentHierarchical)object;
            DBCDocumentHierarchical cfr_ignored_0 = (DBCDocumentHierarchical)object;
            ISelection iSelection = selection;
            if (iSelection instanceof IStructuredSelection) {
                void structuredSelection;
                Object firstElement;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_1 = (IStructuredSelection)iSelection;
                Object object2 = firstElement = structuredSelection.getFirstElement();
                if (object2 instanceof DBSEntity) {
                    void entity;
                    DBSEntity dBSEntity = (DBSEntity)object2;
                    DBSEntity cfr_ignored_2 = (DBSEntity)object2;
                    if (UIUtils.confirmAction((String)"Confirm Sub Collection Deletion", (String)("Are you sure you want to delete '" + entity.getName() + "' collection"))) {
                        void dbcDocumentHierarchical;
                        new AbstractJob("Deleting Collection", (DBCDocumentHierarchical)dbcDocumentHierarchical, (DBSEntity)entity){
                            private final /* synthetic */ DBCDocumentHierarchical val$dbcDocumentHierarchical;
                            private final /* synthetic */ DBSEntity val$entity;
                            {
                                this.val$dbcDocumentHierarchical = dBCDocumentHierarchical;
                                this.val$entity = dBSEntity;
                                super($anonymous0);
                            }

                            protected IStatus run(DBRProgressMonitor monitor) {
                                try {
                                    this.val$dbcDocumentHierarchical.deleteChildEntity(this.val$entity.getName(), monitor);
                                    UIUtils.syncExec(() -> SubCollectionsPanel.this.refresh(false));
                                    return Status.OK_STATUS;
                                }
                                catch (DBCException e) {
                                    log.error((Object)"Error adding collection", (Throwable)e);
                                    return new Status(4, "org.jkiss.dbeaver.model", e.getMessage());
                                }
                            }
                        }.schedule();
                    }
                }
            }
        }
    }

    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.currentPanelRow = presentation.getController().getCurrentRow();
        Composite subCollectionPlaceholder = UIUtils.createComposite((Composite)parent, (int)1);
        subCollectionPlaceholder.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite filterPanel = UIUtils.createComposite((Composite)subCollectionPlaceholder, (int)2);
        filterPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)filterPanel, (String)UiMessages.panel_subcollections_filter_label);
        this.filterTextBox = new Text(filterPanel, 2432);
        this.filterTextBox.setLayoutData((Object)new GridData(768));
        this.filterTextBox.addModifyListener(e -> this.refresh(false));
        this.filterTextBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    SubCollectionsPanel.this.filterTextBox.setText("");
                }
            }
        });
        this.subcollectionsTable = new SubEntitiesTable(subCollectionPlaceholder);
        this.subcollectionsTable.setLayoutData(new GridData(1808));
        this.subcollectionsTable.setFitWidth(true);
        this.subcollectionsTable.setToolTipText(UiMessages.panel_subcollections_table_info);
        this.subcollectionsTable.setInfo(UiMessages.panel_subcollections_table_info);
        this.subcollectionsTable.setShowDivider(true);
        this.subcollectionsTable.getItemsViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    SubCollectionsPanel.this.deleteSubCollection();
                }
                super.keyPressed(e);
            }
        });
        this.subcollectionsTable.setDoubleClickHandler(event -> {
            ISelection selection = this.subcollectionsTable.getSelectionProvider().getSelection();
            ISelection iSelection = selection;
            if (iSelection instanceof IStructuredSelection) {
                void structuredSelection;
                Object firstElement;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
                Object object = firstElement = structuredSelection.getFirstElement();
                if (object instanceof DBSEntity) {
                    void entity;
                    DBSEntity dBSEntity = (DBSEntity)object;
                    DBSEntity cfr_ignored_1 = (DBSEntity)object;
                    EntityEditorInput entityEditorInput = new EntityEditorInput((DBSObject)entity, null);
                    IWorkbenchWindow activeWorkbenchWindow = UIUtils.getActiveWorkbenchWindow();
                    try {
                        activeWorkbenchWindow.getActivePage().openEditor((IEditorInput)entityEditorInput, ObjectDataEditor.class.getName());
                    }
                    catch (PartInitException e) {
                        log.error((Object)"Error activating editor", (Throwable)e);
                    }
                }
            }
        });
        this.subcollectionsTable.getSelectionProvider().addSelectionChangedListener(event -> this.deleteAction.setEnabled(this.rowCanContainSubCollections() && !this.subcollectionsTable.getSelectionProvider().getSelection().isEmpty()));
        if (this.presentation instanceof ISelectionProvider) {
            ISelectionChangedListener listener = event -> {
                if (this.presentation.getController().getVisiblePanel() == this) {
                    ResultSetRow row = presentation.getController().getCurrentRow();
                    if (row != null && row != this.currentPanelRow) {
                        this.currentPanelRow = row;
                        this.refresh(false);
                    }
                    this.addAction.setEnabled(this.rowCanContainSubCollections());
                    this.deleteAction.setEnabled(this.rowCanContainSubCollections() && !this.subcollectionsTable.getSelectionProvider().getSelection().isEmpty());
                }
            };
            ((ISelectionProvider)this.presentation).addSelectionChangedListener(listener);
            presentation.getControl().addDisposeListener(e -> ((ISelectionProvider)presentation).removeSelectionChangedListener(listener));
        }
        ResultSetPanelRefresher.installOn((IResultSetPanel)this, (IResultSetPresentation)presentation);
        this.resultSetPanelSubCollection.use();
        return subCollectionPlaceholder;
    }

    private boolean rowCanContainSubCollections() {
        return this.currentPanelRow != null && this.currentPanelRow.getState() != 2;
    }

    public boolean isDirty() {
        return false;
    }

    public void activatePanel() {
        this.refresh(false);
    }

    public void deactivatePanel() {
    }

    public void setFocus() {
        this.subcollectionsTable.setFocus();
    }

    public void refresh(boolean force) {
        DBCExecutionContext executionContext;
        if (force && (executionContext = this.presentation.getController().getExecutionContext()) != null) {
            DBUtils.fireObjectRefresh((DBSObject)executionContext.getDataSource());
        }
        this.subCollectionsList.clear();
        if (this.subcollectionsTable.isLoading()) {
            return;
        }
        this.subcollectionsTable.clearListData();
        this.subcollectionsTable.refreshActions();
        this.subcollectionsTable.loadData();
    }

    private class LoadSubCollectionsService
    extends DatabaseLoadService<Collection<DBSObject>> {
        List<? extends DBSEntity> collections;

        LoadSubCollectionsService() {
            super("Load Collections", SubCollectionsPanel.this.presentation.getController().getExecutionContext());
        }

        /*
         * WARNING - void declaration
         */
        public Collection<DBSObject> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
            if (SubCollectionsPanel.this.presentation instanceof ISelectionProvider) {
                try {
                    DBCExecutionContext executionContext = SubCollectionsPanel.this.presentation.getController().getExecutionContext();
                    if (executionContext == null) {
                        throw new DBException("No execution context");
                    }
                    if (SubCollectionsPanel.this.currentPanelRow != null && SubCollectionsPanel.this.currentPanelRow.getState() != 2) {
                        Object object;
                        Object[] values = SubCollectionsPanel.this.currentPanelRow.getValues();
                        if (values.length == 1 && (object = values[0]) instanceof DBDDocument) {
                            void document;
                            DBDDocument dBDDocument = (DBDDocument)object;
                            DBDDocument cfr_ignored_0 = (DBDDocument)object;
                            void var9_7 = document;
                            if (var9_7 instanceof DBCDocumentHierarchical) {
                                void hierarchical;
                                DBCDocumentHierarchical dBCDocumentHierarchical = (DBCDocumentHierarchical)var9_7;
                                DBCDocumentHierarchical cfr_ignored_1 = (DBCDocumentHierarchical)var9_7;
                                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), arg_0 -> this.lambda$0((DBCDocumentHierarchical)hierarchical, monitor, arg_0));
                                UIUtils.syncExec(() -> {
                                    if (SubCollectionsPanel.this.filterTextBox != null && !SubCollectionsPanel.this.filterTextBox.isDisposed() && !CommonUtils.isEmpty((String)SubCollectionsPanel.this.filterTextBox.getText())) {
                                        SubCollectionsPanel.this.subCollectionsList.addAll(this.collections.stream().filter(it -> it.getName().contains(SubCollectionsPanel.this.filterTextBox.getText())).toList());
                                    } else {
                                        SubCollectionsPanel.this.subCollectionsList.addAll(this.collections);
                                    }
                                });
                            }
                        }
                        if (SubCollectionsPanel.this.subCollectionsList.isEmpty() && SubCollectionsPanel.this.deleteAction != null) {
                            SubCollectionsPanel.this.deleteAction.setEnabled(false);
                        }
                        return SubCollectionsPanel.this.subCollectionsList;
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error loading collections");
                }
            }
            return SubCollectionsPanel.this.subCollectionsList;
        }

        private /* synthetic */ void lambda$0(DBCDocumentHierarchical dBCDocumentHierarchical, DBRProgressMonitor dBRProgressMonitor, DBRProgressMonitor param) throws InvocationTargetException, InterruptedException {
            try {
                this.collections = dBCDocumentHierarchical.listChildrenEntities(dBRProgressMonitor);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private class SubEntitiesTable
    extends DatabaseObjectListControl<DBSObject> {
        SubEntitiesTable(Composite parent) {
            super(parent, 0x10000800, (IWorkbenchSite)SubCollectionsPanel.this.presentation.getController().getSite(), (IContentProvider)new TreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return new Object[0];
                }

                public boolean hasChildren(Object element) {
                    return false;
                }
            });
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IAction)SubCollectionsPanel.this.addAction);
            contributionManager.add((IAction)SubCollectionsPanel.this.deleteAction);
            contributionManager.add((IAction)SubCollectionsPanel.this.refreshAction);
            contributionManager.add((IContributionItem)new Separator());
            UIUtils.fillDefaultTreeContextMenu((IContributionManager)contributionManager, (Tree)((Tree)this.getItemsViewer().getControl()));
        }

        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            DBCExecutionContext executionContext = SubCollectionsPanel.this.presentation.getController().getExecutionContext();
            if (executionContext == null) {
                return "SubEntities";
            }
            return "SubEntities/" + executionContext.getDataSource().getContainer().getDriver().getId();
        }

        @Nullable
        protected DBPImage getObjectImage(DBSObject item) {
            return DBIcon.TREE_TABLE;
        }

        protected LoadingJob<Collection<DBSObject>> createLoadService(boolean forUpdate) {
            return LoadingJob.createService((ILoadService)new LoadSubCollectionsService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this){

                public void completeLoading(Collection<DBSObject> items) {
                    super.completeLoading(items);
                    TreeViewer itemsViewer = (TreeViewer)((SubEntitiesTable)SubEntitiesTable.this).SubCollectionsPanel.this.subcollectionsTable.getItemsViewer();
                    if (!itemsViewer.getControl().isDisposed()) {
                        itemsViewer.expandToLevel(2);
                    }
                }
            });
        }
    }
}

