/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.ollama;

import com.dbeaver.model.ai.ollama.OllamaAiCompletionEngine;
import com.dbeaver.ui.ai.openai.AIUIAdvancedMessages;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class OllamaConfigurator
implements IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> {
    private String hostname = "";
    private boolean logQuery = false;
    private Button logQueryCheck;
    private String temperature = "";
    private String model = "";
    private String contextSize = "";
    private Text hostnameText;
    private Text temperatureText;
    private Text contextSizeText;
    private Combo modelCombo;
    private Button listModelsButton;

    public void createControl(@NotNull Composite parent, DAICompletionEngine<?> object, @NotNull Runnable propertyChangeListener) {
        Composite upperComposite = UIUtils.createComposite((Composite)parent, (int)2);
        upperComposite.setLayoutData((Object)new GridData(768));
        this.hostnameText = UIUtils.createLabelText((Composite)upperComposite, (String)AIUIAdvancedMessages.ollama_preference_page_hostname, (String)"", (int)2048);
        this.hostnameText.setLayoutData((Object)new GridData(768));
        this.hostnameText.addModifyListener(e -> {
            this.hostname = this.hostnameText.getText();
            if (this.listModelsButton != null && !this.listModelsButton.isDisposed()) {
                this.modelCombo.setItems(new String[0]);
                this.modelCombo.setEnabled(false);
                this.updateModel();
            }
        });
        this.hostnameText.setMessage(AIUIAdvancedMessages.ollama_preference_page_hostname);
        Composite comboComposite = UIUtils.createComposite((Composite)parent, (int)3);
        comboComposite.setLayoutData((Object)new GridData(768));
        this.modelCombo = UIUtils.createLabelCombo((Composite)comboComposite, (String)AIUIAdvancedMessages.ollama_preference_page_model, (String)"", (int)2056);
        this.modelCombo.setLayoutData((Object)new GridData(768));
        this.modelCombo.setEnabled(false);
        this.modelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OllamaConfigurator.this.model = OllamaConfigurator.this.modelCombo.getText();
            }
        });
        this.listModelsButton = UIUtils.createDialogButton((Composite)comboComposite, (String)"Load models", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AbstractJob("Listing models"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        try {
                            List models = OllamaAiCompletionEngine.loadModels((String)(this).OllamaConfigurator.this.hostname, (DBRProgressMonitor)monitor);
                            UIUtils.syncExec(() -> {
                                (this).OllamaConfigurator.this.modelCombo.setItems(models.toArray(new String[0]));
                                (this).OllamaConfigurator.this.modelCombo.setEnabled(true);
                                int i = 0;
                                while (i < models.size()) {
                                    if (((String)models.get(i)).equals((this).OllamaConfigurator.this.model)) {
                                        (this).OllamaConfigurator.this.modelCombo.select(i);
                                    }
                                    ++i;
                                }
                            });
                        }
                        catch (Exception exception) {
                            UIUtils.syncExec(() -> DBWorkbench.getPlatformUI().showError("Error reading model list", "Failed to read the model list"));
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        Composite bottomComposite = UIUtils.createComposite((Composite)parent, (int)2);
        bottomComposite.setLayoutData((Object)new GridData(768));
        this.contextSizeText = UIUtils.createLabelText((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_context_size, (String)"", (int)2048);
        this.contextSizeText.setLayoutData((Object)new GridData(768));
        this.contextSizeText.addModifyListener(e -> {
            String string = this.contextSize = this.contextSizeText.getText();
        });
        this.contextSizeText.setMessage(AIUIAdvancedMessages.ollama_preference_page_context_size);
        this.contextSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText = UIUtils.createLabelText((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
        UIUtils.createInfoLabel((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_temperature_info, (int)768, (int)2);
        this.logQueryCheck = UIUtils.createCheckbox((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_text_debug, (String)AIUIAdvancedMessages.ollama_preference_page_text_debug_tip, (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OllamaConfigurator.this.logQuery = OllamaConfigurator.this.logQueryCheck.getSelection();
            }
        });
        UIUtils.syncExec(this::applySettings);
    }

    private void updateModel() {
        try {
            new URL(this.hostname);
            this.listModelsButton.setEnabled(true);
        }
        catch (Exception exception) {
            this.listModelsButton.setEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadSettings(@NotNull AIEngineSettings aiEngineSettings) {
        Object v;
        this.hostname = CommonUtils.toString(aiEngineSettings.getProperties().get("ollama.hostname"), (String)"");
        Object size = aiEngineSettings.getProperties().get("ollama.context.size");
        if (size == null) {
            this.contextSizeText.setText("");
        }
        if (size == null) {
            this.contextSizeText.setText("3000");
            this.contextSize = "3000";
        }
        if ((v = size) instanceof Double) {
            void value;
            Double d = (Double)v;
            Double cfr_ignored_0 = (Double)v;
            this.contextSizeText.setText(CommonUtils.toString((Object)value.intValue()));
        } else {
            Object v2 = size;
            if (v2 instanceof Integer) {
                void integer;
                Integer n = (Integer)v2;
                Integer cfr_ignored_1 = (Integer)v2;
                this.contextSizeText.setText(integer.toString());
            }
        }
        this.model = CommonUtils.toString(aiEngineSettings.getProperties().get("ollama.model"), (String)"");
        this.temperature = CommonUtils.toString(aiEngineSettings.getProperties().get("gpt.model.temperature"), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean(aiEngineSettings.getProperties().get("gpt.log.query"));
        this.applySettings();
    }

    public void saveSettings(@NotNull AIEngineSettings aiEngineSettings) {
        aiEngineSettings.getProperties().put("ollama.hostname", this.hostname);
        aiEngineSettings.getProperties().put("ollama.model", this.model);
        aiEngineSettings.getProperties().put("ollama.context.size", Integer.parseInt(this.contextSize));
        aiEngineSettings.getProperties().put("gpt.log.query", this.logQuery);
        aiEngineSettings.getProperties().put("gpt.model.temperature", this.temperature);
    }

    protected void applySettings() {
        this.hostnameText.setText(this.hostname);
        this.temperatureText.setText(this.temperature);
        this.updateModel();
        if (this.listModelsButton.isEnabled()) {
            this.modelCombo.setItems(new String[]{this.model});
            this.modelCombo.select(0);
        }
        this.contextSizeText.setText(this.contextSize);
        this.logQueryCheck.setSelection(this.logQuery);
        this.updateModel();
    }

    public void resetSettings(@NotNull AIEngineSettings aiEngineSettings) {
    }

    public boolean isComplete() {
        return !this.hostnameText.getText().isEmpty() && !this.modelCombo.getText().isEmpty() && !this.contextSizeText.getText().isEmpty();
    }
}

