/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.gemini;

import com.dbeaver.ui.ai.openai.AIUIAdvancedMessages;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class GeminiConfigurator
implements IObjectPropertyConfigurator<DAICompletionEngine<?>, AIEngineSettings> {
    private static final String API_KEY_URL = "https://makersuite.google.com/app/apikey";
    private String token = "";
    private boolean logQuery = false;
    private Button logQueryCheck;
    private Text tokenText;
    private Text temperatureText;
    private String temperature = "0.0";

    public void createControl(@NotNull Composite parent, DAICompletionEngine<?> object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(768));
        this.tokenText = UIUtils.createLabelText((Composite)composite, (String)AIUIAdvancedMessages.gemini_preference_page_token, (String)"", (int)0x400800);
        this.tokenText.setLayoutData((Object)new GridData(768));
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.createURLInfoLink(composite);
        this.tokenText.setMessage(AIUIAdvancedMessages.gemini_preference_page_token_message);
        this.temperatureText = UIUtils.createLabelText((Composite)composite, (String)AIUIAdvancedMessages.gemini_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeminiConfigurator.this.temperature = GeminiConfigurator.this.temperatureText.getText();
            }
        });
        UIUtils.createInfoLabel((Composite)composite, (String)AIUIAdvancedMessages.gemini_preference_page_text_temperature_info, (int)768, (int)2);
        this.logQueryCheck = UIUtils.createCheckbox((Composite)composite, (String)AIUIAdvancedMessages.gemini_preference_page_text_debug, (String)AIUIAdvancedMessages.gemini_preference_page_text_debug_tip, (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeminiConfigurator.this.logQuery = GeminiConfigurator.this.logQueryCheck.getSelection();
            }
        });
        UIUtils.syncExec(this::applySettings);
    }

    public void loadSettings(@NotNull AIEngineSettings aiEngineSettings) {
        this.token = CommonUtils.toString(aiEngineSettings.getProperties().get("gemini.token"), (String)"");
        this.temperature = CommonUtils.toString(aiEngineSettings.getProperties().get("gpt.model.temperature"), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean(aiEngineSettings.getProperties().get("gpt.log.query"));
        this.applySettings();
    }

    public void saveSettings(@NotNull AIEngineSettings aiEngineSettings) {
        aiEngineSettings.getProperties().put("gemini.token", this.token);
        aiEngineSettings.getProperties().put("gpt.log.query", this.logQuery);
        aiEngineSettings.getProperties().put("gpt.model.temperature", this.temperature);
    }

    protected void applySettings() {
        if (this.token != null) {
            this.tokenText.setText(this.token);
        }
        if (this.temperature != null) {
            this.temperatureText.setText(this.temperature);
        }
        this.logQueryCheck.setSelection(this.logQuery);
    }

    public void resetSettings(@NotNull AIEngineSettings aiEngineSettings) {
    }

    public boolean isComplete() {
        return !this.tokenText.getText().isEmpty();
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIAdvancedMessages.gemini_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)GeminiConfigurator.this.getApiKeyURL());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
    }

    protected String getApiKeyURL() {
        return API_KEY_URL;
    }
}

