/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.format;

import com.dbeaver.model.ai.AICompletionJoinRule;
import com.dbeaver.ui.ai.openai.AIUIAdvancedMessages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.format.IAIFormatter;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.format.DefaultFormattingConfigurator;
import org.jkiss.utils.CommonUtils;

public class AdvancedFormattingConfigurator
extends DefaultFormattingConfigurator {
    private Combo joinTypeCombo;
    private Button formatQueryCheck;
    private Button sendConstraintsCheck;
    private Button sendPreviousChatAnswers;
    private Button sendForeignKeysCheck;

    public void createControl(@NotNull Composite parent, IAIFormatter object, @NotNull Runnable propertyChangeListener) {
        super.createControl(parent, object, propertyChangeListener);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        super.loadSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.sendPreviousChatAnswers.setSelection(store.getBoolean("ai.sendPreviousAnswers"));
        this.sendForeignKeysCheck.setSelection(store.getBoolean("ai.useForeignKeys"));
        this.sendConstraintsCheck.setSelection(store.getBoolean("ai.useConstraints"));
        this.formatQueryCheck.setSelection(store.getBoolean("ai.formatSqlQuery"));
        AICompletionJoinRule jr = (AICompletionJoinRule)CommonUtils.valueOf(AICompletionJoinRule.class, (String)store.getString("ai.joinRule"), (Enum)AICompletionJoinRule.DEFAULT);
        this.joinTypeCombo.select(jr.ordinal());
    }

    protected void createAppearanceSettings(Composite appearanceGroup, Runnable propertyChangeListener) {
        super.createAppearanceSettings(appearanceGroup, propertyChangeListener);
        this.formatQueryCheck = UIUtils.createCheckbox((Composite)appearanceGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_query_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_query_tip, (boolean)false, (int)2);
        this.joinTypeCombo = UIUtils.createLabelCombo((Composite)appearanceGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_join_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_join_tip, (int)12);
        AICompletionJoinRule[] aICompletionJoinRuleArray = AICompletionJoinRule.values();
        int n = aICompletionJoinRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AICompletionJoinRule jr = aICompletionJoinRuleArray[n2];
            this.joinTypeCombo.add(jr.getTitle());
            ++n2;
        }
        this.joinTypeCombo.select(0);
    }

    protected void createCompletionSettings(Composite completionGroup, Runnable propertyChangeListener) {
        super.createCompletionSettings(completionGroup, propertyChangeListener);
        this.sendPreviousChatAnswers = UIUtils.createCheckbox((Composite)completionGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_send_previous_chat_answers_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_send_previous_chat_answers_tip, (boolean)true, (int)2);
    }

    protected void createSchemaSettings(Composite schemaGroup) {
        super.createSchemaSettings(schemaGroup);
        this.sendForeignKeysCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_foreign_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_foreign_tip, (boolean)false, (int)2);
        this.sendConstraintsCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_constrains_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_constrains_tip, (boolean)false, (int)2);
    }

    public void saveSettings(@NotNull AISettings aiSettings) {
        super.saveSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.sendPreviousAnswers", this.sendPreviousChatAnswers.getSelection());
        store.setValue("ai.useForeignKeys", this.sendForeignKeysCheck.getSelection());
        store.setValue("ai.useConstraints", this.sendConstraintsCheck.getSelection());
        store.setValue("ai.formatSqlQuery", this.formatQueryCheck.getSelection());
        store.setValue("ai.joinRule", ((AICompletionJoinRule)CommonUtils.fromOrdinal(AICompletionJoinRule.class, (int)this.joinTypeCombo.getSelectionIndex())).name());
    }

    public void resetSettings(@NotNull AISettings aiSettings) {
        super.resetSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setToDefault("ai.useConstraints");
        store.setToDefault("ai.useForeignKeys");
        store.setToDefault("ai.joinRule");
        store.setToDefault("ai.formatSqlQuery");
        store.setToDefault("ai.sendPreviousAnswers");
    }

    public boolean isComplete() {
        return super.isComplete();
    }
}

