/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls.css;

import com.dbeaver.ui.ai.chat.controls.MessageComposite;
import com.dbeaver.ui.ai.chat.model.MessageRole;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.css2.CSSPropertyBackgroundSWTHandler;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.w3c.dom.css.CSSValue;

public class CustomCSSPropertySWTHandler
extends CSSPropertyBackgroundSWTHandler {
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        return switch (property) {
            case "border-color" -> {
                this.applyCSSPropertyBorderColor(element, value, engine);
                yield true;
            }
            case "border-radius" -> {
                this.applyCSSPropertyBorderRadius(element, value, engine);
                yield true;
            }
            default -> super.applyCSSProperty(element, property, value, pseudo, engine);
        };
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return switch (property) {
            case "border-color" -> this.retrieveCSSPropertyBorderColor(element, engine);
            case "border-radius" -> this.retrieveCSSPropertyBorderRadius(element, engine);
            default -> super.retrieveCSSProperty(element, property, pseudo, engine);
        };
    }

    /*
     * WARNING - void declaration
     */
    public String retrieveCSSPropertyBackgroundColor(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof MessageComposite) {
            void composite;
            MessageComposite messageComposite = (MessageComposite)widget;
            MessageComposite cfr_ignored_0 = (MessageComposite)widget;
            return engine.convert((Object)CustomCSSPropertySWTHandler.getBackgroundColor((MessageComposite)composite), Color.class, null);
        }
        return super.retrieveCSSPropertyBackgroundColor(element, pseudo, engine);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private String retrieveCSSPropertyBorderColor(@NotNull Object element, @NotNull CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof MessageComposite) {
            void composite;
            MessageComposite messageComposite = (MessageComposite)widget;
            MessageComposite cfr_ignored_0 = (MessageComposite)widget;
            return engine.convert((Object)CustomCSSPropertySWTHandler.getBorderColor((MessageComposite)composite), Color.class, null);
        }
        return "none";
    }

    @NotNull
    private String retrieveCSSPropertyBorderRadius(@NotNull Object element, @NotNull CSSEngine engine) throws Exception {
        return "0";
    }

    /*
     * WARNING - void declaration
     */
    public void applyCSSPropertyBackgroundColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof MessageComposite) {
            void composite;
            MessageComposite messageComposite = (MessageComposite)widget;
            MessageComposite cfr_ignored_0 = (MessageComposite)widget;
            composite.setBackground(CustomCSSPropertySWTHandler.getBackgroundColor((MessageComposite)composite));
        } else {
            super.applyCSSPropertyBackgroundColor(element, value, pseudo, engine);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyCSSPropertyBorderColor(@NotNull Object element, @NotNull CSSValue value, @NotNull CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof MessageComposite) {
            void composite;
            MessageComposite messageComposite = (MessageComposite)widget;
            MessageComposite cfr_ignored_0 = (MessageComposite)widget;
            composite.setBorder(CustomCSSPropertySWTHandler.getBorderColor((MessageComposite)composite));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyCSSPropertyBorderRadius(@NotNull Object element, @NotNull CSSValue value, @NotNull CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof MessageComposite) {
            void composite;
            MessageComposite messageComposite = (MessageComposite)widget;
            MessageComposite cfr_ignored_0 = (MessageComposite)widget;
            composite.setBorderRadius(Integer.parseInt(value.getCssText()));
        }
    }

    @NotNull
    private static Color getBackgroundColor(@NotNull MessageComposite composite) {
        ColorRegistry registry = UIUtils.getColorRegistry();
        return switch (composite.getMessage().role()) {
            case MessageRole.ASSISTANT -> registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.response.background");
            case MessageRole.USER -> registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.prompt.background");
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @NotNull
    private static Color getBorderColor(@NotNull MessageComposite composite) {
        ColorRegistry registry = UIUtils.getColorRegistry();
        return switch (composite.getMessage().role()) {
            case MessageRole.ASSISTANT -> registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.response.border");
            case MessageRole.USER -> registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.prompt.border");
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

