/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.ui.ai.chat.AIChatEditorPresentation;
import com.dbeaver.ui.ai.chat.AIChatListener;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

public class PromptComposite
extends Composite {
    private final AIChatEditorPresentation presentation;
    private final Text promptText;

    public PromptComposite(@NotNull AIChatEditorPresentation presentation, @NotNull Composite parent) {
        super(parent, 0);
        this.presentation = presentation;
        this.presentation.addListener(new AIChatListener(){

            @Override
            public void busyChanged(boolean busy) {
                UIUtils.enableWithChildren((Control)PromptComposite.this, (!busy ? 1 : 0) != 0);
                if (!busy) {
                    PromptComposite.this.setFocusOnPrompt();
                }
            }
        });
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.promptText = new Text((Composite)this, 2626);
        this.promptText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.promptText.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 13 && (e.stateMask & 0x40000) != 0) {
                presentation.submitPrompt(this.promptText.getText());
                e.doit = false;
            }
        }));
        this.promptText.addModifyListener(e -> {
            int lines = this.promptText.getLineCount();
            int height = this.promptText.getLineHeight() * CommonUtils.clamp((int)lines, (int)2, (int)10);
            GridData data = (GridData)this.promptText.getLayoutData();
            if (data.heightHint != height) {
                data.heightHint = height;
                Composite container = this.getParent();
                container.setRedraw(false);
                container.layout(true, true);
                container.setRedraw(true);
            }
        });
        Composite buttonsPanel = new Composite((Composite)this, 0);
        buttonsPanel.setLayoutData((Object)new GridData(4, 0x1000008, false, false));
        buttonsPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Button sendButton = new Button(buttonsPanel, 8);
        sendButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        sendButton.setText(AIChatMessages.ai_chat_send_button_label);
        sendButton.setToolTipText(AIChatMessages.ai_chat_send_button_tip);
        sendButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_EXECUTE));
        sendButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> presentation.submitPrompt(this.promptText.getText())));
        ToolBar toolBar = new ToolBar(buttonsPanel, 8519936);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ToolBarManager manager = new ToolBarManager(toolBar);
        this.contributeActions((IContributionManager)manager);
        manager.update(true);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)presentation.getEditor().getSite(), (Control)this.promptText);
        UIUtils.addEmptyTextHint((Control)this.promptText, text -> AIChatMessages.ai_chat_prompt_text_hint);
    }

    public void setPromptText(@NotNull String text) {
        this.promptText.setText(text);
    }

    public void setFocusOnPrompt() {
        this.promptText.setFocus();
        this.promptText.notifyListeners(24, new Event());
    }

    private void contributeActions(@NotNull IContributionManager manager) {
        this.presentation.contributeActions(manager);
    }
}

