/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.ui.ai.chat.AIChatEditorPresentation;
import com.dbeaver.ui.ai.chat.AIChatListener;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import com.dbeaver.ui.ai.chat.model.Message;
import com.dbeaver.ui.ai.chat.model.MessageRole;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.MessageChunk;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

public class MessageComposite
extends Composite {
    private static final Log log = Log.getLog(MessageComposite.class);
    private static final String CSS_CLASS = "ai-chat-message";
    private final AIChatEditorPresentation presentation;
    private final SQLEditor editor;
    private final Message message;
    private int borderRadius;
    private Color border;

    /*
     * WARNING - void declaration
     */
    public MessageComposite(@NotNull AIChatEditorPresentation presentation, @NotNull Composite parent, @NotNull Message message) {
        super(parent, 0);
        this.presentation = presentation;
        this.editor = presentation.getEditor();
        this.message = message;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.setData(message);
        CSSUtils.setCSSClass((Widget)this, (String)CSS_CLASS);
        Label avatarLabel = UIUtils.createLabel((Composite)this, (DBPImage)message.role().getIcon());
        avatarLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        avatarLabel.setToolTipText(NLS.bind((String)AIChatMessages.ai_chat_message_info_tip, (Object)message.role().getLabel(), (Object)message.time().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM))));
        Composite holder = new Composite((Composite)this, 0);
        holder.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(message.role() == MessageRole.USER ? 2 : 1).create());
        holder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        CSSUtils.setCSSClass((Widget)holder, (String)CSS_CLASS);
        MessageChunk[] messageChunkArray = message.chunks();
        int n = messageChunkArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageChunk chunk = messageChunkArray[n2];
            MessageChunk messageChunk = chunk;
            if (messageChunk instanceof MessageChunk.Text) {
                void text;
                MessageChunk.Text cfr_ignored_0 = (MessageChunk.Text)messageChunk;
                MessageChunk.Text cfr_ignored_1 = (MessageChunk.Text)messageChunk;
                this.createTextControl(holder, text.text());
            } else {
                MessageChunk messageChunk2 = chunk;
                if (messageChunk2 instanceof MessageChunk.Code) {
                    void code;
                    MessageChunk.Code cfr_ignored_2 = (MessageChunk.Code)messageChunk2;
                    MessageChunk.Code cfr_ignored_3 = (MessageChunk.Code)messageChunk2;
                    Composite inner = new Composite(holder, 2048);
                    inner.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
                    inner.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                    inner.setBackground(this.getDisplay().getSystemColor(22));
                    inner.setBackgroundMode(0);
                    this.createSqlToolbar(inner, code.text());
                    UIUtils.createLabelSeparator((Composite)inner, (int)256);
                    try {
                        this.createSqlControl(inner, code.text());
                    }
                    catch (Exception e2) {
                        log.debug((Object)"Can't create SQL panel", (Throwable)e2);
                        this.createTextControl(inner, code.text());
                    }
                }
            }
            ++n2;
        }
        if (message.role() == MessageRole.USER) {
            this.createPromptToolbar(holder);
        }
        this.addPaintListener(e -> {
            GC gc = e.gc;
            Point size = this.getSize();
            int radius = this.borderRadius;
            if (radius > 0) {
                gc.setBackground(this.getParent().getBackground());
                gc.fillRectangle(0, 0, radius, radius);
                gc.fillRectangle(size.x - radius, 0, radius, radius);
                gc.fillRectangle(0, size.y - radius, radius, radius);
                gc.fillRectangle(size.x - radius, size.y - radius, radius, radius);
            }
            gc.setBackground(this.getBackground());
            gc.fillRoundRectangle(0, 0, size.x, size.y, radius, radius);
            if (this.border != null) {
                gc.setForeground(this.border);
                gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, radius, radius);
            }
        });
    }

    @NotNull
    public Message getMessage() {
        return this.message;
    }

    private void createPromptToolbar(@NotNull Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 8519936);
        toolBar.setLayoutData((Object)new GridData(1, 1, false, false));
        UIUtils.createToolItem((ToolBar)toolBar, (String)AIChatMessages.ai_chat_message_clear_up_to_here_tip, (DBPImage)UIIcon.CLEAN, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.clearToHere()));
        AIChatListener listener = new AIChatListener(){

            @Override
            public void busyChanged(boolean busy) {
                UIUtils.enableWithChildren((Control)toolBar, (!busy ? 1 : 0) != 0);
            }
        };
        this.presentation.addListener(listener);
        toolBar.addDisposeListener(e -> this.presentation.removeListener(listener));
    }

    private void createSqlToolbar(@NotNull Composite parent, @NotNull String text) {
        ToolBar toolBar = new ToolBar(parent, 8519936);
        UIUtils.createToolItem((ToolBar)toolBar, (String)AIChatMessages.ai_chat_message_execute_query_label, (String)AIChatMessages.ai_chat_message_execute_query_tip, (DBPImage)UIIcon.SQL_EXECUTE, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.executeQuery(text)));
        UIUtils.createToolItem((ToolBar)toolBar, (String)AIChatMessages.ai_chat_message_copy_to_editor_label, (String)AIChatMessages.ai_chat_message_copy_to_editor_tip, (DBPImage)UIIcon.LINK_TO_EDITOR, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.copyToEditor(text)));
        UIUtils.createToolItem((ToolBar)toolBar, (String)AIChatMessages.ai_chat_message_copy_to_clipboard_label, (String)AIChatMessages.ai_chat_message_copy_to_clipboard_tip, (DBPImage)UIIcon.FILTER_CLIPBOARD, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.copyToClipboard(text)));
    }

    public void setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
    }

    public void setBorder(@NotNull Color borderColor) {
        this.border = borderColor;
    }

    private void createTextControl(@NotNull Composite parent, @NotNull String text) {
        Label bodyLabel = new Label(parent, 64);
        bodyLabel.setText(text);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = Math.min(bodyLabel.computeSize((int)-1, (int)-1).x, 400);
        bodyLabel.setLayoutData((Object)gd);
    }

    /*
     * WARNING - void declaration
     */
    private void createSqlControl(@NotNull Composite parent, @NotNull String text) throws DBException {
        Object panel;
        UIServiceSQL service = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (service == null) {
            throw new DBException("SQL service is not available");
        }
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        gd.heightHint = 100;
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayoutData((Object)gd);
        placeholder.setLayout((Layout)new FillLayout());
        Object object = panel = service.createSQLPanel((Object)this.editor.getSite(), (Object)placeholder, (DBPContextProvider)this.editor, "AI Chat message", true, text);
        if (object instanceof TextViewer) {
            void viewer;
            TextViewer textViewer = (TextViewer)object;
            TextViewer cfr_ignored_0 = (TextViewer)object;
            StyledText widget = viewer.getTextWidget();
            widget.setAlwaysShowScrollBars(false);
            Point size = widget.computeSize(-1, -1);
            gd.widthHint = Math.min(size.x + 37, 500);
            gd.heightHint = Math.min(size.y, 150);
        }
    }

    private void clearToHere() {
        if (DBWorkbench.getPlatformUI().confirmAction(AIChatMessages.ai_chat_clear_history_confirm_title, AIChatMessages.ai_chat_clear_history_partial_confirm_message)) {
            this.presentation.clearMessages(this.message);
        }
    }

    private void executeQuery(@NotNull String text) {
        this.presentation.executeQuery(text);
    }

    private void copyToClipboard(@NotNull String text) {
        UIUtils.setClipboardContents((Display)this.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text);
    }

    private void copyToEditor(@NotNull String text) {
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        IDocument document = this.editor.getDocument();
        if (document != null && selection instanceof TextSelection) {
            try {
                int offset = ((TextSelection)selection).getOffset();
                int length = ((TextSelection)selection).getLength();
                SQLScriptElement query = this.editor.extractQueryAtPos(offset);
                if (query != null) {
                    offset = query.getOffset();
                    length = query.getLength();
                }
                document.replace(offset, length, text);
                this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + text.length(), 0));
                this.editor.showExtraPresentation(null);
            }
            catch (BadLocationException ex) {
                DBWorkbench.getPlatformUI().showError("Insert SQL", "Error inserting SQL completion in text editor", (Throwable)ex);
            }
        }
    }
}

