/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.ui.ai.chat.AIChatEditorPresentation;
import com.dbeaver.ui.ai.chat.AIChatListener;
import com.dbeaver.ui.ai.chat.controls.MessageComposite;
import com.dbeaver.ui.ai.chat.model.Message;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;

public class ChatComposite
extends Composite {
    private final AIChatEditorPresentation presentation;

    public ChatComposite(@NotNull AIChatEditorPresentation presentation, @NotNull Composite parent) {
        super(parent, 0);
        this.presentation = presentation;
        this.presentation.addListener(new AIChatListener(){

            @Override
            public void messageAdded(@NotNull Message message) {
                ChatComposite.this.addMessage(message);
            }

            @Override
            public void messageRemoved(@NotNull Message message) {
                ChatComposite.this.removeMessage(message);
            }
        });
        this.setLayout((Layout)new GridLayout(1, false));
        CSSUtils.setCSSClass((Widget)this, (String)"ai-chat");
    }

    private void addMessage(@NotNull Message message) {
        new MessageComposite(this.presentation, this, message);
        this.layoutComposite();
    }

    private void removeMessage(@NotNull Message message) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData() == message) {
                child.dispose();
                this.layoutComposite();
                break;
            }
            ++n2;
        }
    }

    private void layoutComposite() {
        Composite parent = this.getParent();
        parent.layout(true, true);
        ScrolledComposite container = (ScrolledComposite)parent.getParent();
        container.setMinSize(parent.computeSize(-1, -1));
        UIUtils.asyncExec(() -> container.setOrigin(0, Integer.MAX_VALUE));
    }
}

