/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat;

import com.dbeaver.ui.ai.chat.AIChatController;
import com.dbeaver.ui.ai.chat.AIChatListener;
import com.dbeaver.ui.ai.chat.controls.ChatComposite;
import com.dbeaver.ui.ai.chat.controls.PromptComposite;
import com.dbeaver.ui.ai.chat.internal.AIChatFeatures;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import com.dbeaver.ui.ai.chat.model.Message;
import com.dbeaver.ui.ai.chat.model.MessageRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.AIFormatterRegistry;
import org.jkiss.dbeaver.model.ai.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.MessageChunk;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionContext;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionEngine;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionMessage;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionResponse;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSession;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionSettings;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.CustomSelectionProvider;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.ai.AIUIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.controls.ScopeConfigDialog;
import org.jkiss.dbeaver.ui.editors.sql.ai.controls.ScopeSelectorControl;
import org.jkiss.utils.CommonUtils;

public class AIChatEditorPresentation
implements SQLEditorPresentation,
AIChatController {
    private static final boolean SHOW_DEBUG_MESSAGES = false;
    private static final Message[] DEBUG_MESSAGES = new Message[]{new Message(MessageRole.USER, AITextUtils.splitIntoChunks((String)"I need a list of all albums")), new Message(MessageRole.ASSISTANT, AITextUtils.splitIntoChunks((String)"Sure! To get a list of all albums, you can use the following SQL query:\n```sql\nSELECT *\nFROM Album;\n```\nThis query selects all columns from the \"Album\" table. It will return a result set containing all the albums in the database.")), new Message(MessageRole.USER, AITextUtils.splitIntoChunks((String)"Can albums be sorted alphabetically by name?")), new Message(MessageRole.ASSISTANT, AITextUtils.splitIntoChunks((String)"Yes, albums can be sorted alphabetically by name. Would you like the list of albums to be sorted in ascending or descending order?")), new Message(MessageRole.USER, AITextUtils.splitIntoChunks((String)"In ascending order")), new Message(MessageRole.ASSISTANT, AITextUtils.splitIntoChunks((String)"Sure! To get a list of all albums sorted alphabetically by name in ascending order, you can use the following SQL query:\n```sql\nSELECT *\nFROM Album\nORDER BY Title ASC;\n```\nThis query selects all columns from the \"Album\" table and sorts the results by the \"Title\" column in ascending order.")), new Message(MessageRole.USER, AITextUtils.splitIntoChunks((String)"Can you show just the query without your comments, please? Just reply with the query")), new Message(MessageRole.ASSISTANT, AITextUtils.splitIntoChunks((String)"SELECT * FROM Album ORDER BY Title ASC;"))};
    private final List<AIChatListener> listeners = new ArrayList<AIChatListener>();
    private final List<Message> messages = new ArrayList<Message>();
    private SQLEditor editor;
    private DAICompletionSession session;
    private DAICompletionSettings settings;
    private SQLEditorListenerDefault editorListener;
    private ChatComposite chatComposite;
    private PromptComposite promptComposite;
    private DBCExecutionContext executionContext;
    private DAICompletionScope scope;
    private Set<String> checkedObjectIds;

    public void createPresentation(Composite parent, final SQLEditor editor) {
        this.editor = editor;
        this.session = new DAICompletionSession();
        this.settings = new DAICompletionSettings(editor.getDataSourceContainer());
        this.executionContext = editor.getExecutionContext();
        this.scope = this.settings.getScope();
        this.checkedObjectIds = new HashSet<String>(List.of(this.settings.getCustomObjectIds()));
        this.addListener(new AIChatListener(){
            private final Map<Message, DAICompletionMessage> mapping = new HashMap<Message, DAICompletionMessage>();

            @Override
            public void messageAdded(@NotNull Message message) {
                DAICompletionMessage mapped = new DAICompletionMessage(message.role() == MessageRole.ASSISTANT ? DAICompletionMessage.Role.ASSISTANT : DAICompletionMessage.Role.USER, message.toRawString());
                this.mapping.put(message, mapped);
                AIChatEditorPresentation.this.session.add(mapped);
            }

            @Override
            public void messageRemoved(@NotNull Message message) {
                AIChatEditorPresentation.this.session.remove(this.mapping.remove(message));
            }
        });
        Composite container = new Composite(parent, 0);
        container.setBackgroundMode(2);
        container.setLayout((Layout)new GridLayout());
        this.chatComposite = this.createChatControl(container);
        UIUtils.createLabelSeparator((Composite)container, (int)256);
        this.promptComposite = this.createPromptControl(container);
        WidgetElement.applyStyles((Widget)container, (boolean)true);
        this.editorListener = new SQLEditorListenerDefault(){

            public void onDataSourceChanged(DBPPreferenceListener.PreferenceChangeEvent event) {
                AIChatEditorPresentation.this.settings = new DAICompletionSettings(editor.getDataSourceContainer());
                AIChatEditorPresentation.this.executionContext = editor.getExecutionContext();
            }
        };
        editor.addListener((SQLEditorListener)this.editorListener);
        UIUtils.asyncExec(() -> {
            editor.setEditorMaximized(false);
            this.promptComposite.setFocusOnPrompt();
        });
        AIChatFeatures.AI_CHAT.use();
    }

    public boolean canShowPresentation(@NotNull SQLEditor editor, boolean isNew) {
        if (editor.getDataSourceContainer() == null || editor.getExecutionContext() == null) {
            DBWorkbench.getPlatformUI().showError("AI Chat", "Can't determine active data source.\nMake sure the active data source is set and the connection is established.");
            return false;
        }
        DBPDataSourceContainer container = editor.getDataSourceContainer();
        return container != null && AIUIUtils.confirmMetaTransfer((DAICompletionSettings)new DAICompletionSettings(container), (DBPDataSourceContainer)container);
    }

    public void dispose() {
        this.editor.removeListener((SQLEditorListener)this.editorListener);
        this.editor = null;
    }

    public ISelectionProvider getSelectionProvider() {
        return new CustomSelectionProvider();
    }

    @Override
    public void addMessage(@NotNull Message message) {
        this.messages.add(message);
        this.notifyListeners(AIChatListener::messageAdded, message);
    }

    @Override
    public void removeMessage(@NotNull Message message) {
        int index = this.messages.indexOf(message);
        if (index >= 0) {
            this.clearMessages(this.messages.subList(index, index + 1));
        }
    }

    @Override
    public void clearMessages() {
        this.clearMessages(this.messages);
    }

    @Override
    public void clearMessages(@NotNull Message afterInclusive) {
        int index = this.messages.indexOf(afterInclusive);
        if (index >= 0) {
            this.clearMessages(this.messages.subList(index, this.messages.size()));
            this.promptComposite.setPromptText(afterInclusive.toRawString());
        }
    }

    private void clearMessages(@NotNull Collection<Message> view) {
        view.forEach(message -> this.notifyListeners(AIChatListener::messageRemoved, message));
        view.clear();
    }

    @Override
    public void addListener(@NotNull AIChatListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull AIChatListener listener) {
        this.listeners.remove(listener);
    }

    private <T> void notifyListeners(@NotNull BiConsumer<AIChatListener, T> consumer, @NotNull T payload) {
        AIChatListener[] aIChatListenerArray = (AIChatListener[])this.listeners.toArray(AIChatListener[]::new);
        int n = aIChatListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            AIChatListener listener = aIChatListenerArray[n2];
            consumer.accept(listener, (AIChatListener)payload);
            ++n2;
        }
    }

    public void submitPrompt(@NotNull String prompt) {
        String trimmed = prompt.trim();
        if (trimmed.isEmpty()) {
            return;
        }
        Message promptMessage = new Message(MessageRole.USER, new MessageChunk[]{new MessageChunk.Text(trimmed)});
        this.addMessage(promptMessage);
        this.notifyListeners(AIChatListener::busyChanged, true);
        this.performSessionCompletion().whenComplete((response, throwable) -> UIUtils.syncExec(() -> {
            if (this.promptComposite.isDisposed()) {
                return;
            }
            if (response != null) {
                Message responseMessage = new Message(MessageRole.ASSISTANT, AITextUtils.splitIntoChunks((String)CommonUtils.notEmpty((String)response.getResultCompletion())));
                this.addMessage(responseMessage);
                this.promptComposite.setPromptText("");
                if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.executeImmediately")) {
                    MessageChunk[] messageChunkArray = responseMessage.chunks();
                    int n = messageChunkArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MessageChunk chunk = messageChunkArray[n2];
                        MessageChunk messageChunk = chunk;
                        if (messageChunk instanceof MessageChunk.Code) {
                            void code;
                            MessageChunk.Code code2 = (MessageChunk.Code)messageChunk;
                            MessageChunk.Code cfr_ignored_0 = (MessageChunk.Code)messageChunk;
                            this.executeQuery(code.text());
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                this.removeMessage(promptMessage);
            }
            this.notifyListeners(AIChatListener::busyChanged, false);
        }));
    }

    public void executeQuery(@NotNull String text) {
        SQLQuery query = new SQLQuery(this.editor.getDataSource(), SQLUtils.removeQueryDelimiter((SQLDialect)this.editor.getDataSource().getSQLDialect(), (String)text));
        this.editor.processQueries(List.of(query), false, false, false, true, null, null);
    }

    @NotNull
    public SQLEditor getEditor() {
        return this.editor;
    }

    public void contributeActions(@NotNull IContributionManager manager) {
        manager.add((IAction)new ChangeScopeSelectorAction());
        manager.add((IAction)new Action(AIChatMessages.ai_chat_clear_history_label, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CLEAN)){

            public void run() {
                if (DBWorkbench.getPlatformUI().confirmAction(AIChatMessages.ai_chat_clear_history_confirm_title, AIChatMessages.ai_chat_clear_history_confirm_message)) {
                    AIChatEditorPresentation.this.clearMessages();
                }
            }
        });
        manager.add((IAction)new Action(AIChatMessages.ai_chat_settings_label, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION)){

            public void run() {
                UIUtils.showPreferencesFor(null, null, (String[])new String[]{"org.jkiss.dbeaver.preferences.ai"});
            }
        });
    }

    @NotNull
    private ChatComposite createChatControl(@NotNull Composite parent) {
        ScrolledComposite host = new ScrolledComposite(parent, 512);
        host.setBackgroundMode(2);
        host.setExpandVertical(true);
        host.setExpandHorizontal(true);
        host.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite wrapper = new Composite((Composite)host, 0);
        wrapper.setBackgroundMode(2);
        wrapper.setLayout((Layout)new GridLayout());
        ChatComposite chat = new ChatComposite(this, wrapper);
        chat.setBackgroundMode(2);
        chat.setLayoutData(new GridData(4, 0x1000008, true, true));
        host.setContent((Control)wrapper);
        host.setMinSize(wrapper.computeSize(-1, -1));
        wrapper.addPaintListener(e -> {
            if (this.messages.isEmpty()) {
                UIUtils.drawMessageOverControl((Control)wrapper, (PaintEvent)e, (String)AIChatMessages.ai_chat_empty_hint, (int)0);
            }
        });
        return chat;
    }

    @NotNull
    private PromptComposite createPromptControl(@NotNull Composite parent) {
        PromptComposite composite = new PromptComposite(this, parent);
        composite.setBackgroundMode(1);
        composite.setLayoutData(new GridData(4, 0x1000008, true, false));
        return composite;
    }

    @NotNull
    private DBSLogicalDataSource createLogicalDataSource(@NotNull DBCExecutionContext executionContext) {
        DBSLogicalDataSource dataSource = new DBSLogicalDataSource(this.editor.getDataSourceContainer(), "AI logical wrapper", null);
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        if (contextDefaults != null) {
            if (contextDefaults.getDefaultCatalog() != null) {
                dataSource.setCurrentCatalog(contextDefaults.getDefaultCatalog().getName());
            }
            if (contextDefaults.getDefaultSchema() != null) {
                dataSource.setCurrentSchema(contextDefaults.getDefaultSchema().getName());
            }
        }
        return dataSource;
    }

    @NotNull
    private CompletableFuture<DAICompletionResponse> performSessionCompletion() {
        DAICompletionEngine engine;
        try {
            engine = AIEngineRegistry.getInstance().getCompletionEngine(AISettingsRegistry.getInstance().getSettings().getActiveEngine());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("AI error", "Cannot determine AI engine", (Throwable)e);
            return CompletableFuture.failedFuture(new DBException("Cannot determine AI engine", (Throwable)e));
        }
        if (!engine.isValidConfiguration()) {
            DBWorkbench.getPlatformUI().showError("Bad AI engine configuration", "You must specify OpenAI API token in preferences");
            return CompletableFuture.failedFuture(new DBException("Invalid AI engine configuration"));
        }
        final CompletableFuture<DAICompletionResponse> future = new CompletableFuture<DAICompletionResponse>();
        new AbstractJob("AI completion"){

            protected IStatus run(DBRProgressMonitor monitor) {
                List responses;
                DAICompletionContext context = new DAICompletionContext.Builder().setScope(AIChatEditorPresentation.this.scope).setCustomEntities(ScopeSelectorControl.loadCustomEntities((DBRProgressMonitor)monitor, (DBPDataSource)AIChatEditorPresentation.this.executionContext.getDataSource(), AIChatEditorPresentation.this.checkedObjectIds)).setDataSource(AIChatEditorPresentation.this.createLogicalDataSource(AIChatEditorPresentation.this.executionContext)).setExecutionContext(AIChatEditorPresentation.this.executionContext).build();
                try {
                    responses = engine.performSessionCompletion(monitor, context, AIChatEditorPresentation.this.session, AIFormatterRegistry.getInstance().getFormatter("core"), DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.sendPreviousAnswers"));
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Auto completion error", null, (Throwable)e);
                    future.completeExceptionally((Throwable)new DBException("Auto completion error", (Throwable)e));
                    return Status.OK_STATUS;
                }
                if (responses.isEmpty()) {
                    DBWorkbench.getPlatformUI().showError("AI error", "No smart completions returned");
                    future.completeExceptionally((Throwable)new DBException("No smart completions returned"));
                    return Status.OK_STATUS;
                }
                future.complete((DAICompletionResponse)responses.get(0));
                return Status.OK_STATUS;
            }
        }.schedule();
        return future;
    }

    private boolean chooseCustomScope() {
        ScopeConfigDialog dialog = new ScopeConfigDialog(this.editor.getSite().getShell(), this.checkedObjectIds, this.executionContext.getDataSource());
        if (dialog.open() != 0) {
            return false;
        }
        this.checkedObjectIds.clear();
        this.checkedObjectIds.addAll(dialog.getCheckedObjectIds());
        return true;
    }

    private class ChangeScopeChoiceAction
    extends Action {
        private final DAICompletionScope scope;

        public ChangeScopeChoiceAction(DAICompletionScope scope) {
            super(scope.getTitle(), 8);
            this.scope = scope;
            this.setChecked(AIChatEditorPresentation.this.scope == scope);
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            if (this.scope == DAICompletionScope.CUSTOM && !AIChatEditorPresentation.this.chooseCustomScope()) {
                return;
            }
            AIChatEditorPresentation.this.scope = this.scope;
            AIChatEditorPresentation.this.settings.setScope(this.scope);
            AIChatEditorPresentation.this.settings.setCustomObjectIds((String[])AIChatEditorPresentation.this.checkedObjectIds.toArray(String[]::new));
            AIChatEditorPresentation.this.settings.saveSettings();
        }
    }

    private class ChangeScopeSelectorAction
    extends Action {
        public ChangeScopeSelectorAction() {
            super(AIChatMessages.ai_chat_change_scope_label, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER_CONFIG));
        }

        public void run() {
            AIChatEditorPresentation.this.chooseCustomScope();
        }

        public IMenuCreator getMenuCreator() {
            return new MenuCreator(control -> {
                MenuManager manager = new MenuManager();
                DAICompletionScope[] dAICompletionScopeArray = DAICompletionScope.values();
                int n = dAICompletionScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DAICompletionScope scope = dAICompletionScopeArray[n2];
                    manager.add((IAction)new ChangeScopeChoiceAction(scope));
                    ++n2;
                }
                return manager;
            });
        }
    }
}

