/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.azure;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ai.openai.OpenAiConfigurator;
import org.jkiss.utils.CommonUtils;

public class AzureConfigurator
extends OpenAiConfigurator {
    private Text endpointText;
    private Text deploymentText;
    private String endpoint = "https://<RESOURCE>.openai.azure.com/";
    private String deployment = "";

    protected void createConnectionParameters(@NotNull Composite parent) {
        super.createConnectionParameters(parent);
        this.endpointText = UIUtils.createLabelText((Composite)parent, (String)"Endpoint", (String)"", (int)2048);
        this.endpointText.setLayoutData((Object)new GridData(768));
        this.endpointText.addModifyListener(e -> {
            String string = this.endpoint = this.endpointText.getText();
        });
        this.deploymentText = UIUtils.createLabelText((Composite)parent, (String)"Deployment", (String)"", (int)2048);
        this.deploymentText.setLayoutData((Object)new GridData(768));
        this.deploymentText.addModifyListener(e -> {
            String string = this.deployment = this.deploymentText.getText();
        });
        this.deploymentText.setMessage("The deployment name you chose when you deployed the model.");
    }

    public void loadSettings(@NotNull AIEngineSettings aiSettings) {
        this.endpoint = CommonUtils.toString(aiSettings.getProperties().get("azure.endpoint.url"), (String)this.endpoint);
        this.deployment = CommonUtils.toString(aiSettings.getProperties().get("azure.deployment"), (String)this.deployment);
        super.loadSettings(aiSettings);
    }

    protected void applySettings() {
        super.applySettings();
        this.endpointText.setText(this.endpoint);
        this.deploymentText.setText(this.deployment);
    }

    public void saveSettings(@NotNull AIEngineSettings aiSettings) {
        super.saveSettings(aiSettings);
        aiSettings.getProperties().put("azure.endpoint.url", this.endpoint);
        aiSettings.getProperties().put("azure.deployment", this.deployment);
    }

    public boolean isComplete() {
        return super.isComplete();
    }

    protected boolean isUsesModel() {
        return false;
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
    }
}

