/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.ui.notation;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotation;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationBase;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class BachmanDiagramNotation
extends ERDNotationBase
implements ERDNotation {
    public void applyNotationForArrows(@NotNull DBRProgressMonitor monitor, @NotNull PolylineConnection conn, @NotNull ERDAssociation association, @NotNull Color bckColor, @NotNull Color frgColor) {
        DBSEntityConstraintType constraintType = ((DBSEntityAssociation)association.getObject()).getConstraintType();
        if (constraintType == DBSEntityConstraintType.PRIMARY_KEY) {
            AssociationPart.CircleDecoration sourceDecor = new AssociationPart.CircleDecoration();
            sourceDecor.setRadius(4);
            sourceDecor.setFill(true);
            sourceDecor.setBackgroundColor(frgColor);
            conn.setSourceDecoration((RotatableDecoration)sourceDecor);
        } else if (constraintType.isAssociation() && association.getSourceEntity() instanceof ERDEntity && association.getTargetEntity() instanceof ERDEntity) {
            PolygonDecoration sourceDecor = new PolygonDecoration();
            sourceDecor.setTemplate(PolygonDecoration.TRIANGLE_TIP);
            sourceDecor.setScale(15.0, 5.0);
            sourceDecor.setFill(true);
            sourceDecor.setBackgroundColor(frgColor);
            ConnectionEndpointLocator srcEndpointLocator = new ConnectionEndpointLocator((Connection)conn, false);
            srcEndpointLocator.setVDistance(-4);
            conn.add((IFigure)this.getLabel("1..n", frgColor), (Object)srcEndpointLocator);
            conn.setSourceDecoration((RotatableDecoration)sourceDecor);
            if (ERDUtils.isOptionalAssociation((ERDAssociation)association)) {
                AssociationPart.CircleDecoration targetDecor = new AssociationPart.CircleDecoration();
                targetDecor.setRadius(4);
                targetDecor.setFill(true);
                targetDecor.setBackgroundColor(bckColor);
                ConnectionEndpointLocator trgEndpointLocator = new ConnectionEndpointLocator((Connection)conn, true);
                trgEndpointLocator.setVDistance(-4);
                conn.add((IFigure)this.getLabel("0..1", frgColor), (Object)trgEndpointLocator);
                conn.setTargetDecoration((RotatableDecoration)targetDecor);
            } else {
                AssociationPart.CircleDecoration targetDecor = new AssociationPart.CircleDecoration();
                targetDecor.setRadius(4);
                targetDecor.setFill(true);
                targetDecor.setBackgroundColor(frgColor);
                ConnectionEndpointLocator trgEndpointLocator = new ConnectionEndpointLocator((Connection)conn, true);
                trgEndpointLocator.setVDistance(-4);
                conn.add((IFigure)this.getLabel("1", frgColor), (Object)trgEndpointLocator);
                conn.setTargetDecoration((RotatableDecoration)targetDecor);
            }
        }
        conn.setLineWidth(1);
        conn.setLineStyle(6);
    }

    public void applyNotationForEntities(@NotNull PolylineConnection conn, @NotNull ERDAssociation association, @NotNull Color bckColor, @NotNull Color frgColor) {
    }

    public double getIndentation() {
        return 25.0;
    }
}

