/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import org.eclipse.draw2d.geometry.Point;

public class RouteLine {
    private final int dx;
    private final int dy;
    private final double len;
    private final double length;
    private final double nx;
    private final double ny;
    private final double angel;
    private Point p1;
    private Point p2;

    public RouteLine(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.dx = p2.x - p1.x;
        this.dy = p2.y - p1.y;
        this.length = Math.hypot(this.dx, this.dy);
        this.len = Math.hypot(p1.x, p2.y);
        this.nx = (double)this.dx / this.len;
        this.ny = (double)this.dy / this.len;
        this.angel = Math.atan2(this.ny, this.nx);
    }

    public double sinA(RouteLine p) {
        return this.nx * p.ny - this.ny * p.nx;
    }

    public double sinA90(RouteLine p) {
        return this.nx * p.nx - this.ny * -p.ny;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouteLine) {
            RouteLine line = (RouteLine)obj;
            if (line.p1 != null && line.p2 != null && line.p1.x == this.p1.x && line.p1.y == this.p1.y && line.p2.x == this.p2.x && line.p2.y == this.p2.y) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public int getDx() {
        return this.dx;
    }

    public int getDy() {
        return this.dy;
    }

    public Point getFirst() {
        return this.p1;
    }

    public Point getLast() {
        return this.p2;
    }

    public double getLength() {
        return this.length;
    }

    public double getAngel() {
        return this.angel;
    }

    public double getAngelDegrees() {
        return Math.toDegrees(this.angel);
    }

    public String toString() {
        return String.format("Line points:(%s,%s)-(%s,%s),\tangel: %s,\tlenght: %s ", this.p1.x, this.p1.y, this.p2.x, this.p2.y, Math.toDegrees(this.angel), this.length);
    }
}

