/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.OrthoPath;
import com.dbeaver.ee.erd.router.ortho.OrthoPathUtils;
import com.dbeaver.ee.erd.router.ortho.OrthogonalConnection;
import com.dbeaver.ee.erd.router.ortho.OrthogonalIntersection;
import com.dbeaver.ee.erd.router.ortho.OrthogonalRouter;
import com.dbeaver.ee.erd.router.ortho.RouteLine;
import com.dbeaver.ee.erd.router.ortho.RouteRectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouter;

public class OrthogonalPathRouting
extends ERDConnectionRouter {
    private static final double INDENTATION_DEFAULT = 35.0;
    private static final int INTERSECTION_LINE_SPACING = 10;
    private static final int LINE_SPACING_DEFAULT = 7;
    private static final int LINE_SPACING_VERTICAL = 15;
    private static final int LINE_SPACING_HORIZONTAL = 15;
    private static final int LINE_SPACING_VERTICAL_DEFAULT = 15;
    private static final int ENTITY_OFFSET = 35;
    private static final int ENTITY_DEFORMATED_OFFSET = 10;
    private static final int MAX_RESOLVE_ITERATION_VERTICAL = 5;
    private static final int MAX_RESOLVE_ITERATION_HORIZONTAL = 5;
    private static final int MAX_RESOLVE_INTERSECTION_ITERATION = 7;
    private final Map<Connection, Object> constraintMap = new LinkedHashMap<Connection, Object>();
    private final Set<Connection> staleConnections = new LinkedHashSet<Connection>();
    private final LayoutListener listener = new LayoutTracker();
    @Nullable
    private Map<IFigure, Rectangle> figuresToBounds = new LinkedHashMap<IFigure, Rectangle>();
    @Nullable
    private Map<Connection, OrthoPath> connectionToPaths;
    private Map<Connection, List<OrthogonalIntersection>> connection2intersections = new LinkedHashMap<Connection, List<OrthogonalIntersection>>();
    private Map<Connection, PointList> connection2pointlist = new LinkedHashMap<Connection, PointList>();
    private final OrthogonalRouter algorithm = new OrthogonalRouter();
    private boolean isDirty;
    private int lineSpacing;
    private boolean ignoreInvalidate;
    private final FigureListener figureListener = source -> {
        Rectangle newBounds = source.getBounds().getCopy();
        if (this.algorithm.updateObstacle(this.figuresToBounds.get(source), newBounds)) {
            this.queueSomeRouting();
            this.isDirty = true;
        }
        this.figuresToBounds.put(source, newBounds);
    };

    void addChild(@NotNull IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        if (this.figuresToBounds.containsKey(child)) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        this.algorithm.addObstacle(bounds);
        this.figuresToBounds.put(child, bounds);
        child.addFigureListener(this.figureListener);
        this.isDirty = true;
    }

    private void hookAll() {
        this.figuresToBounds = new LinkedHashMap<IFigure, Rectangle>();
        this.getContainer().getChildren().forEach(this::addChild);
        this.getContainer().addLayoutListener(this.listener);
    }

    private void unhookAll() {
        this.getContainer().removeLayoutListener(this.listener);
        if (this.figuresToBounds != null) {
            Iterator<IFigure> figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = figureItr.next();
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds = null;
        }
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public void setSpacing(int spacing) {
        this.algorithm.setSpacing(spacing);
    }

    public void invalidate(Connection connection) {
        if (this.ignoreInvalidate) {
            return;
        }
        this.staleConnections.add(connection);
        this.getConnectionPoints().put(connection, new PointList());
        this.isDirty = true;
    }

    private void processStaleConnections() {
        Iterator<Connection> iter = this.staleConnections.iterator();
        if (iter.hasNext() && this.connectionToPaths == null) {
            this.connectionToPaths = new LinkedHashMap<Connection, OrthoPath>();
            this.hookAll();
        }
        while (iter.hasNext()) {
            List constraint;
            Connection conn = iter.next();
            OrthoPath path = this.connectionToPaths.get(conn);
            if (path == null) {
                path = new OrthoPath(conn);
                this.connectionToPaths.put(conn, path);
                this.algorithm.addPath(path);
            }
            if ((constraint = (List)this.getConstraint(conn)) == null) {
                constraint = Collections.emptyList();
            }
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.getContainer().translateToRelative((Translatable)start);
            this.getContainer().translateToRelative((Translatable)end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (!constraint.isEmpty()) {
                PointList bends = new PointList(constraint.size());
                for (Object element : constraint) {
                    Bendpoint bp = (Bendpoint)element;
                    bends.addPoint(bp.getLocation());
                }
                path.setBendPoints(bends);
            } else {
                path.setBendPoints(null);
            }
            this.isDirty |= path.isDirty;
        }
        this.staleConnections.clear();
    }

    void queueSomeRouting() {
        if (this.connectionToPaths == null || this.connectionToPaths.isEmpty()) {
            return;
        }
        try {
            this.ignoreInvalidate = true;
            this.connectionToPaths.keySet().iterator().next().revalidate();
        }
        finally {
            this.ignoreInvalidate = false;
        }
    }

    public void remove(Connection connection) {
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        if (this.connectionToPaths == null) {
            return;
        }
        OrthoPath path = this.connectionToPaths.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPaths.isEmpty()) {
            this.unhookAll();
            this.connectionToPaths = null;
        } else {
            this.queueSomeRouting();
        }
    }

    void removeChild(@NotNull IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        boolean change = this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        if (change) {
            this.isDirty = true;
            this.queueSomeRouting();
        }
    }

    public void route(Connection currentConnection) {
        if (this.isDirty) {
            this.lineSpacing = 15;
            this.ignoreInvalidate = true;
            this.processStaleConnections();
            this.isDirty = false;
            if (this.connectionToPaths == null) {
                return;
            }
            List<OrthoPath> algorithmPathes = this.algorithm.solve();
            if (algorithmPathes.isEmpty()) {
                return;
            }
            for (OrthoPath path : algorithmPathes) {
                PointList points = this.computeRoutePoints(path);
                if (points.size() == 0) {
                    path.getConnection().setVisible(false);
                    continue;
                }
                this.getConnectionPoints().put(path.getConnection(), points);
                this.connection2pointlist = this.detectGlobalIntersections();
                this.connection2intersections = this.detectBridges(path.getConnection());
                path.getConnection().setPoints(points);
            }
        }
        this.ignoreInvalidate = false;
    }

    @NotNull
    private PointList computeRoutePoints(@NotNull OrthoPath path) {
        Connection connection = path.getConnection();
        PointList resolvedRoutePoints = new PointList();
        IFigure srcOwner = connection.getSourceAnchor().getOwner();
        if (srcOwner == null) {
            return resolvedRoutePoints;
        }
        IFigure targetOwner = connection.getTargetAnchor().getOwner();
        if (targetOwner == null) {
            return resolvedRoutePoints;
        }
        PointList points = path.getPoints().getCopy();
        Rectangle srcBounds = srcOwner.getBounds().getCopy();
        Rectangle trgBounds = targetOwner.getBounds().getCopy();
        PointList modifiedPoints = new PointList();
        IFigure parentSrc = srcOwner;
        if (srcOwner instanceof AttributeItemFigure) {
            parentSrc = srcOwner.getParent().getParent();
        }
        IFigure parentTrg = targetOwner;
        if (srcOwner instanceof AttributeItemFigure) {
            parentTrg = targetOwner.getParent().getParent();
        }
        PointList bendpoints = path.bendpoints;
        int directionSrcToTrg = 0;
        int directionTrgToSrc = 0;
        RouteRectangle vrSource = new RouteRectangle(srcBounds);
        RouteRectangle vrTarget = new RouteRectangle(trgBounds);
        Point start = this.getStartPoint(connection, points);
        Point end = this.getEndPoint(connection, points);
        if (points.size() > 2 && bendpoints != null) {
            Point pointFirst = points.getPoint(1);
            Point pointLast = points.getPoint(points.size() - 2);
            if (OrthoPathUtils.isLeftRightDirection(start, pointFirst)) {
                start = vrSource.centerLeft;
                directionSrcToTrg = 180;
            } else {
                start = vrSource.centerRight;
                directionSrcToTrg = 0;
            }
            if (OrthoPathUtils.isLeftRightDirection(end, pointLast)) {
                end = vrTarget.centerLeft;
                directionTrgToSrc = 0;
            } else {
                end = vrTarget.centerRight;
                directionTrgToSrc = 180;
            }
        } else {
            if (parentSrc.equals(parentTrg)) {
                directionSrcToTrg = -360;
                directionTrgToSrc = 180;
            }
            int direction = OrthoPathUtils.getDirection(srcBounds, trgBounds);
            boolean isEnoughtDist = OrthoPathUtils.isEnoughtDistance(srcBounds, trgBounds);
            switch (direction) {
                case 90: {
                    directionSrcToTrg = 180;
                    directionTrgToSrc = 180;
                    start = vrSource.centerRight;
                    end = vrTarget.centerRight;
                    break;
                }
                case -90: {
                    directionSrcToTrg = 0;
                    directionTrgToSrc = 180;
                    start = vrSource.centerRight;
                    end = vrTarget.centerRight;
                    break;
                }
                case 0: {
                    if (isEnoughtDist) {
                        directionSrcToTrg = 180;
                        directionTrgToSrc = 180;
                        start = vrSource.centerLeft;
                        end = vrTarget.centerRight;
                        break;
                    }
                    directionSrcToTrg = 180;
                    directionTrgToSrc = 0;
                    start = vrSource.centerLeft;
                    end = vrTarget.centerLeft;
                    break;
                }
                case 180: {
                    start = vrSource.centerRight;
                    end = vrTarget.centerLeft;
                    break;
                }
                case -360: {
                    directionSrcToTrg = 180;
                    directionTrgToSrc = 0;
                    start = vrSource.centerLeft;
                    end = vrTarget.centerLeft;
                    break;
                }
                case -1: {
                    directionSrcToTrg = 180;
                    directionTrgToSrc = 180;
                    start = vrSource.centerLeft;
                    end = vrTarget.centerRight;
                    break;
                }
                case -2: {
                    directionSrcToTrg = 0;
                    directionTrgToSrc = 0;
                    start = vrSource.centerRight;
                    end = vrTarget.centerLeft;
                    break;
                }
                default: {
                    directionSrcToTrg = 180;
                    directionTrgToSrc = 180;
                    start = vrSource.centerLeft;
                    end = vrTarget.centerRight;
                }
            }
        }
        modifiedPoints.addPoint(start);
        int dx1 = (int)(Math.cos(Math.toRadians(directionSrcToTrg)) * 35.0);
        int dy1 = (int)(Math.sin(Math.toRadians(directionSrcToTrg)) * 35.0);
        int dx2 = (int)(Math.cos(Math.toRadians(directionTrgToSrc)) * 35.0);
        int dy2 = (int)(Math.sin(Math.toRadians(directionTrgToSrc)) * 35.0);
        modifiedPoints.addPoint(new Point(start.x + dx1, start.y - dy1));
        int i = 1;
        while (i < points.size() - 1) {
            modifiedPoints.addPoint(points.getPoint(i));
            ++i;
        }
        modifiedPoints.addPoint(new Point(end.x - dx2, end.y - dy2));
        modifiedPoints.addPoint(end);
        PointList intermediate = new PointList();
        int i2 = 1;
        while (i2 < modifiedPoints.size() - 1) {
            intermediate.addPoint(modifiedPoints.getPoint(i2));
            ++i2;
        }
        resolvedRoutePoints = OrthoPathUtils.calcOrthoRoutePoints(intermediate, directionSrcToTrg);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveIntersections(resolvedRoutePoints, this.algorithm.getEntityRectangle());
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveOverlappingRouteSegmentsHorizontally(resolvedRoutePoints, connection);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveOverlappingRouteSegmentsVertically(resolvedRoutePoints, connection);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.resolveIntersections(resolvedRoutePoints, this.algorithm.getEntityRectangle());
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        resolvedRoutePoints = this.combineRoutePoints(start, end, resolvedRoutePoints);
        resolvedRoutePoints = this.resolveExtraRoutePoints(resolvedRoutePoints);
        return resolvedRoutePoints;
    }

    private Point getStartPoint(@NotNull Connection currentConnection, @NotNull PointList points) {
        PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(1));
        currentConnection.translateToAbsolute((Translatable)ref1);
        Point start = currentConnection.getSourceAnchor().getLocation((Point)ref1).getCopy();
        currentConnection.translateToRelative((Translatable)start);
        return start;
    }

    private Point getEndPoint(@NotNull Connection currentConnection, @NotNull PointList points) {
        PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
        currentConnection.translateToAbsolute((Translatable)ref2);
        Point end = currentConnection.getTargetAnchor().getLocation((Point)ref2).getCopy();
        currentConnection.translateToRelative((Translatable)end);
        return end;
    }

    @NotNull
    private PointList combineRoutePoints(Point start, Point end, PointList resolvedRoutePoints) {
        PointList resultPointList = new PointList();
        resultPointList.addPoint(start);
        resultPointList.addAll(resolvedRoutePoints);
        resultPointList.addPoint(end);
        return resultPointList;
    }

    private PointList resolveOverlappingRouteSegmentsVertically(PointList originalPoints, @NotNull Connection conn) {
        PointList points = originalPoints;
        int iterationCounter = 0;
        while (iterationCounter < 5) {
            List<RouteLine> intersectionLines = this.getVerticalIntersections(points, conn);
            if (intersectionLines.isEmpty()) {
                return points;
            }
            ((OrthogonalConnection)conn).setOverlappingLinesByX(intersectionLines);
            points = this.resolveVerticalIntersections(points, intersectionLines);
            points = this.resolveExtraRoutePoints(points);
            ++iterationCounter;
        }
        return points;
    }

    @NotNull
    private PointList resolveVerticalIntersections(@NotNull PointList originalPoints, @NotNull List<RouteLine> intersectionLines) {
        List<RouteLine> routerLines = OrthoPathUtils.toRouteLines(originalPoints);
        boolean fromLeftRight = OrthoPathUtils.isLeftRightDirection(originalPoints.getFirstPoint(), originalPoints.getLastPoint());
        boolean fromBottomToTop = OrthoPathUtils.isBottomToTop(originalPoints);
        for (RouteLine interSectionLine : intersectionLines) {
            this.lineSpacing = 15;
            for (RouteLine routeLine : routerLines) {
                if (!routeLine.equals(interSectionLine)) continue;
                if (fromBottomToTop) {
                    routeLine.getFirst().x -= this.lineSpacing;
                    routeLine.getLast().x -= this.lineSpacing;
                } else if (fromLeftRight) {
                    routeLine.getFirst().x += this.lineSpacing;
                    routeLine.getLast().x += this.lineSpacing;
                } else {
                    routeLine.getFirst().x -= this.lineSpacing;
                    routeLine.getLast().x -= this.lineSpacing;
                }
                this.lineSpacing += 15;
            }
        }
        if (routerLines.size() > 1 && routerLines.get(0).getFirst().equals((Object)routerLines.get(1).getFirst())) {
            routerLines.remove(0);
        }
        return OrthoPathUtils.toPointList(routerLines);
    }

    private PointList resolveOverlappingRouteSegmentsHorizontally(PointList originalPoints, @NotNull Connection conn) {
        PointList resolvedPoints = originalPoints;
        int iterationCounter = 0;
        while (iterationCounter < 5) {
            List<RouteLine> intersectionLines = this.getHorzIntersections(resolvedPoints, conn);
            if (intersectionLines.isEmpty()) {
                return resolvedPoints;
            }
            ((OrthogonalConnection)conn).setOverlappingLinesByY(intersectionLines);
            if (intersectionLines.isEmpty()) {
                return resolvedPoints;
            }
            resolvedPoints = this.resolveHorizontalIntersections(resolvedPoints, intersectionLines);
            ++iterationCounter;
        }
        return resolvedPoints;
    }

    @NotNull
    private PointList resolveHorizontalIntersections(@NotNull PointList originalPoints, @NotNull List<RouteLine> intersectionLines) {
        List<RouteLine> routerLines = OrthoPathUtils.toRouteLines(originalPoints);
        int index = 1;
        while (index < routerLines.size() - 2) {
            RouteLine routeLine = routerLines.get(index);
            this.lineSpacing = 15;
            for (RouteLine interSectionLine : intersectionLines) {
                if (!routeLine.equals(interSectionLine)) continue;
                routeLine.getFirst().y += 15;
                routeLine.getLast().y += 15;
                this.lineSpacing += 15;
                break;
            }
            ++index;
        }
        return OrthoPathUtils.toPointList(routerLines);
    }

    @NotNull
    private List<RouteLine> getHorzIntersections(@NotNull PointList originalPoints, @NotNull Connection conn) {
        ArrayList<RouteLine> intersectionLines = new ArrayList<RouteLine>();
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            if (conn.equals(entry.getKey())) continue;
            intersectionLines.addAll(this.detectOverlappingRouteLinesHorizontally(originalPoints, (PointList)entry.getValue()));
        }
        return intersectionLines;
    }

    @NotNull
    private List<RouteLine> getVerticalIntersections(@NotNull PointList originalPoints, @NotNull Connection conn) {
        ArrayList<RouteLine> intersectionLines = new ArrayList<RouteLine>();
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            if (conn.equals(entry.getKey())) continue;
            intersectionLines.addAll(this.detectOverlappingRouteLinesVertically(originalPoints, (PointList)entry.getValue()));
        }
        return intersectionLines;
    }

    @NotNull
    private PointList computePointsAroundEntity(@NotNull RouteLine line, @NotNull RouteRectangle entity, @Nullable RouteLine nextLine) {
        RouteRectangle obstacle = this.getDeformedRectangle(entity, 35);
        entity = this.getDeformedRectangle(entity, 10);
        PointList aroundEntity = new PointList();
        PointList entityTopLine = new PointList();
        entityTopLine.addPoint(entity.getTopLeft());
        entityTopLine.addPoint(entity.getTopRight());
        PointList entityBottomLine = new PointList();
        entityBottomLine.addPoint(entity.getBottomLeft());
        entityBottomLine.addPoint(entity.getBottomRight());
        PointList entityRightLine = new PointList();
        entityRightLine.addPoint(entity.getTopRight());
        entityRightLine.addPoint(entity.getBottomRight());
        PointList entityLeftLine = new PointList();
        entityLeftLine.addPoint(entity.getTopLeft());
        entityLeftLine.addPoint(entity.getBottomLeft());
        PointList lineCenterToLeftTopLine = new PointList();
        lineCenterToLeftTopLine.addPoint(entity.getCenter());
        lineCenterToLeftTopLine.addPoint(entity.getTopLeft());
        PointList lineCenterToRightTopLine = new PointList();
        lineCenterToRightTopLine.addPoint(entity.getCenter());
        lineCenterToRightTopLine.addPoint(entity.getTopRight());
        PointList lineCenterToLeftBottomLine = new PointList();
        lineCenterToLeftBottomLine.addPoint(entity.getCenter());
        lineCenterToLeftBottomLine.addPoint(entity.getBottomLeft());
        PointList lineCenterToRightBottomLine = new PointList();
        lineCenterToRightBottomLine.addPoint(entity.getCenter());
        lineCenterToRightBottomLine.addPoint(entity.getBottomRight());
        PointList nextLineIntersectByTop = new PointList();
        PointList nextLineIntersectByBottom = new PointList();
        PointList nextLineIntersectByLeft = new PointList();
        PointList nextLineIntersectByRight = new PointList();
        if (nextLine != null) {
            nextLineIntersectByTop = OrthoPathUtils.detectIntesections(nextLine, entityTopLine);
            nextLineIntersectByBottom = OrthoPathUtils.detectIntesections(nextLine, entityBottomLine);
            nextLineIntersectByLeft = OrthoPathUtils.detectIntesections(nextLine, entityLeftLine);
            nextLineIntersectByRight = OrthoPathUtils.detectIntesections(nextLine, entityRightLine);
        }
        PointList frstLineIntersectByLeft = OrthoPathUtils.detectIntesections(line, entityLeftLine);
        PointList frstLineIntersectByRight = OrthoPathUtils.detectIntesections(line, entityRightLine);
        PointList frstLineIntersectByBottom = OrthoPathUtils.detectIntesections(line, entityBottomLine);
        PointList frstLineIntersectByTop = OrthoPathUtils.detectIntesections(line, entityTopLine);
        if (this.isCornerIntersection(nextLineIntersectByTop, nextLineIntersectByBottom, nextLineIntersectByLeft, nextLineIntersectByRight)) {
            aroundEntity = this.getPointsAroundCornerSegment(line, obstacle, nextLineIntersectByTop, nextLineIntersectByBottom, nextLineIntersectByLeft, nextLineIntersectByRight, frstLineIntersectByLeft, frstLineIntersectByRight, frstLineIntersectByTop, frstLineIntersectByBottom);
        } else {
            PointList frstLineIntersectCenterToLeftTop = OrthoPathUtils.detectIntesections(line, lineCenterToLeftTopLine);
            PointList frstLineIntersectCenterToLeftBottom = OrthoPathUtils.detectIntesections(line, lineCenterToLeftBottomLine);
            PointList intesectionsByCenterToRightTop = OrthoPathUtils.detectIntesections(line, lineCenterToRightTopLine);
            PointList intesectionsByCenterToRightBottom = OrthoPathUtils.detectIntesections(line, lineCenterToRightBottomLine);
            if (frstLineIntersectCenterToLeftTop.size() > 0 && frstLineIntersectCenterToLeftBottom.size() > 0) {
                aroundEntity = this.getPointsAroundLeftSegment(line, obstacle);
            } else if (intesectionsByCenterToRightTop.size() > 0 && intesectionsByCenterToRightBottom.size() > 0) {
                aroundEntity = this.getPointsAroundRightSegment(line, obstacle);
            } else if (intesectionsByCenterToRightBottom.size() > 0 && frstLineIntersectCenterToLeftBottom.size() > 0) {
                aroundEntity = this.getPointsAroundLeftRightByBotomSegment(line, obstacle);
            } else if (intesectionsByCenterToRightTop.size() > 0 && frstLineIntersectCenterToLeftTop.size() > 0) {
                aroundEntity = this.getPointsAroundLeftRightByTopSegment(line, obstacle);
            } else if (frstLineIntersectByLeft.size() > 0 && frstLineIntersectByRight.size() > 0) {
                aroundEntity = this.getPointsAroundLeftRightByTopSegment(line, obstacle);
            } else if (frstLineIntersectCenterToLeftBottom.size() > 0) {
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
                aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
            } else {
                if (frstLineIntersectCenterToLeftTop.size() > 0) {
                    if (frstLineIntersectByLeft.size() > 0 && nextLineIntersectByBottom.size() > 0) {
                        aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
                        aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
                        aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
                    } else {
                        aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
                        aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
                        aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
                    }
                    return aroundEntity;
                }
                if (intesectionsByCenterToRightTop.size() > 0 && nextLineIntersectByTop.size() > 0) {
                    aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
                    aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
                    aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
                    return aroundEntity;
                }
                if (intesectionsByCenterToRightTop.size() > 0 && nextLineIntersectByBottom.size() > 0) {
                    aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
                    aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
                    aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
                    return aroundEntity;
                }
            }
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundLeftRightByTopSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == 0) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
        } else if (direction == 180) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundLeftRightByBotomSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == 0) {
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
        } else if (direction == 180) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundRightSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == -90) {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundLeftSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle) {
        PointList aroundEntity = new PointList();
        int direction = (int)Math.toDegrees(line.getAngel());
        if (direction == -90 || direction == 90) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
        } else if (direction == 180) {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getFirst().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
        } else {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
        }
        return aroundEntity;
    }

    @NotNull
    private PointList getPointsAroundCornerSegment(@NotNull RouteLine line, @NotNull RouteRectangle obstacle, @NotNull PointList nextLineIntersectTop, @NotNull PointList nextLineIntersectBottom, @NotNull PointList nextLineIntersectLeft, @NotNull PointList nextLineintersectRight, @NotNull PointList frstLineintersectLeft, @NotNull PointList frstLineintersectRight, @NotNull PointList frstLineintersectTop, @NotNull PointList frstLineintersectBottom) {
        int direction = (int)Math.toDegrees(line.getAngel());
        PointList aroundEntity = new PointList();
        if (frstLineintersectLeft.size() > 0 && nextLineIntersectBottom.size() > 0) {
            if (direction == 0) {
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
                aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
                aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomLeft.y));
            } else {
                aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
                aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
                aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
            }
            return aroundEntity;
        }
        if (frstLineintersectLeft.size() > 0 && nextLineIntersectTop.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
            return aroundEntity;
        }
        if (frstLineintersectRight.size() > 0 && nextLineIntersectBottom.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.bottomRight.y));
            return aroundEntity;
        }
        if (frstLineintersectRight.size() > 0 && nextLineIntersectTop.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.topRight.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topRight.x, obstacle.topRight.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topRight.y));
            return aroundEntity;
        }
        if (frstLineintersectBottom.size() > 0 && nextLineIntersectLeft.size() > 0) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, obstacle.bottomLeft.y));
            aroundEntity.addPoint(new Point(obstacle.bottomLeft.x, line.getLast().y));
            return aroundEntity;
        }
        if (frstLineintersectBottom.size() > 0 && nextLineintersectRight.size() > 0) {
            aroundEntity.addPoint(new Point(line.getFirst().x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, obstacle.bottomRight.y));
            aroundEntity.addPoint(new Point(obstacle.bottomRight.x, line.getLast().y));
            return aroundEntity;
        }
        if (frstLineintersectTop.size() > 0 && nextLineIntersectLeft.size() > 0) {
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, line.getLast().y));
            aroundEntity.addPoint(new Point(obstacle.topLeft.x, obstacle.topLeft.y));
            aroundEntity.addPoint(new Point(line.getLast().x, obstacle.topLeft.y));
            return aroundEntity;
        }
        return aroundEntity;
    }

    private boolean isCornerIntersection(@NotNull PointList intersectionsNextByTop, @NotNull PointList intersectionsNextByBottom, @NotNull PointList intersectionsNextByLeft, @NotNull PointList intersectionsNextByRight) {
        return intersectionsNextByBottom.size() > 0 || intersectionsNextByTop.size() > 0 || intersectionsNextByLeft.size() > 0 || intersectionsNextByRight.size() > 0;
    }

    private PointList resolveIntersections(@NotNull PointList routePoints, @NotNull List<RouteRectangle> userObstacles) {
        int iterationCounter = 0;
        while (iterationCounter < 7) {
            if (!this.isRouteIntersectEntity(routePoints, userObstacles)) {
                return routePoints;
            }
            routePoints = this.resolveExtraRoutePoints(this.createRouteArroundOfEntities(routePoints, userObstacles));
            ++iterationCounter;
        }
        return routePoints;
    }

    private boolean isRouteIntersectEntity(@NotNull PointList routePointList, @NotNull List<RouteRectangle> userObstacles) {
        for (RouteRectangle entity : userObstacles) {
            RouteRectangle deformatedEntity = this.getDeformedRectangle(entity, 10);
            int j = 1;
            while (j < routePointList.size()) {
                Point pointB;
                Point pointA = routePointList.getPoint(j - 1);
                RouteLine line = new RouteLine(pointA, pointB = routePointList.getPoint(j));
                if (OrthoPathUtils.isIntersects(line, deformatedEntity)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private PointList createRouteArroundOfEntities(@NotNull PointList routePointList, @NotNull List<RouteRectangle> userObstacles) {
        Map<Integer, PointList> intersection = this.getPositionPointsArroundOfEntity(routePointList, userObstacles);
        int position = 0;
        for (Map.Entry<Integer, PointList> entry : intersection.entrySet()) {
            position += entry.getKey().intValue();
            PointList points = entry.getValue();
            int j = 0;
            while (j < points.size()) {
                Point p = points.getPoint(j);
                if (routePointList.size() - 1 >= position) {
                    routePointList.insertPoint(p, position++);
                }
                ++j;
            }
        }
        return routePointList;
    }

    @NotNull
    private Map<Integer, PointList> getPositionPointsArroundOfEntity(@NotNull PointList routePointList, @NotNull List<RouteRectangle> userObstacles) {
        LinkedHashMap<Integer, PointList> pointAround = new LinkedHashMap<Integer, PointList>();
        for (RouteRectangle entity : userObstacles) {
            int j = 1;
            while (j < routePointList.size()) {
                Point pointA = routePointList.getPoint(j - 1);
                Point pointB = routePointList.getPoint(j);
                RouteLine line = new RouteLine(pointA, pointB);
                RouteLine nextLine = null;
                if (j + 1 < routePointList.size()) {
                    Point pointC = routePointList.getPoint(j + 1);
                    nextLine = new RouteLine(pointB, pointC);
                }
                if (OrthoPathUtils.isIntersects(line, entity)) {
                    PointList pointsAroundEntity = this.computePointsAroundEntity(line, entity, nextLine);
                    pointAround.put(j, pointsAroundEntity);
                    return pointAround;
                }
                ++j;
            }
        }
        return pointAround;
    }

    @NotNull
    private PointList resolveExtraRoutePoints(@NotNull PointList orginalPointList) {
        PointList routePointList = this.cutExtraPoints(orginalPointList);
        PointList nextRoutePointList = this.cutExtraPoints(routePointList);
        if (routePointList.size() != nextRoutePointList.size()) {
            this.resolveExtraRoutePoints(nextRoutePointList);
        }
        return nextRoutePointList;
    }

    @NotNull
    private PointList cutExtraPoints(@NotNull PointList routePointList) {
        LinkedHashSet<Point> uniquePoints = new LinkedHashSet<Point>();
        int j = 0;
        while (j < routePointList.size()) {
            uniquePoints.add(routePointList.getPoint(j));
            ++j;
        }
        PointList pointList = OrthoPathUtils.toPointList(uniquePoints);
        if (uniquePoints.size() < 2) {
            return pointList;
        }
        int j2 = 2;
        while (j2 < pointList.size()) {
            Point pointA = pointList.getPoint(j2 - 2);
            Point pointB = pointList.getPoint(j2 - 1);
            Point pointC = pointList.getPoint(j2);
            if (pointA.x == pointB.x && pointA.x == pointC.x) {
                if (pointB.y < pointA.y && pointB.y < pointC.y) {
                    pointList.removePoint(j2 - 1);
                } else if (pointB.y > pointA.y && pointB.y > pointC.y) {
                    pointList.removePoint(j2 - 1);
                } else if (pointA.y < pointB.y && pointB.y < pointC.y) {
                    pointList.removePoint(j2 - 1);
                } else if (pointC.y < pointB.y && pointB.y < pointA.y) {
                    pointList.removePoint(j2 - 1);
                }
            }
            if (pointA.y == pointB.y && pointA.y == pointC.y) {
                if (pointB.x < pointA.x && pointB.x < pointC.x || pointB.x > pointA.x && pointB.x > pointC.x) {
                    pointList.removePoint(j2 - 1);
                } else if (pointA.x < pointB.x && pointB.x < pointC.x) {
                    pointList.removePoint(j2 - 1);
                } else if (pointC.x < pointB.x && pointB.x < pointA.x) {
                    pointList.removePoint(j2 - 1);
                }
            }
            ++j2;
        }
        return pointList;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Connection, PointList> detectGlobalIntersections() {
        this.connection2pointlist.clear();
        for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
            void erdConnection;
            Object k = entry.getKey();
            if (!(k instanceof OrthogonalConnection)) continue;
            OrthogonalConnection cfr_ignored_0 = (OrthogonalConnection)((Object)k);
            OrthogonalConnection cfr_ignored_1 = (OrthogonalConnection)((Object)k);
            PointList crossPoints = new PointList();
            for (Map.Entry targetEntry : this.getConnectionPoints().entrySet()) {
                if (targetEntry.equals(entry)) continue;
                crossPoints.addAll(OrthoPathUtils.detectIntesections((PointList)entry.getValue(), (PointList)targetEntry.getValue()));
            }
            this.connection2pointlist.put((Connection)erdConnection, crossPoints);
        }
        return this.connection2pointlist;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Connection, List<OrthogonalIntersection>> detectBridges(Connection connection) {
        ArrayList<OrthogonalIntersection> orthoIntersections = new ArrayList<OrthogonalIntersection>();
        Connection connection2 = connection;
        if (connection2 instanceof OrthogonalConnection) {
            void conn;
            OrthogonalConnection orthogonalConnection = (OrthogonalConnection)connection2;
            OrthogonalConnection cfr_ignored_0 = (OrthogonalConnection)connection2;
            PointList pointList = (PointList)this.getConnectionPoints().get(conn);
            for (Map.Entry entry : this.getConnectionPoints().entrySet()) {
                if (((Connection)entry.getKey()).equals(conn)) continue;
                orthoIntersections.addAll(OrthoPathUtils.detectOrthogonalIntesections(pointList, (PointList)entry.getValue()));
            }
            for (Map.Entry<Object, Object> entry : this.connection2intersections.entrySet()) {
                if (((Connection)entry.getKey()).equals(connection)) continue;
                for (OrthogonalIntersection current : orthoIntersections) {
                    for (OrthogonalIntersection slave : (List)entry.getValue()) {
                        if (!current.getPoint().equals((Object)slave.getPoint())) continue;
                        slave.setPrimary(false);
                    }
                }
            }
            this.connection2intersections.put(connection, orthoIntersections);
        }
        return this.connection2intersections;
    }

    @NotNull
    private List<RouteLine> detectOverlappingRouteLinesHorizontally(@NotNull PointList orthoPoints, @NotNull PointList connectionPoints) {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        int j = 1;
        while (j < orthoPoints.size()) {
            Point pointA = orthoPoints.getPoint(j - 1);
            Point pointB = orthoPoints.getPoint(j);
            int i = 1;
            while (i < connectionPoints.size()) {
                Point pointC = connectionPoints.getPoint(i - 1);
                Point pointD = connectionPoints.getPoint(i);
                RouteLine intersectionLine = this.getIntersectionsHorizontally(pointA.x, pointA.y, pointB.x, pointB.y, pointC.x, pointC.y, pointD.x, pointD.y);
                if (intersectionLine != null) {
                    lines.add(new RouteLine(pointA, pointB));
                }
                ++i;
            }
            ++j;
        }
        return lines;
    }

    @NotNull
    private List<RouteLine> detectOverlappingRouteLinesVertically(@NotNull PointList originalPoints, @NotNull PointList routePoints) {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        int j = 1;
        while (j < originalPoints.size()) {
            Point pointA = originalPoints.getPoint(j - 1);
            Point pointB = originalPoints.getPoint(j);
            int i = 1;
            while (i < routePoints.size()) {
                Point pointC = routePoints.getPoint(i - 1);
                Point pointD = routePoints.getPoint(i);
                RouteLine intersectionLine = this.getIntersectionsVertically(pointA.x, pointA.y, pointB.x, pointB.y, pointC.x, pointC.y, pointD.x, pointD.y);
                if (intersectionLine != null) {
                    lines.add(new RouteLine(pointA, pointB));
                    lines.add(new RouteLine(pointC, pointD));
                }
                ++i;
            }
            ++j;
        }
        return lines;
    }

    @Nullable
    private RouteLine getIntersectionsVertically(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(x1 - x3) < 10 && Math.abs(x2 - x4) < 10) {
            int lineABottom = 0;
            int lineATop = 0;
            int lineBBottom = 0;
            int lineBTop = 0;
            if (y1 > y2) {
                lineABottom = y1;
                lineATop = y2;
            } else {
                lineABottom = y2;
                lineATop = y1;
            }
            if (y3 > y4) {
                lineBTop = y4;
                lineBBottom = y3;
            } else {
                lineBTop = y3;
                lineBBottom = y4;
            }
            if (lineABottom == lineBBottom && lineATop == lineBTop && lineABottom == lineATop) {
                return null;
            }
            if (lineBBottom == lineBTop || lineABottom == lineATop) {
                return null;
            }
            if (lineATop == lineBTop && lineABottom == lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineATop < lineBTop && lineABottom < lineBBottom && lineABottom > lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop <= lineATop && lineBBottom < lineABottom && lineBBottom > lineATop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop <= lineATop && lineABottom < lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop > lineATop && lineABottom > lineBTop && lineABottom > lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBTop > lineATop && lineABottom > lineBTop && lineABottom < lineBBottom) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineABottom == lineBBottom && lineATop < lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineABottom == lineBBottom && lineATop > lineBTop) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
        }
        return null;
    }

    @Nullable
    private RouteLine getIntersectionsHorizontally(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(y1 - y3) < 10 && Math.abs(y2 - y4) < 10) {
            int lineARight = 0;
            int lineALeft = 0;
            int lineBRight = 0;
            int lineBLeft = 0;
            if (x1 > x2) {
                lineARight = x1;
                lineALeft = x2;
            } else {
                lineARight = x2;
                lineALeft = x1;
            }
            if (x3 > x4) {
                lineBRight = x3;
                lineBLeft = x4;
            } else {
                lineBRight = x4;
                lineBLeft = x3;
            }
            if (lineARight == lineBRight && lineALeft == lineBLeft && lineARight == lineBLeft) {
                return null;
            }
            if (lineBLeft == lineBRight || lineALeft == lineARight) {
                return null;
            }
            if (lineARight == lineBRight && lineALeft == lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBRight > lineARight && lineALeft > lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineARight > lineBLeft && lineARight < lineBRight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineALeft > lineBLeft && lineALeft < lineBRight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineBRight >= lineARight && lineBLeft > lineALeft && lineBLeft < lineARight) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
            if (lineALeft == lineBLeft && lineARight > lineBLeft) {
                return new RouteLine(new Point(x1, y1), new Point(x2, y2));
            }
        }
        return null;
    }

    public List<?> getPathsAfterRouting() {
        if (this.isDirty) {
            this.processStaleConnections();
            this.isDirty = false;
            return this.algorithm.solve();
        }
        return Collections.emptyList();
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    public boolean hasMoreConnections() {
        return this.connectionToPaths != null && !this.connectionToPaths.isEmpty();
    }

    public void setIgnoreInvalidate(boolean b) {
        this.ignoreInvalidate = b;
    }

    public boolean shouldIgnoreInvalidate() {
        return this.ignoreInvalidate;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean containsConnection(Connection conn) {
        return this.connectionToPaths != null && this.connectionToPaths.containsKey(conn);
    }

    public double getIndentation() {
        return 35.0;
    }

    public void setIndentation(double indentation) {
    }

    @NotNull
    private RouteRectangle getDeformedRectangle(@NotNull RouteRectangle r, int extraOffset) {
        int offset = extraOffset * 2;
        Rectangle rect = new Rectangle(r.x - extraOffset, r.y - extraOffset, r.width + offset, r.height + offset);
        return new RouteRectangle(rect);
    }

    @NotNull
    public PolylineConnection getConnectionInstance() {
        return new OrthogonalConnection();
    }

    protected void handleCollision(@NotNull PointList points, int index) {
        Point end;
        Point start = points.getFirstPoint();
        if (start.equals((Object)(end = points.getLastPoint()))) {
            return;
        }
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        int position = end.getPosition(start);
        RouteLine line = position == 4 || position == 16 ? new RouteLine(start, end) : new RouteLine(end, start);
        double xSeparation = (double)(7 * line.getDx()) / line.getLength();
        double ySeparation = (double)(7 * line.getDy()) / line.getLength();
        PrecisionPoint bendPoint = index % 2 == 0 ? new PrecisionPoint((double)midPoint.x + (double)(index / 2) * (-1.0 * ySeparation), (double)midPoint.y + (double)(index / 2) * xSeparation) : new PrecisionPoint((double)midPoint.x + (double)(index / 2) * ySeparation, (double)midPoint.y + (double)(index / 2) * (-1.0 * xSeparation));
        if (!bendPoint.equals((Object)midPoint)) {
            points.insertPoint((Point)bendPoint, 1);
        }
    }

    public Map<Connection, PointList> getItersectionConnection2PointList() {
        return this.connection2pointlist;
    }

    public Map<Connection, List<OrthogonalIntersection>> getItersectionConnection2Ortholine() {
        return this.connection2intersections;
    }

    public void revalidateCahce() {
        this.connection2intersections.clear();
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        private LayoutTracker() {
        }

        public void postLayout(IFigure container) {
            if (OrthogonalPathRouting.this.staleConnections.isEmpty()) {
                return;
            }
            OrthogonalPathRouting.this.staleConnections.iterator().next().revalidate();
        }

        public void remove(@NotNull IFigure child) {
            OrthogonalPathRouting.this.removeChild(child);
        }

        public void setConstraint(@NotNull IFigure child, Object constraint) {
            OrthogonalPathRouting.this.addChild(child);
        }
    }
}

