/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.OrthogonalIntersection;
import com.dbeaver.ee.erd.router.ortho.RouteLine;
import com.dbeaver.ee.erd.router.ortho.RouteRectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class OrthoPathUtils {
    private static final int DISTANSE = 80;
    public static final int RIGHT = 180;
    public static final int LEFT = 0;
    public static final int UP = 90;
    public static final int DOWN = -90;
    public static final int CONNECTION_TO_OURSELF = -360;
    public static final int LEFT_RIGHT = -1;
    public static final int RIGHT_LEFT = -2;

    public static int getDirection(@NotNull Rectangle r, @NotNull Rectangle p) {
        int direction = 0;
        int rx = Math.abs(r.right() - p.x);
        int lx = p.x > r.x ? Math.abs(-(r.x + r.width() / 2) + p.x - p.width() / 2) : Math.abs(r.x - r.width() / 2 - p.x - p.width() / 2);
        if (p.y > r.y) {
            Math.abs(-(r.y + r.height() / 2) + p.y - p.height() / 2);
        } else {
            Math.abs(r.y - r.height() / 2 - p.y - p.height() / 2);
        }
        int dx = Math.abs(r.x - p.x);
        if (p.x > r.x && lx < 80) {
            direction = -1;
        }
        if (p.x < r.x && lx < 80) {
            direction = -2;
        }
        if (rx < dx) {
            direction = 180;
        }
        if (r.left() > p.right()) {
            direction = 0;
        }
        if (dx < r.width + 80) {
            direction = -90;
        }
        if (rx < 40) {
            direction = 0;
        }
        return direction;
    }

    public static boolean isTopToBottom(@NotNull Point p1, @NotNull Point p2) {
        return p1.y > p2.y;
    }

    public static boolean isBottomToTop(@NotNull PointList points) {
        return OrthoPathUtils.isTopToBottom(points.getFirstPoint(), points.getLastPoint());
    }

    public static boolean isLeftRightDirection(@NotNull Point p1, @NotNull Point p2) {
        return p1.x > p2.x;
    }

    @NotNull
    public static Point getInterceptionPoint(@NotNull RouteLine lineA, @NotNull RouteLine lineB) {
        return OrthoPathUtils.getInterceptionPoint(lineA.getFirst(), lineA.getLast(), lineB.getFirst(), lineB.getLast());
    }

    @Nullable
    public static Point getInterceptionPoint(@NotNull Point pointA, @NotNull Point pointB, @NotNull Point pointC, @NotNull Point pointD) {
        double a1 = pointB.y - pointA.y;
        double b1 = pointA.x - pointB.x;
        double c1 = a1 * (double)pointA.x + b1 * (double)pointA.y;
        double a2 = pointD.y - pointC.y;
        double b2 = pointC.x - pointD.x;
        double c2 = a2 * (double)pointC.x + b2 * (double)pointC.y;
        double determinant = a1 * b2 - a2 * b1;
        if (determinant == 0.0) {
            return null;
        }
        int x = (int)((b2 * c1 - b1 * c2) / determinant);
        int y = (int)((a1 * c2 - a2 * c1) / determinant);
        return new Point(x, y);
    }

    public static boolean isIntersects(@NotNull RouteLine line, @NotNull RouteRectangle r) {
        if (r.isEmpty()) {
            return false;
        }
        if (r.contains(line.getFirst()) || r.contains(line.getLast())) {
            return true;
        }
        int diagonal1x1 = r.x;
        int diagonal1y1 = r.y;
        int diagonal1x2 = r.x + r.width - 1;
        int diagonal1y2 = r.y + r.height - 1;
        int diagonal2x1 = r.x + r.width - 1;
        int diagonal2y1 = r.y;
        int diagonal2x2 = r.x;
        int diagonal2y2 = r.y + r.height - 1;
        if (Geometry.linesIntersect((int)diagonal1x1, (int)diagonal1y1, (int)diagonal1x2, (int)diagonal1y2, (int)line.getFirst().x, (int)line.getFirst().y, (int)line.getLast().x, (int)line.getLast().y)) {
            return true;
        }
        return Geometry.linesIntersect((int)diagonal2x1, (int)diagonal2y1, (int)diagonal2x2, (int)diagonal2y2, (int)line.getFirst().x, (int)line.getFirst().y, (int)line.getLast().x, (int)line.getLast().y);
    }

    @NotNull
    public static PointList calcOrthoRoutePoints(@NotNull PointList points, int direction) {
        boolean fromBottomToTop = OrthoPathUtils.isBottomToTop(points);
        boolean fromLeftToRight = OrthoPathUtils.isLeftRightDirection(points.getFirstPoint(), points.getLastPoint());
        Point[] retval = new Point[2 * points.size() - 1];
        int i = 0;
        while (i < points.size()) {
            retval[2 * i] = points.getPoint(i);
            ++i;
        }
        i = 0;
        while (i < points.size() - 1) {
            Point pointCurrent = points.getPoint(i);
            Point nextPoint = points.getPoint(i + 1);
            int dx = Math.abs(pointCurrent.x - nextPoint.x);
            int dy = Math.abs(pointCurrent.y - nextPoint.y);
            if (pointCurrent.x == nextPoint.x || pointCurrent.y == nextPoint.y) {
                retval[2 * i + 1] = new Point(pointCurrent.x, pointCurrent.y);
            } else if (fromBottomToTop) {
                if (fromLeftToRight) {
                    dxTransformed = (int)(Math.sin(Math.toRadians(direction)) * (double)dx);
                    dyTransformed = (int)(Math.cos(Math.toRadians(direction)) * (double)dy);
                    retval[2 * i + 1] = new Point(pointCurrent.x + dxTransformed, pointCurrent.y + dyTransformed);
                } else {
                    dxTransformed = (int)(Math.cos(Math.toRadians(direction)) * (double)dx);
                    dyTransformed = (int)(Math.sin(Math.toRadians(direction)) * (double)dy);
                    retval[2 * i + 1] = new Point(pointCurrent.x + dxTransformed, pointCurrent.y + dyTransformed);
                }
            } else {
                dxTransformed = (int)(Math.cos(Math.toRadians(direction)) * (double)dx);
                dyTransformed = (int)(Math.sin(Math.toRadians(direction)) * (double)dy);
                retval[2 * i + 1] = new Point(pointCurrent.x + dxTransformed, pointCurrent.y + dyTransformed);
            }
            ++i;
        }
        PointList arrayToPointList = OrthoPathUtils.arrayToPointList(retval);
        PointList alignedPointList = new PointList();
        int i2 = 0;
        while (i2 < arrayToPointList.size() - 1) {
            Point pointCurrent = arrayToPointList.getPoint(i2);
            Point nextPoint = arrayToPointList.getPoint(i2 + 1);
            if (pointCurrent.x == nextPoint.x || pointCurrent.y == nextPoint.y) {
                alignedPointList.addPoint(pointCurrent);
            } else {
                Point beforePoint = arrayToPointList.getPoint(i2 - 1);
                alignedPointList.addPoint(new Point(beforePoint.x, nextPoint.y));
            }
            ++i2;
        }
        alignedPointList.addPoint(arrayToPointList.getLastPoint());
        return alignedPointList;
    }

    @NotNull
    private static PointList arrayToPointList(@NotNull Point[] array) {
        PointList list = new PointList();
        Point[] pointArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            list.addPoint(p);
            ++n2;
        }
        return list;
    }

    @NotNull
    public static PointList getCornerPoints(@NotNull PointList points) {
        PointList corners = new PointList();
        int i = 1;
        while (i < points.size()) {
            Point p0 = points.getPoint(i - 1);
            Point p1 = points.getPoint(i);
            if (i + 1 < points.size()) {
                Point p2 = points.getPoint(i + 1);
                if ((p1.x != p0.x || p1.x != p2.x) && (p1.y != p0.y || p1.y != p2.y) && (p1.x == p0.x && p1.y == p2.y || p1.y == p0.y && p1.x == p2.x)) {
                    corners.addPoint(p1);
                }
            }
            ++i;
        }
        return corners;
    }

    @NotNull
    public static List<OrthogonalIntersection> detectOrthogonalIntesections(@NotNull PointList pointListA, @NotNull PointList pointListB) {
        ArrayList<OrthogonalIntersection> intersection = new ArrayList<OrthogonalIntersection>();
        int j = 1;
        while (j < pointListA.size()) {
            Point pointA = pointListA.getPoint(j);
            Point pointB = pointListA.getPoint(j - 1);
            int k = 1;
            while (k < pointListB.size()) {
                RouteLine lineB;
                RouteLine lineA;
                Point intersectionPoint;
                Point pointC = pointListB.getPoint(k);
                Point pointD = pointListB.getPoint(k - 1);
                if (!(pointA.x == pointB.x && pointA.x == pointC.x || pointA.x == pointB.x && pointA.x == pointD.x || pointA.y == pointB.y && pointA.y == pointC.y || pointA.y == pointB.y && pointA.y == pointD.y || pointC.x == pointD.x && pointC.x == pointA.x || pointC.y == pointD.y && pointC.y == pointA.y || pointC.x == pointD.x && pointC.x == pointB.x || pointC.y == pointD.y && pointC.y == pointB.y || (intersectionPoint = OrthoPathUtils.getInterceptionPoint(lineA = new RouteLine(pointA, pointB), lineB = new RouteLine(pointC, pointD))) == null || !Geometry.polylineContainsPoint((PointList)OrthoPathUtils.toPointList(lineA), (int)intersectionPoint.x, (int)intersectionPoint.y, (int)1) || !Geometry.polylineContainsPoint((PointList)OrthoPathUtils.toPointList(lineB), (int)intersectionPoint.x, (int)intersectionPoint.y, (int)1))) {
                    intersection.add(new OrthogonalIntersection(lineA, intersectionPoint));
                }
                ++k;
            }
            ++j;
        }
        return intersection;
    }

    @NotNull
    public static Map<RouteLine, List<Point>> detectLineIntesections(@NotNull PointList pointListA, @NotNull PointList pointListB) {
        HashMap<RouteLine, List<Point>> line2intersection = new HashMap<RouteLine, List<Point>>();
        HashSet<Point> setOfPoints = new HashSet<Point>();
        int j = 1;
        while (j < pointListA.size()) {
            Point pointA = pointListA.getPoint(j);
            Point pointB = pointListA.getPoint(j - 1);
            int k = 1;
            while (k < pointListB.size()) {
                RouteLine lineB;
                RouteLine lineA;
                Point intersectionPoint;
                Point pointC = pointListB.getPoint(k);
                Point pointD = pointListB.getPoint(k - 1);
                if (!(pointA.x == pointB.x && pointA.x == pointC.x || pointA.x == pointB.x && pointA.x == pointD.x || pointA.y == pointB.y && pointA.y == pointC.y || pointA.y == pointB.y && pointA.y == pointD.y || pointC.x == pointD.x && pointC.x == pointA.x || pointC.y == pointD.y && pointC.y == pointA.y || pointC.x == pointD.x && pointC.x == pointB.x || pointC.y == pointD.y && pointC.y == pointB.y || (intersectionPoint = OrthoPathUtils.getInterceptionPoint(lineA = new RouteLine(pointA, pointB), lineB = new RouteLine(pointC, pointD))) == null || !Geometry.polylineContainsPoint((PointList)OrthoPathUtils.toPointList(lineA), (int)intersectionPoint.x, (int)intersectionPoint.y, (int)1) || !Geometry.polylineContainsPoint((PointList)OrthoPathUtils.toPointList(lineB), (int)intersectionPoint.x, (int)intersectionPoint.y, (int)1))) {
                    setOfPoints.add(intersectionPoint);
                    line2intersection.computeIfAbsent(lineA, l -> new ArrayList()).add(intersectionPoint);
                }
                ++k;
            }
            ++j;
        }
        PointList list = new PointList();
        if (!setOfPoints.isEmpty()) {
            for (Point p : setOfPoints) {
                list.addPoint(p);
            }
        }
        return line2intersection;
    }

    @NotNull
    public static PointList detectIntesections(@NotNull RouteLine line, @NotNull PointList points) {
        return OrthoPathUtils.detectIntesections(OrthoPathUtils.toPointList(line), points);
    }

    @NotNull
    public static PointList detectIntesections(@NotNull PointList pointListA, @NotNull PointList pointListB) {
        PointList list = new PointList();
        HashSet<Point> setOfPoints = new HashSet<Point>();
        int j = 1;
        while (j < pointListA.size()) {
            Point pointA = pointListA.getPoint(j);
            Point pointB = pointListA.getPoint(j - 1);
            int k = 1;
            while (k < pointListB.size()) {
                RouteLine lineB;
                RouteLine lineA;
                Point intersectionPoint;
                Point pointC = pointListB.getPoint(k);
                Point pointD = pointListB.getPoint(k - 1);
                if (!(pointA.x == pointB.x && pointA.x == pointC.x || pointA.x == pointB.x && pointA.x == pointD.x || pointA.y == pointB.y && pointA.y == pointC.y || pointA.y == pointB.y && pointA.y == pointD.y || pointC.x == pointD.x && pointC.x == pointA.x || pointC.y == pointD.y && pointC.y == pointA.y || pointC.x == pointD.x && pointC.x == pointB.x || pointC.y == pointD.y && pointC.y == pointB.y || (intersectionPoint = OrthoPathUtils.getInterceptionPoint(lineA = new RouteLine(pointA, pointB), lineB = new RouteLine(pointC, pointD))) == null || !Geometry.polylineContainsPoint((PointList)OrthoPathUtils.toPointList(lineA), (int)intersectionPoint.x, (int)intersectionPoint.y, (int)1) || !Geometry.polylineContainsPoint((PointList)OrthoPathUtils.toPointList(lineB), (int)intersectionPoint.x, (int)intersectionPoint.y, (int)1))) {
                    setOfPoints.add(intersectionPoint);
                }
                ++k;
            }
            ++j;
        }
        if (!setOfPoints.isEmpty()) {
            for (Point p : setOfPoints) {
                list.addPoint(p);
            }
        }
        return list;
    }

    @NotNull
    public static List<RouteLine> toRouteLines(@NotNull PointList points) {
        LinkedList<RouteLine> lines = new LinkedList<RouteLine>();
        int j = 1;
        while (j < points.size()) {
            Point pointA = points.getPoint(j - 1);
            Point pointB = points.getPoint(j);
            lines.add(new RouteLine(pointA, pointB));
            ++j;
        }
        return lines;
    }

    @NotNull
    public static PointList toPointList(@NotNull List<RouteLine> lines) {
        PointList points = new PointList();
        for (RouteLine line : lines) {
            points.addPoint(line.getFirst());
            points.addPoint(line.getLast());
        }
        return points;
    }

    public static boolean polylineContainsPoint(@NotNull RouteLine line, @NotNull Point cornerPoint) {
        return line.getFirst().y == cornerPoint.y && line.getLast().y == cornerPoint.y && (line.getFirst().x > cornerPoint.x && cornerPoint.x > line.getLast().x || line.getLast().x > cornerPoint.x && cornerPoint.x > line.getFirst().x);
    }

    @Nullable
    public static RouteLine linesIntersect(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (Math.abs(y1 - y3) < 5 && Math.abs(y2 - y4) < 5) {
            if (x1 == x2 && y1 == y2 || x3 == x4 && y3 == y4) {
                return null;
            }
            double ax = x2 - x1;
            double ay = y2 - y1;
            double bx = x3 - x4;
            double by = y3 - y4;
            double cx = x1 - x3;
            double cy = y1 - y3;
            double alphaNumerator = by * cx - bx * cy;
            double commonDenominator = ay * bx - ax * by;
            if (commonDenominator > 0.0 ? alphaNumerator < 0.0 || alphaNumerator > commonDenominator : commonDenominator < 0.0 && (alphaNumerator > 0.0 || alphaNumerator < commonDenominator)) {
                return null;
            }
            double betaNumerator = ax * cy - ay * cx;
            if (commonDenominator > 0.0 ? betaNumerator < 0.0 || betaNumerator > commonDenominator : commonDenominator < 0.0 && (betaNumerator > 0.0 || betaNumerator < commonDenominator)) {
                return null;
            }
            if (commonDenominator == 0.0) {
                double y3LessY1 = y3 - y1;
                double collinearityTestForP3 = (double)(x1 * (y2 - y3)) + (double)x2 * y3LessY1 + (double)(x3 * (y1 - y2));
                if (collinearityTestForP3 == 0.0 && (x1 >= x3 && x1 <= x4 || x1 <= x3 && x1 >= x4 || x2 >= x3 && x2 <= x4 || x2 <= x3 && x2 >= x4 || x3 >= x1 && x3 <= x2 || x3 <= x1 && x3 >= x2) && (y1 >= y3 && y1 <= y4 || y1 <= y3 && y1 >= y4 || y2 >= y3 && y2 <= y4 || y2 <= y3 && y2 >= y4 || y3 >= y1 && y3 <= y2 || y3 <= y1 && y3 >= y2)) {
                    return new RouteLine(new Point(x1, y1), new Point(x2, y2));
                }
                return null;
            }
            return new RouteLine(new Point(x1, y1), new Point(x2, y2));
        }
        return null;
    }

    @NotNull
    public static PointList toPointList(@NotNull RouteLine line) {
        PointList points = new PointList();
        points.addPoint(line.getFirst());
        points.addPoint(line.getLast());
        return points;
    }

    @NotNull
    public static PointList toPointList(@NotNull Collection<Point> collection) {
        PointList pointlist = new PointList();
        Iterator<Point> iterator = collection.iterator();
        while (iterator.hasNext()) {
            pointlist.addPoint(iterator.next());
        }
        return pointlist;
    }

    @NotNull
    public static List<Point> toListPoint(@NotNull PointList list) {
        ArrayList<Point> listOfPoints = new ArrayList<Point>();
        int j = 0;
        while (j < list.size()) {
            Point p = list.getPoint(j);
            listOfPoints.add(p);
            ++j;
        }
        return listOfPoints;
    }

    public static boolean isEnoughtDistance(@NotNull Rectangle srcBounds, @NotNull Rectangle trgBounds) {
        int distX = srcBounds.x + srcBounds.width / 2 - (trgBounds.x - trgBounds.width / 2);
        return distX > 80;
    }
}

