/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.RoutePoint;
import com.dbeaver.ee.erd.router.ortho.RouteRectangle;
import com.dbeaver.ee.erd.router.ortho.RouteSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class OrthoPath {
    private static final Point CURRENT = new Point();
    private static final double EPSILON = 1.04;
    private static final Point NEXT = new Point();
    private static final double OVAL_CONSTANT = 1.13;
    public Connection connection;
    public boolean isDirty = true;
    PointList bendpoints;
    boolean isInverted = false;
    boolean isMarked = false;
    PointList points;
    private List<RouteRectangle> excludedVertexRectangles;
    private List<RouteSegment> grownSegments;
    private double prevCostRatio;
    private List<RouteSegment> segments = new ArrayList<RouteSegment>();
    private final SegmentStack stack;
    private RoutePoint start;
    private RoutePoint end;
    private OrthoPath subPath;
    private double threshold;
    private Set<RouteRectangle> visibleVertexRectangles;
    private Set<Object> visibleVertices;

    public OrthoPath() {
        this.grownSegments = new ArrayList<RouteSegment>();
        this.points = new PointList();
        this.visibleVertices = new HashSet<Object>();
        this.stack = new SegmentStack();
        this.visibleVertexRectangles = new HashSet<RouteRectangle>();
        this.excludedVertexRectangles = new ArrayList<RouteRectangle>();
    }

    public OrthoPath(Connection data) {
        this();
        this.connection = data;
    }

    public OrthoPath(Point start, Point end) {
        this(new RoutePoint(start, null), new RoutePoint(end, null));
    }

    OrthoPath(RoutePoint start, RoutePoint end) {
        this();
        this.start = start;
        this.end = end;
    }

    private void addAllSegmentsBetween(RouteRectangle source, RouteRectangle target) {
        this.addConnectingSegment(new RouteSegment(source.bottomLeft, target.bottomLeft), source, target, false, false);
        this.addConnectingSegment(new RouteSegment(source.bottomRight, target.bottomRight), source, target, true, true);
        this.addConnectingSegment(new RouteSegment(source.topLeft, target.topLeft), source, target, true, true);
        this.addConnectingSegment(new RouteSegment(source.topRight, target.topRight), source, target, false, false);
        if (source.bottom() == target.bottom()) {
            this.addConnectingSegment(new RouteSegment(source.bottomLeft, target.bottomRight), source, target, false, true);
            this.addConnectingSegment(new RouteSegment(source.bottomRight, target.bottomLeft), source, target, true, false);
        }
        if (source.y == target.y) {
            this.addConnectingSegment(new RouteSegment(source.topLeft, target.topRight), source, target, true, false);
            this.addConnectingSegment(new RouteSegment(source.topRight, target.topLeft), source, target, false, true);
        }
        if (source.x == target.x) {
            this.addConnectingSegment(new RouteSegment(source.bottomLeft, target.topLeft), source, target, false, true);
            this.addConnectingSegment(new RouteSegment(source.topLeft, target.bottomLeft), source, target, true, false);
        }
        if (source.right() == target.right()) {
            this.addConnectingSegment(new RouteSegment(source.bottomRight, target.topRight), source, target, true, false);
            this.addConnectingSegment(new RouteSegment(source.topRight, target.bottomRight), source, target, false, true);
        }
    }

    private void addConnectingSegment(RouteSegment segment, RouteRectangle o1, RouteRectangle o2, boolean checkTopRight1, boolean checkTopRight2) {
        if (this.threshold != 0.0 && (segment.end.getDistance(this.end) + segment.end.getDistance(this.start) > this.threshold || segment.start.getDistance(this.end) + segment.start.getDistance(this.start) > this.threshold)) {
            return;
        }
        if (o2.containsProper(segment.start) || o1.containsProper(segment.end)) {
            return;
        }
        if (checkTopRight1 && segment.intersects(o1.x, o1.bottom() - 1, o1.right() - 1, o1.y)) {
            return;
        }
        if (checkTopRight2 && segment.intersects(o2.x, o2.bottom() - 1, o2.right() - 1, o2.y)) {
            return;
        }
        if (!checkTopRight1 && segment.intersects(o1.x, o1.y, o1.right() - 1, o1.bottom() - 1)) {
            return;
        }
        if (!checkTopRight2 && segment.intersects(o2.x, o2.y, o2.right() - 1, o2.bottom() - 1)) {
            return;
        }
        this.stack.push((Object)o1);
        this.stack.push((Object)o2);
        this.stack.push(segment);
    }

    private void addVertexRectangle(RouteRectangle newObs) {
        this.visibleVertexRectangles.add(newObs);
        for (RouteRectangle currObs : new HashSet<RouteRectangle>(this.visibleVertexRectangles)) {
            if (newObs == currObs) continue;
            this.addSegmentsFor(newObs, currObs);
        }
        this.addPerimiterSegments(newObs);
        this.addSegmentsFor(this.start, newObs);
        this.addSegmentsFor(this.end, newObs);
    }

    private void addPerimiterSegments(RouteRectangle obs) {
        RouteSegment seg = new RouteSegment(obs.topLeft, obs.topRight);
        this.stack.push((Object)obs);
        this.stack.push(null);
        this.stack.push(seg);
        seg = new RouteSegment(obs.topRight, obs.bottomRight);
        this.stack.push((Object)obs);
        this.stack.push(null);
        this.stack.push(seg);
        seg = new RouteSegment(obs.bottomRight, obs.bottomLeft);
        this.stack.push((Object)obs);
        this.stack.push(null);
        this.stack.push(seg);
        seg = new RouteSegment(obs.bottomLeft, obs.topLeft);
        this.stack.push((Object)obs);
        this.stack.push(null);
        this.stack.push(seg);
    }

    private void addSegment(RouteSegment segment, RouteRectangle exclude1, RouteRectangle exclude2, List<RouteRectangle> allVertexRectangles) {
        if (this.threshold != 0.0 && (segment.end.getDistance(this.end) + segment.end.getDistance(this.start) > this.threshold || segment.start.getDistance(this.end) + segment.start.getDistance(this.start) > this.threshold)) {
            return;
        }
        int i = 0;
        while (i < allVertexRectangles.size()) {
            RouteRectangle obs = allVertexRectangles.get(i);
            if (obs != exclude1 && obs != exclude2 && !obs.exclude && (segment.intersects(obs.x, obs.y, obs.right() - 1, obs.bottom() - 1) || segment.intersects(obs.x, obs.bottom() - 1, obs.right() - 1, obs.y) || obs.containsProper(segment.start) || obs.containsProper(segment.end))) {
                if (!this.visibleVertexRectangles.contains((Object)obs)) {
                    this.addVertexRectangle(obs);
                }
                return;
            }
            ++i;
        }
        this.linkVertices(segment);
    }

    private void addSegmentsFor(RouteRectangle source, RouteRectangle target) {
        if (source.intersects(target)) {
            this.addAllSegmentsBetween(source, target);
        } else if (target.bottom() - 1 < source.y) {
            this.addSegmentsTargetAboveSource(source, target);
        } else if (source.bottom() - 1 < target.y) {
            this.addSegmentsTargetAboveSource(target, source);
        } else if (target.right() - 1 < source.x) {
            this.addSegmentsTargetBesideSource(source, target);
        } else {
            this.addSegmentsTargetBesideSource(target, source);
        }
    }

    private void addSegmentsFor(RoutePoint vertex, RouteRectangle obs) {
        RouteSegment seg = null;
        RouteSegment seg2 = null;
        switch (obs.getPosition(vertex)) {
            case 12: 
            case 17: {
                seg = new RouteSegment(vertex, obs.topLeft);
                seg2 = new RouteSegment(vertex, obs.bottomRight);
                break;
            }
            case 9: 
            case 20: {
                seg = new RouteSegment(vertex, obs.topRight);
                seg2 = new RouteSegment(vertex, obs.bottomLeft);
                break;
            }
            case 1: {
                seg = new RouteSegment(vertex, obs.topLeft);
                seg2 = new RouteSegment(vertex, obs.topRight);
                break;
            }
            case 16: {
                seg = new RouteSegment(vertex, obs.bottomRight);
                seg2 = new RouteSegment(vertex, obs.topRight);
                break;
            }
            case 4: {
                seg = new RouteSegment(vertex, obs.bottomRight);
                seg2 = new RouteSegment(vertex, obs.bottomLeft);
                break;
            }
            case 8: {
                seg = new RouteSegment(vertex, obs.topLeft);
                seg2 = new RouteSegment(vertex, obs.bottomLeft);
                break;
            }
            default: {
                if (vertex.x == obs.x) {
                    seg = new RouteSegment(vertex, obs.topLeft);
                    seg2 = new RouteSegment(vertex, obs.bottomLeft);
                    break;
                }
                if (vertex.y == obs.y) {
                    seg = new RouteSegment(vertex, obs.topLeft);
                    seg2 = new RouteSegment(vertex, obs.topRight);
                    break;
                }
                if (vertex.y == obs.bottom() - 1) {
                    seg = new RouteSegment(vertex, obs.bottomLeft);
                    seg2 = new RouteSegment(vertex, obs.bottomRight);
                    break;
                }
                if (vertex.x == obs.right() - 1) {
                    seg = new RouteSegment(vertex, obs.topRight);
                    seg2 = new RouteSegment(vertex, obs.bottomRight);
                    break;
                }
                throw new RuntimeException("Unexpected vertex conditions");
            }
        }
        this.stack.push((Object)obs);
        this.stack.push(null);
        this.stack.push(seg);
        this.stack.push((Object)obs);
        this.stack.push(null);
        this.stack.push(seg2);
    }

    private void addSegmentsTargetAboveSource(RouteRectangle source, RouteRectangle target) {
        RouteSegment seg = null;
        RouteSegment seg2 = null;
        if (target.x > source.x) {
            seg = new RouteSegment(source.topLeft, target.topLeft);
            seg2 = target.x < source.right() - 1 ? new RouteSegment(source.topRight, target.bottomLeft) : new RouteSegment(source.bottomRight, target.topLeft);
        } else if (source.x == target.x) {
            seg = new RouteSegment(source.topLeft, target.bottomLeft);
            seg2 = new RouteSegment(source.topRight, target.bottomLeft);
        } else {
            seg = new RouteSegment(source.bottomLeft, target.bottomLeft);
            seg2 = new RouteSegment(source.topRight, target.bottomLeft);
        }
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg);
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg2);
        seg = null;
        seg2 = null;
        if (target.right() < source.right()) {
            seg = new RouteSegment(source.topRight, target.topRight);
            seg2 = target.right() - 1 > source.x ? new RouteSegment(source.topLeft, target.bottomRight) : new RouteSegment(source.bottomLeft, target.topRight);
        } else if (source.right() == target.right()) {
            seg = new RouteSegment(source.topRight, target.bottomRight);
            seg2 = new RouteSegment(source.topLeft, target.bottomRight);
        } else {
            seg = new RouteSegment(source.bottomRight, target.bottomRight);
            seg2 = new RouteSegment(source.topLeft, target.bottomRight);
        }
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg);
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg2);
    }

    private void addSegmentsTargetBesideSource(RouteRectangle source, RouteRectangle target) {
        RouteSegment seg = null;
        RouteSegment seg2 = null;
        if (target.y > source.y) {
            seg = new RouteSegment(source.topLeft, target.topLeft);
            seg2 = target.y < source.bottom() - 1 ? new RouteSegment(source.bottomLeft, target.topRight) : new RouteSegment(source.bottomRight, target.topLeft);
        } else if (source.y == target.y) {
            seg = new RouteSegment(source.topLeft, target.topRight);
            seg2 = new RouteSegment(source.bottomLeft, target.topRight);
        } else {
            seg = new RouteSegment(source.topRight, target.topRight);
            seg2 = new RouteSegment(source.bottomLeft, target.topRight);
        }
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg);
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg2);
        seg = null;
        seg2 = null;
        if (target.bottom() < source.bottom()) {
            seg = new RouteSegment(source.bottomLeft, target.bottomLeft);
            seg2 = target.bottom() - 1 > source.y ? new RouteSegment(source.topLeft, target.bottomRight) : new RouteSegment(source.topRight, target.bottomLeft);
        } else if (source.bottom() == target.bottom()) {
            seg = new RouteSegment(source.bottomLeft, target.bottomRight);
            seg2 = new RouteSegment(source.topLeft, target.bottomRight);
        } else {
            seg = new RouteSegment(source.bottomRight, target.bottomRight);
            seg2 = new RouteSegment(source.topLeft, target.bottomRight);
        }
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg);
        this.stack.push((Object)source);
        this.stack.push((Object)target);
        this.stack.push(seg2);
    }

    void cleanup() {
        this.visibleVertices.clear();
    }

    private void createVisibilityGraph(List<RouteRectangle> allVertexRectangles) {
        this.stack.push(null);
        this.stack.push(null);
        this.stack.push(new RouteSegment(this.start, this.end));
        while (!this.stack.isEmpty()) {
            this.addSegment(this.stack.pop(), this.stack.popVertexRectangle(), this.stack.popVertexRectangle(), allVertexRectangles);
        }
    }

    private boolean determineShortestPath() {
        RoutePoint vertex = this.end;
        this.prevCostRatio = this.end.getCost() / this.start.getDistance(this.end);
        while (!vertex.equals((Object)this.start)) {
            RoutePoint nextVertex = vertex.getLabel();
            if (nextVertex == null) {
                return false;
            }
            this.segments.add(new RouteSegment(nextVertex, vertex));
            vertex = nextVertex;
        }
        Collections.reverse(this.segments);
        return true;
    }

    void fullReset() {
        this.visibleVertices.clear();
        this.segments.clear();
        if (this.prevCostRatio == 0.0) {
            double distance = this.start.getDistance(this.end);
            this.threshold = distance * 1.13;
        } else {
            this.threshold = this.prevCostRatio * 1.04 * this.start.getDistance(this.end);
        }
        this.visibleVertexRectangles.clear();
        this.resetPartial();
    }

    boolean generateShortestPath(List<RouteRectangle> allVertexRectangles) {
        this.createVisibilityGraph(allVertexRectangles);
        if (this.visibleVertices.size() == 0) {
            return false;
        }
        return this.determineShortestPath();
    }

    public PointList getBendPoints() {
        return this.bendpoints;
    }

    public void setBendPoints(PointList bendPoints) {
        this.bendpoints = bendPoints;
        this.isDirty = true;
    }

    public Point getEndPoint() {
        return this.end;
    }

    public void setEndPoint(Point end) {
        if (end.equals((Object)this.end)) {
            return;
        }
        this.end = new RoutePoint(end, null);
        this.isDirty = true;
    }

    public PointList getPoints() {
        return this.points;
    }

    public void setPoints(PointList resultPointList) {
        this.points.removeAllPoints();
        this.points.addAll(resultPointList);
    }

    public Point getStartPoint() {
        return this.start;
    }

    public void setStartPoint(Point start) {
        if (start.equals((Object)this.start)) {
            return;
        }
        this.start = new RoutePoint(start, null);
        this.isDirty = true;
    }

    OrthoPath getSubPath(RouteSegment currentSegment) {
        OrthoPath newPath = new OrthoPath(currentSegment.start, this.end);
        newPath.grownSegments = new ArrayList<RouteSegment>(this.grownSegments.subList(this.grownSegments.indexOf(currentSegment), this.grownSegments.size()));
        this.grownSegments = new ArrayList<RouteSegment>(this.grownSegments.subList(0, this.grownSegments.indexOf(currentSegment) + 1));
        this.end = currentSegment.end;
        this.subPath = newPath;
        return newPath;
    }

    void invertPriorVertices(RouteSegment currentSegment) {
        int stop = this.grownSegments.indexOf(currentSegment);
        int i = 0;
        while (i < stop) {
            RoutePoint vertex = this.grownSegments.get((int)i).end;
            if (vertex.getType() == 1) {
                vertex.setType(2);
            } else {
                vertex.setType(1);
            }
            ++i;
        }
    }

    boolean isVertexRectangleVisible(RouteRectangle obs) {
        return this.visibleVertexRectangles.contains((Object)obs);
    }

    private void linkVertices(RouteSegment segment) {
        if (segment.start.getNeighbors() == null) {
            segment.start.setNeighbors(new ArrayList<Object>());
        }
        if (segment.end.getNeighbors() == null) {
            segment.end.setNeighbors(new ArrayList<Object>());
        }
        if (!segment.start.getNeighbors().contains((Object)segment.end)) {
            segment.start.getNeighbors().add((Object)segment.end);
            segment.end.getNeighbors().add((Object)segment.start);
        }
        this.visibleVertices.add((Object)segment.start);
        this.visibleVertices.add((Object)segment.end);
    }

    void reconnectSubPaths() {
        if (this.subPath != null) {
            this.subPath.reconnectSubPaths();
            RouteSegment changedSegment = this.subPath.grownSegments.remove(0);
            RouteSegment oldSegment = this.grownSegments.get(this.grownSegments.size() - 1);
            oldSegment.end = changedSegment.end;
            this.grownSegments.addAll(this.subPath.grownSegments);
            this.subPath.points.removePoint(0);
            this.points.removePoint(this.points.size() - 1);
            this.points.addAll(this.subPath.points);
            this.visibleVertexRectangles.addAll(this.subPath.visibleVertexRectangles);
            this.end = this.subPath.end;
            this.subPath = null;
        }
    }

    void refreshExcludedVertexRectangles(List<RouteRectangle> allVertexRectangles) {
        this.excludedVertexRectangles.clear();
        int i = 0;
        while (i < allVertexRectangles.size()) {
            RouteRectangle o = allVertexRectangles.get(i);
            o.exclude = false;
            if (o.contains(this.start) && o.containsProper(this.start)) {
                o.exclude = true;
            }
            if (o.contains(this.end) && o.containsProper(this.end)) {
                o.exclude = true;
            }
            if (o.exclude && !this.excludedVertexRectangles.contains((Object)o)) {
                this.excludedVertexRectangles.add(o);
            }
            ++i;
        }
    }

    void resetPartial() {
        this.isMarked = false;
        this.isInverted = false;
        this.subPath = null;
        this.isDirty = false;
        this.grownSegments.clear();
        this.points.removeAllPoints();
    }

    boolean testAndSet(RouteRectangle obs) {
        if (this.isDirty) {
            return false;
        }
        if (this.excludedVertexRectangles.contains((Object)obs)) {
            return false;
        }
        RouteSegment seg1 = new RouteSegment(obs.topLeft, obs.bottomRight);
        RouteSegment seg2 = new RouteSegment(obs.topRight, obs.bottomLeft);
        int s = 0;
        while (s < this.points.size() - 1) {
            this.points.getPoint(CURRENT, s);
            this.points.getPoint(NEXT, s + 1);
            if (seg1.intersects(CURRENT, NEXT) || seg2.intersects(CURRENT, NEXT) || obs.contains(CURRENT) || obs.contains(NEXT)) {
                this.isDirty = true;
                return true;
            }
            ++s;
        }
        return false;
    }

    public List<RouteSegment> getSegments() {
        return this.segments;
    }

    public RoutePoint getStart() {
        return this.start;
    }

    public RoutePoint getEnd() {
        return this.end;
    }

    public List<RouteSegment> getGrownSegments() {
        return this.grownSegments;
    }

    public List<RouteRectangle> getExcludedVertexRectangles() {
        return this.excludedVertexRectangles;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public Set<RouteRectangle> getVisibleVertexRectangles() {
        return this.visibleVertexRectangles;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private static class SegmentStack
    extends ArrayList<Object> {
        private static final long serialVersionUID = -3011759982834461419L;

        private SegmentStack() {
        }

        RouteSegment pop() {
            return (RouteSegment)this.remove(this.size() - 1);
        }

        RouteRectangle popVertexRectangle() {
            return (RouteRectangle)((Object)this.remove(this.size() - 1));
        }

        void push(Object obj) {
            this.add(obj);
        }
    }
}

