/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.java.http.HttpPath;
import com.couchbase.client.java.http.HttpResponse;
import com.couchbase.client.java.http.HttpTarget;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.user.AuthDomain;
import com.couchbase.client.java.manager.user.UserAndMetadata;
import com.dbeaver.db.couchbase3.CouchbaseUtils;
import com.dbeaver.db.couchbase3.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase3.model.CouchbaseBucket;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSourceInfo;
import com.dbeaver.db.couchbase3.model.CouchbaseNode;
import com.dbeaver.db.couchbase3.model.CouchbaseSQLDialect;
import com.dbeaver.db.couchbase3.model.CouchbaseUser;
import com.dbeaver.db.couchbase3.model.plan.CouchbasePlanAnalyser;
import com.dbeaver.model.NoSQLDataSource;
import com.dbeaver.model.NoSQLDataType;
import com.dbeaver.model.document.DocumentDataManager;
import com.dbeaver.model.document.data.DBDocumentUtils;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.IntKeyMap;

public class CouchbaseDataSource
extends NoSQLDataSource<CouchbaseExecutionContext>
implements DocumentDataManager<CouchbaseDataSource, JsonObject>,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable,
DBCQueryTransformProvider {
    private static final Log log = Log.getLog(CouchbaseDataSource.class);
    private final IntKeyMap<NoSQLDataType> dataTypes;
    private CouchbaseDataSourceInfo info;
    private final BucketCache bucketCache = new BucketCache();
    private final UserCache userCache = new UserCache();
    private final NodeCache nodeCache = new NodeCache();
    private static final Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").setLenient().serializeNulls().create();

    public CouchbaseDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        this.dataTypes = DBDocumentUtils.makeDocumentDataTypes((DBPDataSource)this);
        this.executionContext = new CouchbaseExecutionContext(this, "Main Couchbase Connection");
        ((CouchbaseExecutionContext)this.executionContext).connect(monitor);
    }

    public CouchbaseSQLDialect getSQLDialect() {
        return CouchbaseSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        if ("datasource.document-data-source".equals(featureId)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new CouchbaseDataSourceInfo(this);
    }

    @NotNull
    public CouchbaseExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        CouchbaseExecutionContext context = new CouchbaseExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBCQueryTransformProvider.class) {
            return adapter.cast((Object)this);
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new CouchbasePlanAnalyser((DBPDataSource)this));
        }
        return null;
    }

    public void shutdown(@NotNull DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        this.bucketCache.clearCache();
        this.userCache.clearCache();
        this.nodeCache.clearCache();
    }

    public List<CouchbaseBucket> getBuckets(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.bucketCache.getAllObjects(monitor, this);
    }

    @Association
    public List<CouchbaseUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, this);
    }

    @Association
    public List<CouchbaseNode> getNodes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.nodeCache.getAllObjects(monitor, this);
    }

    public List<CouchbaseBucket> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getBuckets(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.bucketCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<CouchbaseBucket> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CouchbaseBucket.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.bucketCache.getAllObjects(monitor, this);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        return DBPDataKind.OBJECT;
    }

    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return null;
    }

    public List<DBSDataType> getLocalDataTypes() {
        return new ArrayList<DBSDataType>(this.dataTypes.values());
    }

    public DBSDataType getLocalDataType(String typeName) {
        for (NoSQLDataType dt : this.dataTypes.values()) {
            if (!dt.getTypeName().equals(typeName)) continue;
            return dt;
        }
        return null;
    }

    public DBSDataType getLocalDataType(int typeID) {
        return (DBSDataType)this.dataTypes.get(typeID);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.bucketCache.clearCache();
        this.userCache.clearCache();
        this.nodeCache.clearCache();
        return this;
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        return null;
    }

    public void serializeDocument(JsonObject document, Writer writer) {
        JSON_BUILDER.toJson((Object)document.toMap(), (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)JSON_BUILDER, (Reader)reader);
    }

    public DBMapValue<CouchbaseDataSource> convertNativeDocumentToMap(JsonObject jsonObject) {
        return CouchbaseUtils.makeRawMap(this, null, jsonObject);
    }

    public JsonObject convertMapToNativeDocument(DBMapValue<CouchbaseDataSource> map) {
        return JsonObject.from((Map)map.getRawValue());
    }

    public DBSDataType getDocumentDataType(int typeId) {
        return (DBSDataType)this.dataTypes.get(typeId);
    }

    public class BucketCache
    extends BasicObjectCache<CouchbaseDataSource, CouchbaseBucket> {
        @NotNull
        public List<CouchbaseBucket> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseBucket> result = new ArrayList<CouchbaseBucket>();
                try {
                    for (BucketSettings bucketSettings : ((CouchbaseExecutionContext)CouchbaseDataSource.this.executionContext).getCluster().buckets().getAllBuckets().values()) {
                        result.add(new CouchbaseBucket(dataSource, bucketSettings, true));
                    }
                    result.sort(DBUtils.nameComparator());
                    this.setCache(result);
                }
                catch (RequestCanceledException requestCanceledException) {
                }
                catch (Exception ex) {
                    throw new DBCException("Exception when getting buckets", (Throwable)ex);
                }
            }
            return this.getCachedObjects();
        }
    }

    public class NodeCache
    extends BasicObjectCache<CouchbaseDataSource, CouchbaseNode> {
        @NotNull
        public List<CouchbaseNode> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                HttpPath of = HttpPath.of((String)"/pools/default/terseClusterInfo?all=true", (String[])new String[0]);
                ArrayList<CouchbaseNode> result = new ArrayList<CouchbaseNode>();
                try {
                    HttpResponse httpResponse = ((CouchbaseExecutionContext)CouchbaseDataSource.this.executionContext).getCluster().httpClient().get(HttpTarget.manager(), of);
                    JsonObject value = JsonObject.fromJson((String)httpResponse.contentAsString());
                    JsonArray nodes = value.getArray("nodes");
                    if (nodes != null) {
                        int i = 0;
                        while (i < nodes.size()) {
                            JsonObject nodeMap = nodes.getObject(i);
                            result.add(new CouchbaseNode(dataSource, nodeMap));
                            ++i;
                        }
                    }
                    this.setCache(result);
                    return result;
                }
                catch (RequestCanceledException requestCanceledException) {
                }
                catch (Exception ex) {
                    throw new DBCException("Exception when getting nodes", (Throwable)ex);
                }
            }
            return this.getCachedObjects();
        }
    }

    public class UserCache
    extends BasicObjectCache<CouchbaseDataSource, CouchbaseUser> {
        @NotNull
        public List<CouchbaseUser> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseUser> result = new ArrayList<CouchbaseUser>();
                ArrayList<UserAndMetadata> userAndMetadata = new ArrayList<UserAndMetadata>();
                try {
                    for (UserAndMetadata it : ((CouchbaseExecutionContext)CouchbaseDataSource.this.executionContext).getCluster().users().getAllUsers()) {
                        if (!it.domain().equals((Object)AuthDomain.LOCAL)) continue;
                        userAndMetadata.add(it);
                    }
                    for (UserAndMetadata user : userAndMetadata) {
                        result.add(new CouchbaseUser(dataSource, user.user()));
                    }
                    result.sort(DBUtils.nameComparator());
                    this.setCache(result);
                }
                catch (RequestCanceledException requestCanceledException) {
                }
                catch (Exception ex) {
                    throw new DBCException("Exception when getting users", (Throwable)ex);
                }
            }
            return this.getCachedObjects();
        }
    }
}

