/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CompressionMode;
import com.couchbase.client.java.manager.bucket.EvictionPolicyType;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.dbeaver.db.couchbase3.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import com.dbeaver.db.couchbase3.model.CouchbaseScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class CouchbaseBucket
implements DBSCatalog,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject {
    private static final Log log = Log.getLog(CouchbaseBucket.class);
    private static final String CAT_MISC = "Misc";
    private static final String CAT_STORAGE = "Storage";
    private boolean persisted;
    private final ScopeCache scopeCache = new ScopeCache();
    private final CouchbaseDataSource dataSource;
    private final BucketSettings bucketSettings;

    public CouchbaseBucket(CouchbaseDataSource dataSource, BucketSettings bucketSettings, boolean persisted) {
        this.dataSource = dataSource;
        this.bucketSettings = bucketSettings;
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.bucketSettings.name();
    }

    public void setName(String newName) {
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, order=2)
    public BucketType getBucketType() {
        return this.bucketSettings.bucketType();
    }

    @Property(viewable=true, order=10)
    public long getQuota() {
        return this.bucketSettings.ramQuotaMB();
    }

    @Property(viewable=true, order=30, category="Storage")
    public int getReplicas() {
        return this.bucketSettings.numReplicas();
    }

    @Property(viewable=true, order=31, category="Storage")
    public boolean getIndexReplicas() {
        return this.bucketSettings.replicaIndexes();
    }

    @Property(viewable=true, order=32, category="Storage")
    public boolean getEnableFlush() {
        return this.bucketSettings.flushEnabled();
    }

    @Property(viewable=true, order=33, category="Storage")
    public CompressionMode getCompressionMode() {
        return this.bucketSettings.compressionMode();
    }

    @Property(viewable=true, order=34, category="Storage")
    public EvictionPolicyType getEjectionMethod() {
        return this.bucketSettings.evictionPolicy();
    }

    public String toString() {
        return this.getName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.scopeCache.clearCache();
        return this;
    }

    @Association
    @NotNull
    public Collection<? extends DBSCatalog> getScopes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.scopeCache.getAllObjects(monitor, this);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.scopeCache.getAllObjects(monitor, this);
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.scopeCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CouchbaseScope.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.scopeCache.getAllObjects(monitor, this);
    }

    public class ScopeCache
    extends BasicObjectCache<CouchbaseBucket, CouchbaseScope> {
        @NotNull
        public Collection<CouchbaseScope> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseBucket couchbaseBucket) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseScope> scopes = new ArrayList<CouchbaseScope>();
                try {
                    List allScopes = ((CouchbaseExecutionContext)CouchbaseBucket.this.dataSource.getDefaultContext()).getCluster().bucket(CouchbaseBucket.this.getName()).collections().getAllScopes();
                    for (ScopeSpec allScope : allScopes) {
                        scopes.add(new CouchbaseScope(allScope, CouchbaseBucket.this.dataSource, couchbaseBucket));
                    }
                    scopes.sort(DBUtils.nameComparator());
                    this.setCache(scopes);
                    return scopes;
                }
                catch (RequestCanceledException requestCanceledException) {
                }
                catch (Exception ex) {
                    throw new DBCException("Exception when getting scopes", (Throwable)ex);
                }
            }
            return this.getCachedObjects();
        }
    }
}

