/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Identity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.AbstractSessionController;
import org.jkiss.dbeaver.model.net.ssh.DBeaverAuthAgent;
import org.jkiss.dbeaver.model.net.ssh.KnownHostsVerifier;
import org.jkiss.dbeaver.model.net.ssh.SSHJSession;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class SSHJSessionController
extends AbstractSessionController<SSHJSession> {
    private static final Log log = Log.getLog(SSHJSessionController.class);

    @NotNull
    protected SSHJSession createSession() {
        return new SSHJSession(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected SSHClient createNewSession(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration host) throws DBException {
        int connectTimeout = configuration.getIntProperty("sshConnectTimeout");
        int keepAliveInterval = configuration.getIntProperty("aliveInterval") / 1000;
        SSHAuthConfiguration auth = host.auth();
        SSHClient client = new SSHClient();
        client.setConnectTimeout(connectTimeout);
        client.getConnection().getKeepAlive().setKeepAliveInterval(keepAliveInterval);
        client.getTransport().getConfig().setLoggerFactory((LoggerFactory)new FilterLoggerFactory());
        try {
            SSHJSessionController.setupHostKeyVerification(client, configuration, host);
        }
        catch (IOException e) {
            log.debug((Object)("Error loading known hosts: " + e.getMessage()));
        }
        monitor.subTask(String.format("Instantiate tunnel to %s:%d", host.hostname(), host.port()));
        try {
            SSHAuthConfiguration sSHAuthConfiguration;
            client.connect(host.hostname(), host.port());
            SSHAuthConfiguration sSHAuthConfiguration2 = auth;
            if (sSHAuthConfiguration2 instanceof SSHAuthConfiguration.Password) {
                void password;
                SSHAuthConfiguration.Password e = (SSHAuthConfiguration.Password)sSHAuthConfiguration2;
                SSHAuthConfiguration.Password cfr_ignored_0 = (SSHAuthConfiguration.Password)sSHAuthConfiguration2;
                if (password.password() != null) {
                    client.authPassword(host.username(), password.password());
                    return client;
                }
            }
            if ((sSHAuthConfiguration = auth) instanceof SSHAuthConfiguration.KeyFile) {
                void key;
                SSHAuthConfiguration.KeyFile keyFile = (SSHAuthConfiguration.KeyFile)sSHAuthConfiguration;
                SSHAuthConfiguration.KeyFile cfr_ignored_1 = (SSHAuthConfiguration.KeyFile)sSHAuthConfiguration;
                if (CommonUtils.isEmpty((String)key.password())) {
                    client.authPublickey(host.username(), new String[]{key.path()});
                    return client;
                }
                client.authPublickey(host.username(), new KeyProvider[]{client.loadKeys(key.path(), key.password().toCharArray())});
                return client;
            }
            SSHAuthConfiguration sSHAuthConfiguration3 = auth;
            if (sSHAuthConfiguration3 instanceof SSHAuthConfiguration.KeyData) {
                void key;
                SSHAuthConfiguration.KeyData keyData = (SSHAuthConfiguration.KeyData)sSHAuthConfiguration3;
                SSHAuthConfiguration.KeyData cfr_ignored_2 = (SSHAuthConfiguration.KeyData)sSHAuthConfiguration3;
                PasswordFinder finder = CommonUtils.isEmpty((String)key.password()) ? null : PasswordUtils.createOneOff((char[])key.password().toCharArray());
                client.authPublickey(host.username(), new KeyProvider[]{client.loadKeys(key.data(), null, finder)});
                return client;
            }
            if (!(auth instanceof SSHAuthConfiguration.Agent)) return client;
            ArrayList<DBeaverAuthAgent> methods = new ArrayList<DBeaverAuthAgent>();
            Iterator iterator = this.createAgentIdentityRepository().getIdentities().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    client.auth(host.username(), methods);
                    return client;
                }
                Object identity = iterator.next();
                methods.add(new DBeaverAuthAgent((Identity)identity));
            }
        }
        catch (Exception e) {
            throw new DBException("Error establishing SSHJ tunnel", (Throwable)e);
        }
    }

    private static void setupHostKeyVerification(@NotNull SSHClient client, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration actualHostConfiguration) throws IOException {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode() || configuration.getBooleanProperty("bypassHostVerification")) {
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            client.getTransport().getConfig().setVerifyHostKeyCertificates(false);
        } else {
            client.addHostKeyVerifier((HostKeyVerifier)new KnownHostsVerifier(SSHUtils.getKnownSshHostsFileOrDefault(), actualHostConfiguration));
        }
        client.loadKnownHosts();
    }

    private static class FilterLoggerFactory
    implements LoggerFactory {
        private static final Set<String> FILTERED_OUT_CLASSES = Set.of("net.schmizz.sshj.common.StreamCopier");

        private FilterLoggerFactory() {
        }

        public Logger getLogger(String s) {
            if (FILTERED_OUT_CLASSES.contains(s)) {
                return NOPLogger.NOP_LOGGER;
            }
            return org.slf4j.LoggerFactory.getLogger((String)s);
        }

        public Logger getLogger(Class<?> cls) {
            return this.getLogger(cls.getName());
        }
    }
}

