/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.security;

import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.storage.PasswordProviderSelector;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.osgi.service.prefs.BackingStoreException;

public class SecurityMethodDialog
extends BaseDialog {
    private static final Log log = Log.getLog(SecurityMethodDialog.class);
    private SecurityMethod method;

    public SecurityMethodDialog(@NotNull Shell shell) {
        super(shell, "Choose security option", null);
        this.setShellStyle(67680);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        UIUtils.createLabel((Composite)composite, (String)"You are about to save secure data. Please choose the appropriate security option below:");
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        int indent = UIUtils.getFontHeight((Control)composite) * 2;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            SecurityMethod securityMethod = this.method = (SecurityMethod)((Object)((Object)e.widget.getData()));
        });
        SecurityMethod[] securityMethodArray = SecurityMethod.values();
        int n = securityMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityMethod method = securityMethodArray[n2];
            Button button = UIUtils.createRadioButton((Composite)composite, (String)method.name, (Object)((Object)method), (SelectionListener)listener);
            button.setLayoutData((Object)GridDataFactory.swtDefaults().indent(indent, 0).create());
            if (method.def) {
                button.setSelection(true);
                button.notifyListeners(13, new Event());
            }
            ++n2;
        }
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        Link hint = UIUtils.createInfoLink((Composite)composite, (String)"Integrated security is less secure than a master password. <a href=\"\">Learn more</a>", () -> {
            boolean bl = ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Project-security"));
        });
        ((GridData)hint.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)hint) * 50;
        return composite;
    }

    protected void okPressed() {
        String disabledModules = PasswordProviderSelector.getInstance().findAvailableModules(null).stream().map(module -> module.moduleID).filter(id -> switch (this.method) {
            case SecurityMethod.MASTER_PASSWORD -> {
                if ("com.dbeaver.app.advanced.dbeaverpasswordprovider".equals(id)) {
                    yield false;
                }
                yield true;
            }
            case SecurityMethod.INTEGRATED_SECURITY -> "com.dbeaver.app.advanced.dbeaverpasswordprovider".equals(id);
            default -> throw new IncompatibleClassChangeError();
        }).collect(Collectors.joining(","));
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("org.eclipse.equinox.security");
        try {
            node.put("org.eclipse.equinox.security.preferences.disabledProviders", disabledModules);
            node.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)"Error saving disabled providers", (Throwable)e);
        }
        InternalExchangeUtils.passwordProvidersReset();
        super.okPressed();
    }

    @NotNull
    public SecurityMethod getMethod() {
        return this.method;
    }

    public static enum SecurityMethod {
        MASTER_PASSWORD("Set up a &master password (recommended)", true),
        INTEGRATED_SECURITY("Use i&ntegrated security", false);

        private final String name;
        private final boolean def;

        private SecurityMethod(String label, boolean def) {
            this.name = label;
            this.def = def;
        }
    }
}

