/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.cli;

import com.dbeaver.application.cli.CustomVariables;
import com.dbeaver.application.cli.HeadlessTaskExecutor;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.ui.app.standalone.CommandLineParameterHandler;

public class TaskParameterHandler
implements CommandLineParameterHandler {
    private static final Log log = Log.getLog(TaskParameterHandler.class);

    public void handleParameter(CommandLine commandLine, String name, String value) {
        try {
            if (!DBPApplicationLicensed.getLicensedApplication().getLicenseService().invalidateActiveLicense(false)) {
                return;
            }
        }
        catch (LMException e) {
            log.error((Object)e);
            return;
        }
        Map<String, String> customParameters = CustomVariables.getCustomParameters();
        try {
            HeadlessTaskExecutor.getInstance().runTask((DBRProgressMonitor)new LoggingProgressMonitor(), value, customParameters);
        }
        catch (DBException e) {
            log.error((Object)"Error executing task", (Throwable)e);
        }
    }
}

