/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.DesktopWorkspaceAdvanced;
import com.dbeaver.application.EnterpriseVersionUpdateDialog;
import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import com.dbeaver.ee.runtime.cert.controller.LocalTrustStoreController;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.model.DBPApplicationExtended;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.model.license.embedded.LicenseServiceEmbedded;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.model.security.DBPasswordValidator;
import com.dbeaver.model.security.DefaultPasswordValidator;
import com.dbeaver.model.security.NameServiceUtils;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IWorkspace;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.qm.QMSessionProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.BasePolicyDataProvider;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class DBeaverApplicationAdvanced
extends DBeaverApplication
implements DBPApplicationExtended,
DBPApplicationLicensed,
QMSessionProvider {
    private static final Log log = Log.getLog(DBeaverApplicationAdvanced.class);
    private static final String JAVA_DEFAULT_CALLBACK_HANDLER = "auth.login.defaultCallbackHandler";
    private DBPLicenseService licenseService;
    private DBPasswordValidator passwordValidator;
    private String qmSessionId;

    public DBeaverApplicationAdvanced() {
    }

    public DBeaverApplicationAdvanced(String defaultWorkspaceLocation, String defaultAppWorkspaceName) {
        super(defaultWorkspaceLocation, defaultAppWorkspaceName);
    }

    protected void initializeConfiguration() {
        super.initializeConfiguration();
        NameServiceUtils.installNameService((Log)log);
    }

    protected void initializeApplication() {
        Path dBeaverTrustStorePath;
        super.initializeApplication();
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        ArrayList<String> applicableProductList = new ArrayList<String>();
        applicableProductList.add(application.getLicenseProductId());
        Collections.addAll(applicableProductList, application.getUmbrellaProductIds());
        for (String productId : applicableProductList) {
            this.addLicenseFiles("." + productId + "-license.dat");
            this.addLicenseFiles("." + productId + "-license.txt");
        }
        if (CommonUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && CommonUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType")) && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("security.truststore.custom") && Files.exists(dBeaverTrustStorePath = LocalTrustStoreController.getDBeaverTrustStorePath(), new LinkOption[0])) {
            System.setProperty("javax.net.ssl.trustStore", dBeaverTrustStorePath.toAbsolutePath().toString());
            System.setProperty("javax.net.ssl.trustStoreType", "bks");
        }
        Security.setProperty(JAVA_DEFAULT_CALLBACK_HANDLER, DefaultCallbackHandler.class.getName());
    }

    private void addLicenseFiles(String licenseFileName) {
        Path workspaceLicenseFile;
        Path userLicenseFile;
        String userHome = System.getProperty("user.home");
        if (userHome != null && Files.exists(userLicenseFile = Path.of(userHome, new String[0]).resolve(licenseFileName), new LinkOption[0])) {
            LMLicenseManager.addLicenseSearchPath((Path)userLicenseFile);
        }
        if (Files.exists(workspaceLicenseFile = GeneralUtils.getMetadataFolder().resolve(licenseFileName), new LinkOption[0])) {
            LMLicenseManager.addLicenseSearchPath((Path)workspaceLicenseFile);
        }
    }

    @NotNull
    public DBPWorkspaceDesktop createWorkspace(@NotNull DBPPlatform platform, @NotNull IWorkspace eclipseWorkspace) {
        return new DesktopWorkspaceAdvanced(platform, eclipseWorkspace);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new EnterpriseWorkbenchAdvisor((DBPApplication)this);
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        LMLicense license;
        block3: {
            try {
                license = this.getLicenseService().getActiveProductLicense(false);
                if (license != null) break block3;
                return "Not licensed! ";
            }
            catch (LMException e) {
                log.error((Object)"Error reading product license", (Throwable)e);
                return null;
            }
        }
        return "Licensed to " + license.getOwnerFull() + "\nLicense ID: " + license.getLicenseId();
    }

    public void notifyVersionUpgrade(@NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean showSkip) {
        EnterpriseVersionUpdateDialog dialog = new EnterpriseVersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public boolean isLicenseRequired() {
        return true;
    }

    @NotNull
    public synchronized DBPLicenseService getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = this.createLicenseService();
        }
        return this.licenseService;
    }

    @NotNull
    public synchronized DBPasswordValidator getPasswordValidator() {
        if (this.passwordValidator == null) {
            try {
                BasePolicyDataProvider provider = BasePolicyDataProvider.getInstance();
                String contents = provider.getPolicyValue("policy.master.password.policy");
                if (contents != null) {
                    this.passwordValidator = DefaultPasswordValidator.fromJson((Reader)new StringReader(contents));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error initializing password validator", (Throwable)e);
            }
        }
        if (this.passwordValidator == null) {
            this.passwordValidator = NoOpPasswordValidator.INSTANCE;
        }
        return this.passwordValidator;
    }

    protected DBPLicenseService createLicenseService() {
        return new LicenseServiceEmbedded();
    }

    public boolean hasProductFeature(@NotNull String featureName) {
        if (featureName.equals("connection/simpleTruststore")) {
            return false;
        }
        return super.hasProductFeature(featureName);
    }

    public QMService getQueryManagerService() {
        return new QMEmbeddedService();
    }

    public QMService getQueryManagerService(@NotNull SMCredentialsProvider credentialsProvider) {
        return this.getQueryManagerService();
    }

    @Nullable
    public String getQmSessionId() {
        return this.qmSessionId;
    }

    public synchronized void setQmSessionId(@NotNull String qmSessionId) {
        this.qmSessionId = qmSessionId;
    }

    public boolean isCommunity() {
        return false;
    }

    private static class NoOpPasswordValidator
    implements DBPasswordValidator {
        public static final NoOpPasswordValidator INSTANCE = new NoOpPasswordValidator();

        private NoOpPasswordValidator() {
        }

        public void validate(@NotNull String password) {
        }
    }
}

