/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import com.vertica.support.EscapeTypes;
import com.vertica.support.IReplacer;
import com.vertica.support.IReplacerChecked;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCEscaper {
    private static final int RETYPE_NAME = 1;
    private static final int RETYPE_VALUE = 2;
    private static final int RETYPE_LIMIT = 3;
    private static final int RETYPE_OFFSET = 4;
    private static final int RETYPE_FNAME = 5;
    private static final int RETYPE_ARGIND = 6;
    private static final int RETYPE_LAST = 6;
    private static final int LIKEESCAPE_PATTERN = 2;
    private static final String WS = " \\s* ";
    private static final String QWORD = "\\[ [^\\]]* \\] ";
    private static final String QNUM = "\\? | \\d+";
    private static final String CCB = "[}]";
    private static final String ARGIND = "[(] |[}]";
    private static final int flags = 14;
    private static final Pattern s_re_scan = Pattern.compile("(?:           \" [^\"]* \" |      \\b E   ' (?: \\\\.  |  [^'] )* ' | (?<! \\b E ) ' [^']*   ' |  \\[ [^\\]]* \\] | -- [^\\n]*   $| /[*]  (?: [^/] | (?<= [^*]) / )*  \\*/| (?! \\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] | [^$,{?}()] )*", 14);
    private static final Pattern s_re_type = Pattern.compile(" \\s* (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*     ( (?: - \\s* )?      ' [^']* '      [-().,:/\\s\\w]*    )  ) \\s* [}]| (?:limit \\s* (\\? | \\d+) (?:  \\s*  offset  \\s*  (\\? | \\d+) )? ) \\s* [}]| oj | (?: call | fn | [?] \\s* = \\s* call ) \\s*   ( [\\w.]+   | \" [^\"]* \"    | \\[ [^\\]]* \\]  (?:  \\s* [.] \\s* \\[ [^\\]]* \\]  )*  ) \\s*   ( [(] |[}] )) \\s* ", 14);
    private static final Pattern s_re_likeEscape = Pattern.compile("(LIKE(\\s)*((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))((?:(\\s)+ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))|(\\s)*\\{(\\s)*ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+)(\\s)*\\})", 14);
    private String m_query;
    private Matcher scanMatcher;
    private Matcher typeMatcher;
    private Matcher likeMatcher;

    public String Apply(IReplacer replacer, String in_query) {
        return this.Apply((IReplacerChecked)replacer, in_query);
    }

    public <T extends Throwable> String Apply(IReplacerChecked<T> replacer, String in_query) throws T {
        if (in_query == null || in_query.isEmpty()) {
            return in_query;
        }
        assert (replacer != null);
        StringBuilder result = new StringBuilder();
        this.m_query = in_query;
        this.scanMatcher = s_re_scan.matcher(in_query.toUpperCase());
        this.typeMatcher = s_re_type.matcher(in_query.toLowerCase());
        this.likeMatcher = s_re_likeEscape.matcher(in_query.toUpperCase());
        int pos = this.Apply(replacer, 0, 0, result);
        return result.toString();
    }

    public int Scan(String in_query, int in_pos, String in_subset) {
        if (in_query == null || in_query.isEmpty()) {
            return 0;
        }
        this.m_query = in_query;
        Matcher matcher = s_re_scan.matcher(this.m_query);
        in_pos = this.Scan(in_pos, in_subset, matcher);
        return in_pos;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T extends Throwable> int Apply(IReplacerChecked<T> replacer, int start, int depth, StringBuilder out_result) throws T {
        assert (replacer != null);
        assert (this.scanMatcher != null);
        assert (this.typeMatcher != null);
        assert (this.m_query != null);
        String state_junk = "}";
        String state_init = "?{";
        String state_oj = "}?{";
        String state_args = ",)(}?{";
        String state = "?{";
        EscapeTypes etype = EscapeTypes.UNKNOWN;
        int argstart = -1;
        int round = 0;
        int pos = 0;
        StringBuilder junk = new StringBuilder();
        ArrayList<StringBuilder> args = new ArrayList<StringBuilder>();
        while (true) {
            block59: {
                String escapeCharacter;
                int groupNum;
                String pattern;
                block62: {
                    StringBuilder res;
                    block57: {
                        block61: {
                            block60: {
                                int bracket;
                                block58: {
                                    pos = this.Scan(start, state, this.scanMatcher);
                                    res = "?{".equals(state) ? out_result : ("}".equals(state) ? junk : (StringBuilder)args.get(args.size() - 1));
                                    if (pos > start) {
                                        res.append(this.m_query.substring(start, pos));
                                    }
                                    if (pos >= this.m_query.length()) {
                                        return pos;
                                    }
                                    if (!Character.isLetter(this.m_query.charAt(pos))) break block57;
                                    if (!state.equals(",)(}?{")) break block58;
                                    assert (round > 0);
                                    pos = this.Apply(replacer, pos, depth, res);
                                    break block59;
                                }
                                if ('L' == this.m_query.charAt(pos) || 'l' == this.m_query.charAt(pos)) break block60;
                                assert (round == 0);
                                etype = EscapeTypes.FN;
                                int namend = bracket = this.m_query.indexOf("(", pos);
                                while (Character.isSpaceChar(this.m_query.charAt(namend - 1))) {
                                    --namend;
                                }
                                args.clear();
                                args.add(new StringBuilder(this.m_query.substring(pos, namend)));
                                pos = bracket + 1;
                                round = 1;
                                state = ",)(}?{";
                                break block59;
                            }
                            if (this.likeMatcher.find(pos)) break block61;
                            out_result.append("LIKE");
                            pos += 4;
                            break block59;
                        }
                        etype = EscapeTypes.LIKE_ESCAPE;
                        int escapeMatched = 2;
                        while (null == this.likeMatcher.group(escapeMatched)) {
                            ++escapeMatched;
                        }
                        out_result.append(this.m_query.substring(pos, this.likeMatcher.start(escapeMatched)));
                        out_result.append(" ");
                        args.clear();
                        pattern = this.likeMatcher.group(escapeMatched);
                        groupNum = escapeMatched + 1;
                        break block62;
                    }
                    block0 : switch (this.m_query.charAt(pos++)) {
                        case '?': {
                            res.append((CharSequence)replacer.replace(EscapeTypes.PARAM, args));
                            break;
                        }
                        case '(': {
                            ++round;
                            res.append('(');
                            break;
                        }
                        case ')': {
                            if (--round == 0 && ",)(}?{".equals(state)) {
                                state = "}";
                                break;
                            }
                            res.append(')');
                            break;
                        }
                        case ',': {
                            if (round == 1) {
                                argstart = pos;
                                args.add(new StringBuilder(""));
                                break;
                            }
                            res.append(',');
                            break;
                        }
                        case '}': {
                            assert (!"?{".equals(state));
                            for (int j = 1; j < args.size(); ++j) {
                                StringBuilder lArg = args.get(j);
                                while (0 != lArg.length() && Character.isWhitespace(lArg.charAt(0))) {
                                    lArg.deleteCharAt(0);
                                }
                            }
                            int len = out_result.length();
                            if (len > 0 && Character.isLetterOrDigit(out_result.charAt(len - 1))) {
                                out_result.append(" ");
                            }
                            out_result.append((CharSequence)replacer.replace(etype, args)).append((CharSequence)junk);
                            args.clear();
                            junk = new StringBuilder();
                            if (depth > 0) {
                                return pos;
                            }
                            state = "?{";
                            break;
                        }
                        case '{': {
                            int len;
                            if (!"?{".equals(state)) {
                                pos = this.Apply(replacer, pos - 1, depth + 1, args.get(args.size() - 1));
                                break;
                            }
                            if (!$assertionsDisabled) {
                                if (pos < 0) throw new AssertionError();
                                if (pos > this.m_query.length()) {
                                    throw new AssertionError();
                                }
                            }
                            if (!this.typeMatcher.find(pos) || pos != this.typeMatcher.start()) {
                                out_result.append(this.m_query.substring(pos - 1, this.m_query.length()));
                                return this.m_query.length();
                            }
                            pos = this.typeMatcher.start(1);
                            switch (Character.toLowerCase(this.m_query.charAt(pos))) {
                                case 'd': {
                                    etype = EscapeTypes.DATE;
                                    break;
                                }
                                case 'e': {
                                    etype = EscapeTypes.ESCAPE;
                                    break;
                                }
                                case 'l': {
                                    etype = EscapeTypes.LIMIT_OFFSET;
                                    break;
                                }
                                case 't': {
                                    etype = Character.toLowerCase(this.m_query.charAt(pos + 1)) == 's' ? EscapeTypes.TIMESTAMP : EscapeTypes.TIME;
                                    break;
                                }
                                case 'i': {
                                    etype = EscapeTypes.INTERVAL;
                                    break;
                                }
                                case 'o': {
                                    etype = EscapeTypes.OUTERJOIN;
                                    break;
                                }
                                case 'c': {
                                    etype = EscapeTypes.CALL;
                                    break;
                                }
                                case '?': {
                                    etype = EscapeTypes.RESULT;
                                    break;
                                }
                                case 'f': {
                                    etype = EscapeTypes.FN;
                                    break;
                                }
                                case 'g': {
                                    etype = EscapeTypes.GUID;
                                    break;
                                }
                            }
                            args.clear();
                            switch (etype) {
                                case DATE: 
                                case ESCAPE: 
                                case TIME: 
                                case TIMESTAMP: 
                                case INTERVAL: 
                                case GUID: {
                                    args.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(2), this.typeMatcher.end(2))));
                                    len = out_result.length();
                                    if (len > 0 && Character.isLetterOrDigit(out_result.charAt(len - 1))) {
                                        out_result.append(" ");
                                    }
                                    out_result.append((CharSequence)replacer.replace(etype, args));
                                    if (depth > 0) {
                                        return this.typeMatcher.end(0);
                                    }
                                    args.clear();
                                    break;
                                }
                                case LIMIT_OFFSET: {
                                    args.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(3), this.typeMatcher.end(3))));
                                    if (this.typeMatcher.start(4) != -1) {
                                        args.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(4), this.typeMatcher.end(4))));
                                    }
                                    out_result.append((CharSequence)replacer.replace(etype, args));
                                    break;
                                }
                                case OUTERJOIN: {
                                    state = "}?{";
                                    argstart = this.typeMatcher.end(0);
                                    args.add(new StringBuilder(""));
                                    break;
                                }
                                case CALL: 
                                case RESULT: 
                                case FN: {
                                    args.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(5), this.typeMatcher.end(5))));
                                    pos = this.typeMatcher.start(6);
                                    state = ",)(}?{";
                                    if (this.m_query.charAt(pos) == '}') break block0;
                                    round = 1;
                                    argstart = this.typeMatcher.end(0);
                                    args.add(new StringBuilder(""));
                                }
                            }
                            pos = this.typeMatcher.end(0);
                            break;
                        }
                    }
                    break block59;
                }
                while (2 > pattern.length()) {
                    int groupStart = this.likeMatcher.start(groupNum);
                    int groupEnd = this.likeMatcher.end(groupNum);
                    if (-1 != groupStart && -1 != groupEnd) {
                        pattern = this.m_query.substring(this.likeMatcher.start(groupNum), this.likeMatcher.end(groupNum++));
                        if (pattern.equals("?")) {
                            pattern = replacer.replace(EscapeTypes.PARAM, args).toString();
                        }
                        if (groupNum != this.likeMatcher.groupCount()) continue;
                        return this.m_query.length();
                    }
                    ++groupNum;
                }
                int index = -1;
                while (-1 == index) {
                    index = this.likeMatcher.start(groupNum);
                    if (null == this.likeMatcher.group(groupNum) || 2 > this.likeMatcher.group(groupNum).length() || this.likeMatcher.group(groupNum).toUpperCase().contains("ESCAPE")) {
                        index = -1;
                    }
                    if (++groupNum != this.likeMatcher.groupCount()) continue;
                    return this.m_query.length();
                }
                if ((escapeCharacter = this.m_query.substring(this.likeMatcher.start(--groupNum), this.likeMatcher.end(groupNum))).equals("?")) {
                    escapeCharacter = replacer.replace(EscapeTypes.PARAM, args).toString();
                }
                args.add(new StringBuilder(pattern));
                args.add(new StringBuilder(escapeCharacter));
                out_result.append(replacer.replace(etype, args).toString());
                state = "?{";
                pos = this.likeMatcher.end(0);
            }
            start = pos;
        }
    }

    private int Scan(int in_start, String in_subset, Matcher io_matcher) {
        assert (io_matcher != null);
        assert (in_subset != null);
        assert (in_start >= 0 && in_start <= this.m_query.length());
        while (io_matcher.find(in_start)) {
            int pos = io_matcher.start(1);
            if (-1 == pos) {
                pos = io_matcher.end(0);
            }
            if (pos == -1 || pos >= this.m_query.length()) {
                return this.m_query.length();
            }
            char[] subsetArray = in_subset.toCharArray();
            char posChar = this.m_query.charAt(pos);
            if (Character.isLetter(posChar)) {
                return pos;
            }
            for (int i = 0; i < subsetArray.length; ++i) {
                if (posChar != subsetArray[i]) continue;
                return pos;
            }
            in_start = pos + 1;
        }
        return this.m_query.length();
    }
}

