/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.jdbc41.S41Connection;
import com.vertica.jdbc.jdbc41.S41PooledConnection;
import com.vertica.jdbc.jdbc41.S41PreparedStatement;
import com.vertica.jdbc.jdbc41.S41PreparedStatementHandle;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;

public class S41ConnectionHandle
extends SConnectionHandle {
    public S41ConnectionHandle(SConnection connection, SPooledConnection pooledConnection) throws SQLException {
        super(connection, pooledConnection);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getClientInfo();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getClientInfo(name);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, autoGeneratedKeys);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, columnIndexes);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, columnNames);
            return new S41PreparedStatementHandle((S41PooledConnection)this.m_pooledConnection, (S41PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S41Connection)this.m_connection).setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S41Connection)this.m_connection).setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkIfOpen();
        try {
            ((S41Connection)this.m_connection).setSchema(schema);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getSchema();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkIfOpen();
        try {
            ((S41Connection)this.m_connection).abort(executor);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkIfOpen();
        try {
            ((S41Connection)this.m_connection).setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S41Connection)this.m_connection).getNetworkTimeout();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }
}

