/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.interfaces.IResults;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.streams.IStream;
import com.vertica.streams.parametersoutput.CharacterParameterDataStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SCallableStatement
extends SPreparedStatement
implements CallableStatement {
    private boolean m_wasLastParameterNull = false;
    private List<DataWrapper> m_parameterOutputValues = new ArrayList<DataWrapper>();
    protected List<Boolean> m_parameterRegistered = new ArrayList<Boolean>();
    protected Map<Integer, Integer> m_parameterScale = new HashMap<Integer, Integer>();
    private IStream m_currentStream = null;

    protected SCallableStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(sql, statement, conn, concurrency);
        LogUtilities.logFunctionEntrance(this.m_logger, sql, statement, conn);
        this.resetRegisteredParameters();
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.clearParameters();
        if (null != this.m_parameterRegistered) {
            this.resetRegisteredParameters();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        return super.execute();
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_parameterRegistered.contains(Boolean.TRUE)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            return super.executeBatch();
        }
        catch (SQLException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        return super.executeQuery();
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getArray(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                BigDecimal bigDec = TypeConverter.toBigDecimal(data, this.m_warningListener);
                Integer scale = this.m_parameterScale.get(parameterIndex);
                if (null != scale) {
                    bigDec = bigDec.setScale((int)scale, RoundingMode.HALF_UP);
                }
                this.m_wasLastParameterNull = data.isNull();
                return bigDec;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(2));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, scale);
        BigDecimal bigDec = this.getBigDecimal(parameterIndex);
        if (null != bigDec) {
            return bigDec.setScale(scale, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getBigDecimal(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Blob getBlob(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public synchronized Blob getBlob(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getBlob(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized boolean getBoolean(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                boolean value = TypeConverter.toBoolean(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(16));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getBoolean(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getBoolean(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized byte getByte(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                byte value = TypeConverter.toByte(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(-6));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized byte getByte(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getByte(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                byte[] value = TypeConverter.toBytes(data);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(-2));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized byte[] getBytes(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getBytes(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Clob getClob(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public synchronized Clob getClob(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getClob(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Date getDate(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        return this.getDate(parameterIndex, null);
    }

    @Override
    public synchronized Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                Date value = TypeConverter.toDate(data, cal, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(91));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Date getDate(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getDate(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Date getDate(String parameterName, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, cal);
        return this.getDate(this.getParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized double getDouble(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                double value = TypeConverter.toDouble(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(8));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized double getDouble(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getDouble(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized float getFloat(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                float value = TypeConverter.toFloat(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(7));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized float getFloat(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getFloat(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized int getInt(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                int value = TypeConverter.toInt(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(4));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getInt(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getInt(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized long getLong(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                long value = TypeConverter.toLong(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(-5));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLong(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getLong(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Object getObject(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                ParameterMetadata meta = (ParameterMetadata)this.m_parameterMetadata.get(parameterIndex - 1);
                Object value = TypeConverter.toObject(data, meta.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, map);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public synchronized Object getObject(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getObject(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, map);
        return this.getObject(this.getParameterIndex(parameterName), map);
    }

    @Override
    public synchronized Ref getRef(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public synchronized Ref getRef(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getRef(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized short getShort(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                short value = TypeConverter.toShort(data, this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(5));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized short getShort(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getShort(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized String getString(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                ParameterMetadata paramMeta = (ParameterMetadata)this.m_parameterMetadata.get(parameterIndex - 1);
                String value = TypeConverter.toString(data, paramMeta.getTypeMetadata());
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(12));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized String getString(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getString(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Time getTime(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        return this.getTime(parameterIndex, null);
    }

    @Override
    public synchronized Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                Time value = TypeConverter.toTime(data, cal, ((ParameterMetadata)this.m_parameterMetadata.get(parameterIndex - 1)).getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(92));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Time getTime(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getTime(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Time getTime(String parameterName, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, cal);
        return this.getTime(this.getParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        return this.getTimestamp(parameterIndex, null);
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            try {
                Timestamp value = TypeConverter.toTimestamp(data, cal, ((ParameterMetadata)this.m_parameterMetadata.get(parameterIndex - 1)).getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(93));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getTimestamp(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, cal);
        return this.getTimestamp(this.getParameterIndex(parameterName), cal);
    }

    @Override
    public synchronized URL getURL(int parameterIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public synchronized URL getURL(String parameterName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getURL(this.getParameterIndex(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            if (TypeConverter.canConvertStreamFrom(data.getType(), -1)) {
                if (data.isNull()) {
                    return null;
                }
                CharacterParameterDataStream stream = new CharacterParameterDataStream(data.getLongVarChar().getBytes("UTF-16"));
                this.m_currentStream = stream;
                return stream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), "CharacterStream");
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getCharacterStream(this.getParameterIndex(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getNCharacterStream(this.getParameterIndex(parameterName));
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getNClob(this.getParameterIndex(parameterName));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public String getNString(String parameterName) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getNString(this.getParameterIndex(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getRowId(this.getParameterIndex(parameterName));
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        return this.getSQLXML(this.getParameterIndex(parameterName));
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, sqlType);
        this.registerOutParameter(parameterIndex, sqlType, 0);
        if (TypeUtilities.isExactNumericType(sqlType)) {
            this.m_parameterScale.remove(parameterIndex);
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, sqlType, scale);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            this.checkTypeSupported(sqlType);
            if (0 > scale) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SCALE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(scale), "0");
            }
            if (ParameterType.INPUT == this.m_parameterTypes.get(parameterIndex - 1)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_REGISTER_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(parameterIndex));
            }
            ParameterMetadata paramMeta = (ParameterMetadata)this.m_parameterMetadata.get(parameterIndex - 1);
            short paramType = paramMeta.getTypeMetadata().getType();
            if (!TypeConverter.canConvert(paramType, sqlType)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(sqlType));
            }
            if (TypeUtilities.isExactNumericType(sqlType)) {
                this.m_parameterScale.put(parameterIndex, scale);
            }
            int outputIndex = this.getOutputParameterOnlyIndex(parameterIndex);
            this.m_parameterRegistered.set(outputIndex - 1, Boolean.TRUE);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, sqlType, typeName);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        this.registerOutParameter(parameterIndex, sqlType, 0);
        if (TypeUtilities.isExactNumericType(sqlType)) {
            this.m_parameterScale.remove(parameterIndex);
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, sqlType);
        this.registerOutParameter(this.getParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, sqlType, scale);
        this.registerOutParameter(this.getParameterIndex(parameterName), sqlType, scale);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, sqlType, typeName);
        this.registerOutParameter(this.getParameterIndex(parameterName), sqlType, typeName);
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream value, int length) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, length);
        this.setAsciiStream(this.getParameterIndex(parameterName), value, length);
    }

    @Override
    public synchronized void setBigDecimal(String parameterName, BigDecimal value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setBigDecimal(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream value, int length) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, length);
        this.setBinaryStream(this.getParameterIndex(parameterName), value, length);
    }

    @Override
    public synchronized void setBoolean(String parameterName, boolean value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setBoolean(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setByte(String parameterName, byte value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setByte(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setBytes(String parameterName, byte[] value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setBytes(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader, length);
        this.setCharacterStream(this.getParameterIndex(parameterName), reader, length);
    }

    @Override
    public synchronized void setDate(String parameterName, Date value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setDate(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setDate(String parameterName, Date value, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, cal);
        this.setDate(this.getParameterIndex(parameterName), value, cal);
    }

    @Override
    public synchronized void setDouble(String parameterName, double value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setDouble(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setFloat(String parameterName, float value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, Float.valueOf(value));
        this.setFloat(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setInt(String parameterName, int value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setInt(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setLong(String parameterName, long value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setLong(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, sqlType);
        this.setNull(this.getParameterIndex(parameterName), sqlType);
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, sqlType, typeName);
        this.setNull(this.getParameterIndex(parameterName), sqlType, typeName);
    }

    @Override
    public synchronized void setObject(String parameterName, Object value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setObject(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setObject(String parameterName, Object value, int targetSqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, targetSqlType);
        this.setObject(this.getParameterIndex(parameterName), value, targetSqlType);
    }

    @Override
    public synchronized void setObject(String parameterName, Object value, int targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, targetSqlType, scale);
        this.setObject(this.getParameterIndex(parameterName), value, targetSqlType, scale);
    }

    @Override
    public synchronized void setShort(String parameterName, short value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setShort(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setString(String parameterName, String value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setString(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setTime(String parameterName, Time value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setTime(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setTime(String parameterName, Time value, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, cal);
        this.setTime(this.getParameterIndex(parameterName), value, cal);
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setTimestamp(this.getParameterIndex(parameterName), value);
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp value, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, cal);
        this.setTimestamp(this.getParameterIndex(parameterName), value, cal);
    }

    @Override
    public synchronized void setURL(String parameterName, URL value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setURL(this.getParameterIndex(parameterName), value);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        this.setAsciiStream(this.getParameterIndex(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName);
        this.setAsciiStream(this.getParameterIndex(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, x);
        this.setBinaryStream(this.getParameterIndex(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, x);
        this.setBinaryStream(this.getParameterIndex(parameterName), x, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, x);
        this.setBlob(this.getParameterIndex(parameterName), x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, inputStream);
        this.setBlob(this.getParameterIndex(parameterName), inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, inputStream, length);
        this.setBlob(this.getParameterIndex(parameterName), inputStream, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader);
        this.setCharacterStream(this.getParameterIndex(parameterName), reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader, length);
        this.setCharacterStream(this.getParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, x);
        this.checkIfOpen();
        this.getParameterIndex(parameterName);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader);
        this.setClob(this.getParameterIndex(parameterName), reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader, length);
        this.setClob(this.getParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setNCharacterStream(this.getParameterIndex(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, length);
        this.setNCharacterStream(this.getParameterIndex(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setNClob(this.getParameterIndex(parameterName), value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader);
        this.setNClob(this.getParameterIndex(parameterName), reader);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, reader, length);
        this.setNClob(this.getParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value);
        this.setNString(this.getParameterIndex(parameterName), value);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, x);
        this.setRowId(this.getParameterIndex(parameterName), x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, xmlObject);
        this.setSQLXML(this.getParameterIndex(parameterName), xmlObject);
    }

    @Override
    public boolean wasNull() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        return this.m_wasLastParameterNull;
    }

    @Override
    protected boolean allInputParameterValuesPopulated() {
        int numInputParameters = this.m_parameterInputStreamData.size() + this.m_parameterInputValues.size();
        int numOutputOnlyParameters = 0;
        for (ParameterMetadata paramMeta : this.m_parameterMetadata) {
            if (ParameterType.OUTPUT != paramMeta.getParameterType() && ParameterType.RETURN_VALUE != paramMeta.getParameterType()) continue;
            ++numOutputOnlyParameters;
        }
        return numInputParameters + numOutputOnlyParameters == this.m_parameterMetadata.size();
    }

    @Override
    protected void checkParameters(List<ParameterMetadata> paramMetadata) throws SQLException {
    }

    @Override
    protected void checkTypeSupported(int sqlType) throws SQLException {
        switch (sqlType) {
            case -11: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IResults executeWithParams(ArrayList<ParameterMetadata> metadata, ArrayList<ArrayList<ParameterInputValue>> inputValues, ParameterGeneratedValues generatedParams, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.checkCondition(this.m_preparedSql, throwCondition);
            ExecutionContexts execContexts = new ExecutionContexts(metadata, inputValues, this.m_generatedParams);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(execContexts, this.m_warningListener);
            Iterator<ArrayList<DataWrapper>> outputIter = execContexts.outputIterator();
            if (outputIter.hasNext()) {
                this.m_parameterOutputValues = outputIter.next();
            }
            IResults iResults = this.m_queryExecutor.getResults();
            return iResults;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = false;
                this.m_isCanceled = false;
            }
        }
    }

    protected int getOutputParameterOnlyIndex(int parameterIndex) throws SQLException {
        this.checkValidParameterIndex(parameterIndex);
        if (ParameterType.INPUT == this.m_parameterTypes.get(parameterIndex - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_RETRIEVE_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex));
        }
        int outputParamCount = 0;
        for (int i = 0; i < parameterIndex; ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            ++outputParamCount;
        }
        if (0 == outputParamCount) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_OUTPUT_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(parameterIndex));
        }
        return outputParamCount;
    }

    protected DataWrapper getOutputParameterValue(int parameterIndex) throws SQLException {
        int outputParamCount = this.getOutputParameterOnlyIndex(parameterIndex);
        return this.m_parameterOutputValues.get(outputParamCount - 1);
    }

    protected int getParameterIndex(String parameterName) throws SQLException {
        for (int i = 0; i < this.m_parameterMetadata.size(); ++i) {
            ParameterMetadata paramMeta = (ParameterMetadata)this.m_parameterMetadata.get(i);
            if (!paramMeta.getName().equals(parameterName)) continue;
            return i + 1;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_NAME, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, parameterName);
    }

    private boolean allOutputParametersRegistered() {
        return !this.m_parameterRegistered.contains(Boolean.FALSE);
    }

    private void resetRegisteredParameters() {
        this.m_parameterRegistered.clear();
        for (int i = 0; i < this.m_numParameters; ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            this.m_parameterRegistered.add(Boolean.FALSE);
        }
        this.m_parameterScale.clear();
    }

    private void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }
}

