/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.exceptions;

import com.vertica.dsi.exceptions.DSIRuntimeException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IMessageSource;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import java.util.Locale;

public final class InvalidArgumentException
extends DSIRuntimeException {
    private static final long serialVersionUID = 5547653333445247686L;
    private ErrorException m_exception = null;
    private int m_errorCode = 0;

    public InvalidArgumentException(int componentId, String msgParam) {
        this.m_exception = new ErrorException(DiagState.DIAG_GENERAL_ERROR, componentId, DSIMessageKey.INVALID_NULL_ARG.name(), new String[]{msgParam});
    }

    public InvalidArgumentException(int componentId, String msgKey, String[] msgParams) {
        this.m_exception = null == msgParams ? new ErrorException(DiagState.DIAG_GENERAL_ERROR, componentId, msgKey) : new ErrorException(DiagState.DIAG_GENERAL_ERROR, componentId, msgKey, msgParams);
    }

    public InvalidArgumentException(String message, int nativeErrorCode) {
        this.m_exception = new ErrorException(DiagState.DIAG_GENERAL_ERROR, message, nativeErrorCode);
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    @Override
    public String getLocalizedMessage() {
        return this.m_exception.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        return this.m_exception.getMessage();
    }

    public void loadMessage(IMessageSource messageSource, Locale locale) {
        if (this.m_exception.hasPreformattedMessage()) {
            return;
        }
        this.m_exception.loadMessage(messageSource, locale);
        this.m_errorCode = this.m_exception.getNativeErrorCode(null, null);
    }
}

