/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.utilities.CalendarSetter;
import java.sql.Time;
import java.util.Calendar;

public class TimeTz
extends Time {
    private static final long serialVersionUID = 617671935649092790L;
    private Calendar m_timezoneCal;

    public TimeTz(Time time, Calendar timezoneCal) {
        super(time.getTime());
        this.m_timezoneCal = null == timezoneCal ? Calendar.getInstance() : timezoneCal;
    }

    public TimeTz(long timeMillis, Calendar timezoneCal) {
        super(timeMillis);
        this.m_timezoneCal = null == timezoneCal ? Calendar.getInstance() : timezoneCal;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof TimeTz) {
            TimeTz other = (TimeTz)obj;
            return this.m_timezoneCal.getTimeZone().getOffset(this.getTime()) == other.getTimezoneCalendar().getTimeZone().getOffset(other.getTime());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 7 * this.m_timezoneCal.getTimeZone().getOffset(this.getTime());
    }

    public synchronized Time getAdjustedTime() {
        return CalendarSetter.getTime(this, Calendar.getInstance(), this.m_timezoneCal);
    }

    public Calendar getTimezoneCalendar() {
        return this.m_timezoneCal;
    }

    @Override
    public String toString() {
        String timeStringNoMilliseconds = super.toString();
        int milliseconds = (int)(this.getTime() % 1000L);
        String millisecondStr = String.format("%03d", milliseconds);
        StringBuilder sb = new StringBuilder();
        sb.append(timeStringNoMilliseconds);
        sb.append(".");
        sb.append(millisecondStr);
        return sb.toString();
    }

    @Override
    public Object clone() {
        TimeTz t = (TimeTz)super.clone();
        if (this.m_timezoneCal != null) {
            t.m_timezoneCal = (Calendar)this.m_timezoneCal.clone();
        }
        return t;
    }
}

