/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.support.exceptions.ErrorException;

public class ColumnMetadata
implements IColumn {
    private String m_label;
    private String m_name;
    private String m_catalogName;
    private String m_schemaName;
    private String m_tableName;
    private TypeMetadata m_typeMetadata;
    private Updatable m_updatable;
    private Searchable m_searchable;
    private Nullable m_nullable;
    private long m_columnLength;
    private boolean m_isAutoUnique;
    private boolean m_isCaseSensitive;

    public ColumnMetadata(TypeMetadata typeMetadata) throws NullPointerException {
        if (null == typeMetadata) {
            throw new NullPointerException();
        }
        this.m_typeMetadata = typeMetadata;
        this.m_label = "";
        this.m_name = "";
        this.m_catalogName = "";
        this.m_schemaName = "";
        this.m_tableName = "";
        this.m_updatable = Updatable.UNKNOWN;
        this.m_searchable = Searchable.SEARCHABLE;
        this.m_nullable = Nullable.UNKNOWN;
        this.m_columnLength = 0L;
        this.m_isAutoUnique = false;
        this.m_isCaseSensitive = false;
    }

    public static ColumnMetadata copyOf(IColumn column) {
        ColumnMetadata copy = new ColumnMetadata(TypeMetadata.copyOf(column.getTypeMetadata()));
        copy.setAutoUnique(column.isAutoUnique());
        copy.setCaseSensitive(column.isCaseSensitive());
        copy.setCatalogName(column.getCatalogName());
        try {
            copy.setColumnLength(column.getColumnLength());
        }
        catch (NumericOverflowException e) {
            throw new RuntimeException(e);
        }
        copy.setLabel(column.getLabel());
        copy.setName(column.getName());
        copy.setNullable(column.getNullable());
        copy.setSchemaName(column.getSchemaName());
        copy.setSearchable(column.getSearchable());
        copy.setTableName(column.getTableName());
        copy.setTypeMetadata(TypeMetadata.copyOf(column.getTypeMetadata()));
        copy.setUpdatable(column.getUpdatable());
        return copy;
    }

    @Override
    public String getCatalogName() {
        return this.m_catalogName;
    }

    @Override
    public long getColumnLength() {
        return this.m_columnLength;
    }

    @Override
    public long getDisplaySize() throws ErrorException {
        return TypeUtilities.getDisplaySize(this.m_typeMetadata, this.m_columnLength);
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Nullable getNullable() {
        return this.m_nullable;
    }

    @Override
    public String getSchemaName() {
        return this.m_schemaName;
    }

    @Override
    public Searchable getSearchable() {
        return this.m_searchable;
    }

    @Override
    public String getTableName() {
        return this.m_tableName;
    }

    @Override
    public TypeMetadata getTypeMetadata() {
        return this.m_typeMetadata;
    }

    @Override
    public Updatable getUpdatable() {
        return this.m_updatable;
    }

    @Override
    public boolean isAutoUnique() {
        return this.m_isAutoUnique;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    @Override
    public boolean isDefinitelyWritable() {
        return Updatable.WRITE == this.m_updatable;
    }

    @Override
    public boolean isUnnamed() {
        return null == this.m_name;
    }

    public void setAutoUnique(boolean isAutoUnique) {
        this.m_isAutoUnique = isAutoUnique;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.m_isCaseSensitive = isCaseSensitive;
    }

    public void setCatalogName(String catalogName) {
        this.m_catalogName = catalogName;
    }

    public void setColumnLength(long columnLength) throws NumericOverflowException {
        if (columnLength > 0xFFFFFFFFL || columnLength < 0L) {
            throw new NumericOverflowException();
        }
        this.m_columnLength = columnLength;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNullable(Nullable nullable) {
        this.m_nullable = nullable;
    }

    public void setSchemaName(String schemaName) {
        this.m_schemaName = schemaName;
    }

    public void setSearchable(Searchable searchable) {
        this.m_searchable = searchable;
    }

    public void setTableName(String tableName) {
        this.m_tableName = tableName;
    }

    public void setTypeMetadata(TypeMetadata typeMetadata) throws NullPointerException {
        if (null == typeMetadata) {
            throw new NullPointerException();
        }
        this.m_typeMetadata = typeMetadata;
    }

    public void setUpdatable(Updatable updatable) {
        this.m_updatable = updatable;
    }

    public String toString() {
        if (this.isUnnamed()) {
            return "ColumnMetadata: <null>";
        }
        return "ColumnMetadata: " + this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_catalogName == null ? 0 : this.m_catalogName.hashCode());
        result = 31 * result + (int)(this.m_columnLength ^ this.m_columnLength >>> 32);
        result = 31 * result + (this.m_isAutoUnique ? 1231 : 1237);
        result = 31 * result + (this.m_isCaseSensitive ? 1231 : 1237);
        result = 31 * result + (this.m_label == null ? 0 : this.m_label.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_nullable == null ? 0 : this.m_nullable.hashCode());
        result = 31 * result + (this.m_schemaName == null ? 0 : this.m_schemaName.hashCode());
        result = 31 * result + (this.m_searchable == null ? 0 : this.m_searchable.hashCode());
        result = 31 * result + (this.m_tableName == null ? 0 : this.m_tableName.hashCode());
        result = 31 * result + (this.m_typeMetadata == null ? 0 : this.m_typeMetadata.hashCode());
        result = 31 * result + (this.m_updatable == null ? 0 : this.m_updatable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata)obj;
        if (this.m_catalogName == null ? other.m_catalogName != null : !this.m_catalogName.equals(other.m_catalogName)) {
            return false;
        }
        if (this.m_columnLength != other.m_columnLength) {
            return false;
        }
        if (this.m_isAutoUnique != other.m_isAutoUnique) {
            return false;
        }
        if (this.m_isCaseSensitive != other.m_isCaseSensitive) {
            return false;
        }
        if (this.m_label == null ? other.m_label != null : !this.m_label.equals(other.m_label)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_nullable != other.m_nullable) {
            return false;
        }
        if (this.m_schemaName == null ? other.m_schemaName != null : !this.m_schemaName.equals(other.m_schemaName)) {
            return false;
        }
        if (this.m_searchable != other.m_searchable) {
            return false;
        }
        if (this.m_tableName == null ? other.m_tableName != null : !this.m_tableName.equals(other.m_tableName)) {
            return false;
        }
        if (this.m_typeMetadata == null ? other.m_typeMetadata != null : !this.m_typeMetadata.equals(other.m_typeMetadata)) {
            return false;
        }
        return this.m_updatable == other.m_updatable;
    }
}

