/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.core.VConnection;
import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.deserializer.impl.DateDeserializerImpl;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.util.ClientErrorException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class TimestampDeserializerImpl
implements MultiFormatDeserializer {
    private int m_oid;
    private static final long POSITIVE_INFINITY_MILLISECONDS = 9223372036825200000L;
    private static final long NEGATIVE_INFINITY_MILLISECONDS = -9223372036832400000L;
    private static final char[][] NUMBERS = new char[64][];

    public TimestampDeserializerImpl(int n) {
        this.m_oid = n;
    }

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        TimestampDeserializerImpl.deserializeTimestampBinary(this.m_oid, dataWrapper, byArray, hashMap);
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        if (!TimestampDeserializerImpl.deserializeInfinityTimestamp(dataWrapper, byArray)) {
            String string = new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET);
            if (string.endsWith(" BC")) {
                string = '-' + string.substring(0, string.length() - 3);
            }
            dataWrapper.setVarChar(string);
        }
        return false;
    }

    public static void deserializeTimestampBinary(int n, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws ClientErrorException {
        if (n != 12 && n != 13) {
            throw new ClientErrorException("Invalid timestamp/timestamptz OID: " + n);
        }
        long l = ByteBuffer.wrap(byArray).getLong();
        if (l == Long.MAX_VALUE) {
            Timestamp timestamp = new Timestamp(9223372036825200000L);
            timestamp.setNanos(0);
            dataWrapper.setTimestamp(new TimestampTz(timestamp, Calendar.getInstance()));
            return;
        }
        if (l == -9223372036854775807L) {
            Timestamp timestamp = new Timestamp(-9223372036832400000L);
            timestamp.setNanos(0);
            dataWrapper.setTimestamp(new TimestampTz(timestamp, Calendar.getInstance()));
            return;
        }
        long l2 = ((l += 946684800000000L) % 1000000L + 1000000L) % 1000000L;
        long l3 = DateDeserializerImpl.toJavaSecs((l - l2) / 1000000L);
        long l4 = l3 * 1000L;
        if (n == 12) {
            StringBuilder stringBuilder;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("UTC"));
            gregorianCalendar.setTimeInMillis(l4);
            int n2 = gregorianCalendar.get(0);
            int n3 = gregorianCalendar.get(1);
            int n4 = gregorianCalendar.get(2) + 1;
            int n5 = gregorianCalendar.get(5);
            int n6 = gregorianCalendar.get(11);
            int n7 = gregorianCalendar.get(12);
            int n8 = gregorianCalendar.get(13);
            StringBuilder stringBuilder2 = stringBuilder = n2 == 0 ? new StringBuilder("-") : new StringBuilder();
            if (n3 < 10) {
                stringBuilder.append("000");
            } else if (n3 < 100) {
                stringBuilder.append("00");
            } else if (n3 < 1000) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n3);
            stringBuilder.append('-');
            stringBuilder.append(NUMBERS[n4]);
            stringBuilder.append('-');
            stringBuilder.append(NUMBERS[n5]);
            stringBuilder.append(' ');
            stringBuilder.append(NUMBERS[n6]);
            stringBuilder.append(':');
            stringBuilder.append(NUMBERS[n7]);
            stringBuilder.append(':');
            stringBuilder.append(NUMBERS[n8]);
            if (l2 > 0L) {
                stringBuilder.append('.');
                if (l2 < 10L) {
                    stringBuilder.append("00000");
                } else if (l2 < 100L) {
                    stringBuilder.append("0000");
                } else if (l2 < 1000L) {
                    stringBuilder.append("000");
                } else if (l2 < 10000L) {
                    stringBuilder.append("00");
                } else if (l2 < 100000L) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(l2);
                int n9 = stringBuilder.length() - 1;
                while (stringBuilder.charAt(n9) == '0') {
                    stringBuilder.deleteCharAt(n9);
                    --n9;
                }
            }
            String string = stringBuilder.toString();
            dataWrapper.setVarChar(string);
        } else {
            Timestamp timestamp = new Timestamp(l4);
            timestamp.setNanos((int)l2 * 1000);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(hashMap.get("sessiontimezone").toString()), Locale.US);
            dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
        }
    }

    public static boolean deserializeInfinityTimestamp(DataWrapper dataWrapper, byte[] byArray) {
        if (TimestampDeserializerImpl.isInfinityTimestamp(byArray)) {
            dataWrapper.setTimestamp(TimestampDeserializerImpl.getInfinityTimestamp(byArray));
            return true;
        }
        return false;
    }

    public static boolean isInfinityTimestamp(byte[] byArray) {
        return byArray[0] == 105 || byArray[0] == 45 && byArray[1] == 105;
    }

    public static TimestampTz getInfinityTimestamp(byte[] byArray) {
        Calendar calendar = Calendar.getInstance();
        Timestamp timestamp = new Timestamp(byArray[0] == 45 ? -9223372036832400000L : 9223372036825200000L);
        timestamp.setNanos(0);
        return new TimestampTz(timestamp, calendar);
    }

    static {
        for (int i = 0; i < NUMBERS.length; ++i) {
            TimestampDeserializerImpl.NUMBERS[i] = ((i < 10 ? "0" : "") + Integer.toString(i)).toCharArray();
        }
    }
}

