/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.deserializer.Deserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.jdbc.VerticaDayTimeInterval;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class IntervalDeserializerImpl
implements Deserializer {
    private static final int ASCII_OFFSET = 48;
    private int m_sqlType;
    private int m_formatcode;
    private int m_typeMod;

    public IntervalDeserializerImpl(int n, int n2, int n3) {
        this.m_formatcode = n3;
        this.m_sqlType = n;
        this.m_typeMod = n2;
    }

    @Override
    public boolean deserialize(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        VerticaDayTimeInterval verticaDayTimeInterval = IntervalDeserializerImpl.parseInterval(this.m_sqlType, this.m_typeMod, byArray, this.m_formatcode);
        dataWrapper.setInterval(verticaDayTimeInterval);
        return false;
    }

    public static VerticaDayTimeInterval parseInterval(int n, int n2, byte[] byArray, int n3) throws ClientErrorException {
        boolean bl = false;
        int n4 = TypeUtils.getPrecision(14, n2);
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        if (n3 == 1) {
            long l = ByteBuffer.wrap(byArray).getLong();
            if (l < 0L) {
                bl = true;
                l = -l;
            }
            nArray[4] = (int)(l % 1000000L);
            nArray[3] = (int)((l /= 1000000L) % 60L);
            nArray[2] = (int)((l /= 60L) % 60L);
            nArray[1] = (int)((l /= 60L) % 24L);
            nArray[0] = (int)(l / 24L);
            if (nArray[4] > 0 && n4 > 0) {
                int n5 = 6 - n4;
                while (n5-- > 0) {
                    nArray[4] = nArray[4] / 10;
                }
            }
        } else {
            int n6 = 0;
            if (byArray[n6] == 45) {
                ++n6;
                bl = true;
            }
            int n7 = 0;
            while (n6 < byArray.length && byArray[n6] != 32 && byArray[n6] != 58 && byArray[n6] != 46) {
                n7 = n7 * 10 + (byArray[n6++] - 48);
            }
            boolean bl2 = n6 < byArray.length && byArray[n6] == 32;
            ++n6;
            int n8 = 0;
            switch (n) {
                case 103: {
                    n8 = 0;
                    break;
                }
                case 108: 
                case 109: 
                case 110: {
                    n8 = bl2 || n6 > byArray.length ? 0 : 1;
                    break;
                }
                case 104: 
                case 111: 
                case 112: {
                    n8 = 1;
                    break;
                }
                case 105: 
                case 113: {
                    n8 = 2;
                    break;
                }
                case 106: {
                    n8 = 3;
                    break;
                }
                default: {
                    throw new ClientErrorException("Unexpected SqlType: " + n);
                }
            }
            nArray[n8++] = n7;
            n7 = 0;
            int n9 = 0;
            if (n6 < byArray.length) {
                while (n6 < byArray.length) {
                    if (byArray[n6] == 58 || byArray[n6] == 46) {
                        nArray[n8++] = n7;
                        n7 = 0;
                    } else {
                        if (!Character.isDigit(byArray[n6])) {
                            throw new ClientErrorException(byArray[n6] + " should be a digit, but is not");
                        }
                        n7 = n7 * 10 + (byArray[n6] - 48);
                        if (n8 == 4 && n7 == 0) {
                            ++n9;
                        }
                    }
                    ++n6;
                }
                nArray[n8++] = n7;
                n7 = 0;
            }
            int n10 = 1;
            for (int i = 1; i < n4 - n9; ++i) {
                n10 *= 10;
            }
            while (nArray[4] > 0 && nArray[4] < n10) {
                nArray[4] = nArray[4] * 10;
            }
        }
        try {
            return new VerticaDayTimeInterval(n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], n4, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

