/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.deserializer.Deserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.VerticaArray;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class ArrayDeserializerImpl
implements Deserializer {
    private ColumnDescription m_columnDescription;

    public ArrayDeserializerImpl(ColumnDescription columnDescription) {
        this.m_columnDescription = columnDescription;
    }

    @Override
    public boolean deserialize(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException, ErrorException {
        String string = new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET);
        JsonElement jsonElement = new JsonParser().parse(string);
        if (jsonElement == null) {
            dataWrapper.setArray(null);
        }
        if (!jsonElement.isJsonArray()) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Array Expected.");
        }
        VerticaArray verticaArray = new VerticaArray(jsonElement.getAsJsonArray(), this.m_columnDescription);
        dataWrapper.setArray(verticaArray);
        return false;
    }
}

