/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CancelEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbServerMetadata;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceDbEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDbsInTargetEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SourceType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SslMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigrationEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutoverEnum;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface MigrationResource {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public String migrationId();

    public MigrationStatus currentStatus();

    public MigrationMode migrationMode();

    public MigrationOption migrationOption();

    public SourceType sourceType();

    public SslMode sslMode();

    public DbServerMetadata sourceDbServerMetadata();

    public DbServerMetadata targetDbServerMetadata();

    public String sourceDbServerResourceId();

    public String sourceDbServerFullyQualifiedDomainName();

    public String targetDbServerResourceId();

    public String targetDbServerFullyQualifiedDomainName();

    public MigrationSecretParameters secretParameters();

    public List<String> dbsToMigrate();

    public LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded();

    public OverwriteDbsInTargetEnum overwriteDbsInTarget();

    public OffsetDateTime migrationWindowStartTimeInUtc();

    public OffsetDateTime migrationWindowEndTimeInUtc();

    public StartDataMigrationEnum startDataMigration();

    public TriggerCutoverEnum triggerCutover();

    public List<String> dbsToTriggerCutoverOn();

    public CancelEnum cancel();

    public List<String> dbsToCancelMigrationOn();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public MigrationResourceInner innerModel();

    public Update update();

    public MigrationResource refresh();

    public MigrationResource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithMigrationMode {
            public Update withMigrationMode(MigrationMode var1);
        }

        public static interface WithDbsToCancelMigrationOn {
            public Update withDbsToCancelMigrationOn(List<String> var1);
        }

        public static interface WithCancel {
            public Update withCancel(CancelEnum var1);
        }

        public static interface WithDbsToTriggerCutoverOn {
            public Update withDbsToTriggerCutoverOn(List<String> var1);
        }

        public static interface WithTriggerCutover {
            public Update withTriggerCutover(TriggerCutoverEnum var1);
        }

        public static interface WithStartDataMigration {
            public Update withStartDataMigration(StartDataMigrationEnum var1);
        }

        public static interface WithMigrationWindowStartTimeInUtc {
            public Update withMigrationWindowStartTimeInUtc(OffsetDateTime var1);
        }

        public static interface WithOverwriteDbsInTarget {
            public Update withOverwriteDbsInTarget(OverwriteDbsInTargetEnum var1);
        }

        public static interface WithSetupLogicalReplicationOnSourceDbIfNeeded {
            public Update withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceDbEnum var1);
        }

        public static interface WithDbsToMigrate {
            public Update withDbsToMigrate(List<String> var1);
        }

        public static interface WithSecretParameters {
            public Update withSecretParameters(MigrationSecretParameters var1);
        }

        public static interface WithTargetDbServerFullyQualifiedDomainName {
            public Update withTargetDbServerFullyQualifiedDomainName(String var1);
        }

        public static interface WithSourceDbServerFullyQualifiedDomainName {
            public Update withSourceDbServerFullyQualifiedDomainName(String var1);
        }

        public static interface WithSourceDbServerResourceId {
            public Update withSourceDbServerResourceId(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSourceDbServerResourceId,
    UpdateStages.WithSourceDbServerFullyQualifiedDomainName,
    UpdateStages.WithTargetDbServerFullyQualifiedDomainName,
    UpdateStages.WithSecretParameters,
    UpdateStages.WithDbsToMigrate,
    UpdateStages.WithSetupLogicalReplicationOnSourceDbIfNeeded,
    UpdateStages.WithOverwriteDbsInTarget,
    UpdateStages.WithMigrationWindowStartTimeInUtc,
    UpdateStages.WithStartDataMigration,
    UpdateStages.WithTriggerCutover,
    UpdateStages.WithDbsToTriggerCutoverOn,
    UpdateStages.WithCancel,
    UpdateStages.WithDbsToCancelMigrationOn,
    UpdateStages.WithMigrationMode {
        public MigrationResource apply();

        public MigrationResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDbsToCancelMigrationOn {
            public WithCreate withDbsToCancelMigrationOn(List<String> var1);
        }

        public static interface WithCancel {
            public WithCreate withCancel(CancelEnum var1);
        }

        public static interface WithDbsToTriggerCutoverOn {
            public WithCreate withDbsToTriggerCutoverOn(List<String> var1);
        }

        public static interface WithTriggerCutover {
            public WithCreate withTriggerCutover(TriggerCutoverEnum var1);
        }

        public static interface WithStartDataMigration {
            public WithCreate withStartDataMigration(StartDataMigrationEnum var1);
        }

        public static interface WithMigrationWindowEndTimeInUtc {
            public WithCreate withMigrationWindowEndTimeInUtc(OffsetDateTime var1);
        }

        public static interface WithMigrationWindowStartTimeInUtc {
            public WithCreate withMigrationWindowStartTimeInUtc(OffsetDateTime var1);
        }

        public static interface WithOverwriteDbsInTarget {
            public WithCreate withOverwriteDbsInTarget(OverwriteDbsInTargetEnum var1);
        }

        public static interface WithSetupLogicalReplicationOnSourceDbIfNeeded {
            public WithCreate withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceDbEnum var1);
        }

        public static interface WithDbsToMigrate {
            public WithCreate withDbsToMigrate(List<String> var1);
        }

        public static interface WithSecretParameters {
            public WithCreate withSecretParameters(MigrationSecretParameters var1);
        }

        public static interface WithTargetDbServerFullyQualifiedDomainName {
            public WithCreate withTargetDbServerFullyQualifiedDomainName(String var1);
        }

        public static interface WithSourceDbServerFullyQualifiedDomainName {
            public WithCreate withSourceDbServerFullyQualifiedDomainName(String var1);
        }

        public static interface WithSourceDbServerResourceId {
            public WithCreate withSourceDbServerResourceId(String var1);
        }

        public static interface WithSslMode {
            public WithCreate withSslMode(SslMode var1);
        }

        public static interface WithSourceType {
            public WithCreate withSourceType(SourceType var1);
        }

        public static interface WithMigrationOption {
            public WithCreate withMigrationOption(MigrationOption var1);
        }

        public static interface WithMigrationMode {
            public WithCreate withMigrationMode(MigrationMode var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithMigrationMode,
        WithMigrationOption,
        WithSourceType,
        WithSslMode,
        WithSourceDbServerResourceId,
        WithSourceDbServerFullyQualifiedDomainName,
        WithTargetDbServerFullyQualifiedDomainName,
        WithSecretParameters,
        WithDbsToMigrate,
        WithSetupLogicalReplicationOnSourceDbIfNeeded,
        WithOverwriteDbsInTarget,
        WithMigrationWindowStartTimeInUtc,
        WithMigrationWindowEndTimeInUtc,
        WithStartDataMigration,
        WithTriggerCutover,
        WithDbsToTriggerCutoverOn,
        WithCancel,
        WithDbsToCancelMigrationOn {
            public MigrationResource create();

            public MigrationResource create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingFlexibleServer(String var1, String var2, String var3);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

