/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerCapabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.FlexibleServerCapabilityInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.FlexibleServerCapabilityImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FlexibleServerCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerCapabilities;

public final class ServerCapabilitiesImpl
implements ServerCapabilities {
    private static final ClientLogger LOGGER = new ClientLogger(ServerCapabilitiesImpl.class);
    private final ServerCapabilitiesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ServerCapabilitiesImpl(ServerCapabilitiesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<FlexibleServerCapability> list(String resourceGroupName, String serverName) {
        PagedIterable<FlexibleServerCapabilityInner> inner = this.serviceClient().list(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FlexibleServerCapabilityImpl((FlexibleServerCapabilityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<FlexibleServerCapability> list(String resourceGroupName, String serverName, Context context) {
        PagedIterable<FlexibleServerCapabilityInner> inner = this.serviceClient().list(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FlexibleServerCapabilityImpl((FlexibleServerCapabilityInner)inner1, this.manager()));
    }

    private ServerCapabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

