/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdministratorsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.BackupsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CheckNameAvailabilityWithLocationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ConfigurationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.DatabasesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.FirewallRulesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.FlexibleServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.GetPrivateDnsZoneSuffixesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LocationBasedCapabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LogFilesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LtrBackupOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.OperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PostgreSqlManagementClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.QuotaUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ReplicasClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerCapabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualEndpointsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualNetworkSubnetUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdministratorsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CheckNameAvailabilitiesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CheckNameAvailabilityWithLocationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ConfigurationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.DatabasesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.FirewallRulesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.FlexibleServersClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.GetPrivateDnsZoneSuffixesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.LocationBasedCapabilitiesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.LogFilesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.LtrBackupOperationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.OperationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientBuilder;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateEndpointConnectionOperationsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.QuotaUsagesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ReplicasClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServerCapabilitiesClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServerThreatProtectionSettingsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServersClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualEndpointsClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualNetworkSubnetUsagesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PostgreSqlManagementClientBuilder.class)
public final class PostgreSqlManagementClientImpl
implements PostgreSqlManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AdministratorsClient administrators;
    private final BackupsClient backups;
    private final LocationBasedCapabilitiesClient locationBasedCapabilities;
    private final ServerCapabilitiesClient serverCapabilities;
    private final CheckNameAvailabilitiesClient checkNameAvailabilities;
    private final CheckNameAvailabilityWithLocationsClient checkNameAvailabilityWithLocations;
    private final ConfigurationsClient configurations;
    private final DatabasesClient databases;
    private final FirewallRulesClient firewallRules;
    private final ServersClient servers;
    private final FlexibleServersClient flexibleServers;
    private final LtrBackupOperationsClient ltrBackupOperations;
    private final MigrationsClient migrations;
    private final ResourceProvidersClient resourceProviders;
    private final OperationsClient operations;
    private final GetPrivateDnsZoneSuffixesClient getPrivateDnsZoneSuffixes;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateEndpointConnectionOperationsClient privateEndpointConnectionOperations;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final QuotaUsagesClient quotaUsages;
    private final ReplicasClient replicas;
    private final LogFilesClient logFiles;
    private final ServerThreatProtectionSettingsClient serverThreatProtectionSettings;
    private final VirtualEndpointsClient virtualEndpoints;
    private final VirtualNetworkSubnetUsagesClient virtualNetworkSubnetUsages;
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AdministratorsClient getAdministrators() {
        return this.administrators;
    }

    @Override
    public BackupsClient getBackups() {
        return this.backups;
    }

    @Override
    public LocationBasedCapabilitiesClient getLocationBasedCapabilities() {
        return this.locationBasedCapabilities;
    }

    @Override
    public ServerCapabilitiesClient getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public CheckNameAvailabilitiesClient getCheckNameAvailabilities() {
        return this.checkNameAvailabilities;
    }

    @Override
    public CheckNameAvailabilityWithLocationsClient getCheckNameAvailabilityWithLocations() {
        return this.checkNameAvailabilityWithLocations;
    }

    @Override
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    @Override
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    @Override
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    @Override
    public ServersClient getServers() {
        return this.servers;
    }

    @Override
    public FlexibleServersClient getFlexibleServers() {
        return this.flexibleServers;
    }

    @Override
    public LtrBackupOperationsClient getLtrBackupOperations() {
        return this.ltrBackupOperations;
    }

    @Override
    public MigrationsClient getMigrations() {
        return this.migrations;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public GetPrivateDnsZoneSuffixesClient getGetPrivateDnsZoneSuffixes() {
        return this.getPrivateDnsZoneSuffixes;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateEndpointConnectionOperationsClient getPrivateEndpointConnectionOperations() {
        return this.privateEndpointConnectionOperations;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public QuotaUsagesClient getQuotaUsages() {
        return this.quotaUsages;
    }

    @Override
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    @Override
    public LogFilesClient getLogFiles() {
        return this.logFiles;
    }

    @Override
    public ServerThreatProtectionSettingsClient getServerThreatProtectionSettings() {
        return this.serverThreatProtectionSettings;
    }

    @Override
    public VirtualEndpointsClient getVirtualEndpoints() {
        return this.virtualEndpoints;
    }

    @Override
    public VirtualNetworkSubnetUsagesClient getVirtualNetworkSubnetUsages() {
        return this.virtualNetworkSubnetUsages;
    }

    PostgreSqlManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2023-06-01-preview";
        this.administrators = new AdministratorsClientImpl(this);
        this.backups = new BackupsClientImpl(this);
        this.locationBasedCapabilities = new LocationBasedCapabilitiesClientImpl(this);
        this.serverCapabilities = new ServerCapabilitiesClientImpl(this);
        this.checkNameAvailabilities = new CheckNameAvailabilitiesClientImpl(this);
        this.checkNameAvailabilityWithLocations = new CheckNameAvailabilityWithLocationsClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.servers = new ServersClientImpl(this);
        this.flexibleServers = new FlexibleServersClientImpl(this);
        this.ltrBackupOperations = new LtrBackupOperationsClientImpl(this);
        this.migrations = new MigrationsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.getPrivateDnsZoneSuffixes = new GetPrivateDnsZoneSuffixesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateEndpointConnectionOperations = new PrivateEndpointConnectionOperationsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.quotaUsages = new QuotaUsagesClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.logFiles = new LogFilesClientImpl(this);
        this.serverThreatProtectionSettings = new ServerThreatProtectionSettingsClientImpl(this);
        this.virtualEndpoints = new VirtualEndpointsClientImpl(this);
        this.virtualNetworkSubnetUsages = new VirtualNetworkSubnetUsagesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

