/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.ui.license.internal.LMUIActivator;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class LicenseRenewsDialog
extends IconAndMessageDialog {
    private String title;
    private String productVersionId;
    private LMLicense license;
    private Button suppressCheckbox;

    public LicenseRenewsDialog(Shell parentShell, String title, String message, String productVersionId, LMLicense license) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.productVersionId = productVersionId;
        this.license = license;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite msgPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
        super.createMessageArea(msgPlaceholder);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.suppressCheckbox = UIUtils.createCheckbox((Composite)parent, (String)"Do not show again", (String)"Do not show this popup again", (boolean)false, (int)1);
        this.suppressCheckbox.setLayoutData((Object)new GridData(32));
        this.createButton(parent, 13, "Renew the license", true);
        this.createButton(parent, 1, "No, thank you", false);
    }

    protected Image getImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 13: {
                UIUtils.openWebBrowser((String)"https://dbeaver.com/buy");
                super.buttonPressed(0);
            }
        }
        LMUIActivator.getDefault().getPreferenceStore().setValue("suppressRenewAlert." + this.productVersionId, this.suppressCheckbox.getSelection());
        super.buttonPressed(buttonId);
    }

    public static boolean isSuppressedFor(String productVersion) {
        return LMUIActivator.getDefault().getPreferenceStore().getBoolean("suppressRenewAlert." + productVersion);
    }
}

