/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.ui.license.LicenseImportDialog;
import com.dbeaver.ui.license.LicenseInfoDialog;
import com.dbeaver.ui.license.LicenseManagementDialog;
import com.dbeaver.ui.license.LicenseMissingDialog;
import com.dbeaver.ui.license.LicenseRenewsDialog;
import com.dbeaver.ui.license.LicenseTrialDialog;
import com.dbeaver.ui.license.internal.LMUIMessages;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LicenseManagerUIUtils {
    private static final boolean SHOW_SUBSCRIPTION_EXPIRE_LICENSE = false;
    private static final Set<Long> STANDARD_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(30L), Long.valueOf(14L), Long.valueOf(5L), Long.valueOf(4L), Long.valueOf(3L), Long.valueOf(2L), Long.valueOf(1L), Long.valueOf(0L));
    private static final Set<Long> LIMITED_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(14L), Long.valueOf(7L), Long.valueOf(1L), Long.valueOf(0L));
    private static final Set<Long> SUBSCRIPTION_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(1L), Long.valueOf(0L));
    private static final Set<Long> SUPPORT_END_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(14L), Long.valueOf(7L), Long.valueOf(1L), Long.valueOf(0L));
    private static LMLicense lastValidLicense;

    public static LMLicense checkLicense(DBRProgressMonitor monitor, Shell shell) {
        LMLicense currentLicense;
        boolean showDialog = false;
        while (true) {
            Throwable validationError = null;
            try {
                currentLicense = DBPApplicationLicensed.getLicensedApplication().getLicenseService().getActiveProductLicense(true);
                if (currentLicense != null) break;
                if (DBWorkbench.isDistributed()) {
                    DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_license_info_title, "No valid distributed license was found.\nApplication will be terminated.\nPlease ask your system administrator.");
                    return null;
                }
            }
            catch (Throwable e) {
                validationError = e;
            }
            if (LMLicenseManager.getLicenseCustomPath() != null) {
                DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_license_info_title, "No valid license found in " + String.valueOf(LMLicenseManager.getLicenseCustomPath().toAbsolutePath()));
                return null;
            }
            boolean[] result = new boolean[1];
            Throwable finalValidationError = validationError;
            UIUtils.syncExec(() -> {
                blArray[0] = LicenseManagerUIUtils.importMissingLicenseInUI(shell, finalValidationError);
            });
            if (!result[0]) {
                return null;
            }
            showDialog = true;
        }
        if (showDialog) {
            UIUtils.syncExec(LicenseManagerUIUtils::showLicenseInfoDialog);
        }
        LMLicense finalCurrentLicense = currentLicense;
        UIUtils.syncExec(() -> LicenseManagerUIUtils.showLicenseExpireNotify(finalCurrentLicense));
        lastValidLicense = currentLicense;
        return currentLicense;
    }

    public static LMLicense getLastValidLicense() {
        return lastValidLicense;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean importMissingLicenseInUI(Shell shell, Throwable validationError) {
        LicenseMissingDialog dialog = new LicenseMissingDialog(shell, validationError);
        int choice = dialog.open();
        try {
            switch (choice) {
                case 1: {
                    return false;
                }
                case 1000: {
                    if (!LicenseManagerUIUtils.importLicense(shell)) return true;
                    UIUtils.showMessageBox((Shell)shell, (String)LMUIMessages.DBeaverEnterpriseUI_license_accepted_title, (String)LMUIMessages.DBeaverEnterpriseUI_license_accepted_message, (int)2);
                    return true;
                }
                case 1001: {
                    if (!LicenseManagerUIUtils.createTrialLicense(shell)) return true;
                    UIUtils.showMessageBox((Shell)shell, (String)LMUIMessages.DBeaverEnterpriseUI_trial_requested_title, (String)LMUIMessages.DBeaverEnterpriseUI_trial_requested_message, (int)2);
                    return true;
                }
                case 1002: {
                    LicenseManagementDialog lmDialog = new LicenseManagementDialog(shell);
                    lmDialog.open();
                }
            }
            return true;
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_e_lm_internal_title, LMUIMessages.DBeaverEnterpriseUI_e_lm_internal_message, e);
        }
        return true;
    }

    private static boolean createTrialLicense(Shell shell) {
        LicenseTrialDialog trialDialog = new LicenseTrialDialog(shell);
        int choice = trialDialog.open();
        return choice == 0;
    }

    private static boolean importLicense(Shell shell) {
        LicenseImportDialog importDialog = new LicenseImportDialog(shell);
        int choice = importDialog.open();
        return choice == 0;
    }

    public static void showLicenseInfoDialog() {
        try {
            LicenseInfoDialog dialog = new LicenseInfoDialog(UIUtils.getActiveWorkbenchShell());
            dialog.open();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_license_info_title, LMUIMessages.DBeaverEnterpriseUI_license_info_message, (Throwable)e);
        }
    }

    private static void showLicenseExpireNotify(LMLicense license) {
        String productVersionId = LMAppUtils.getActiveProduct().getId() + "-" + GeneralUtils.getMajorVersion();
        if (LicenseRenewsDialog.isSuppressedFor(productVersionId)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        boolean renewChosen = false;
        if (license.getLicenseEndTime() != null) {
            LocalDateTime licenseEndTime = license.getLicenseEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (licenseEndTime.isBefore(now)) {
                return;
            }
            long daysBeforeEnd = Math.abs(ChronoUnit.DAYS.between(licenseEndTime, now));
            if (!license.isSubscription()) {
                boolean validDay;
                boolean bl = validDay = license.getLicenseType() == LMLicenseType.STANDARD ? STANDARD_LICENSE_RENEWAL_DAYS.contains(daysBeforeEnd) : LIMITED_LICENSE_RENEWAL_DAYS.contains(daysBeforeEnd);
                if (validDay) {
                    LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), LMUIMessages.dialog_renew_license_extend_license_title, NLS.bind((String)LMUIMessages.dialog_renew_license_license_expiration_message, (Object)licenseEndTime.toLocalDate()), productVersionId, license);
                    renewChosen = renewDialog.open() == 0;
                }
            }
        } else {
            long daysAfterEnd;
            LocalDateTime supportEndTime = license.getSupportEndDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (supportEndTime.isBefore(now) && SUPPORT_END_LICENSE_RENEWAL_DAYS.contains(daysAfterEnd = Math.abs(ChronoUnit.DAYS.between(supportEndTime, now)))) {
                LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), LMUIMessages.dialog_renew_license_extend_license_title, NLS.bind((String)LMUIMessages.dialog_renew_license_license_end_of_support_message, (Object)supportEndTime.toLocalDate()), productVersionId, license);
                boolean bl = renewChosen = renewDialog.open() == 0;
            }
        }
        if (renewChosen) {
            LicenseManagementDialog lmDialog = new LicenseManagementDialog(UIUtils.getActiveWorkbenchShell());
            lmDialog.open();
        }
    }
}

