/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.cosmos.models.KeyWrapMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ClientEncryptionKeyResource {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="encryptionAlgorithm")
    private String encryptionAlgorithm;
    @JsonProperty(value="wrappedDataEncryptionKey")
    private byte[] wrappedDataEncryptionKey;
    @JsonProperty(value="keyWrapMetadata")
    private KeyWrapMetadata keyWrapMetadata;

    public String id() {
        return this.id;
    }

    public ClientEncryptionKeyResource withId(String id) {
        this.id = id;
        return this;
    }

    public String encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public ClientEncryptionKeyResource withEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public byte[] wrappedDataEncryptionKey() {
        return CoreUtils.clone((byte[])this.wrappedDataEncryptionKey);
    }

    public ClientEncryptionKeyResource withWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        this.wrappedDataEncryptionKey = CoreUtils.clone((byte[])wrappedDataEncryptionKey);
        return this;
    }

    public KeyWrapMetadata keyWrapMetadata() {
        return this.keyWrapMetadata;
    }

    public ClientEncryptionKeyResource withKeyWrapMetadata(KeyWrapMetadata keyWrapMetadata) {
        this.keyWrapMetadata = keyWrapMetadata;
        return this;
    }

    public void validate() {
        if (this.keyWrapMetadata() != null) {
            this.keyWrapMetadata().validate();
        }
    }
}

