/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling.engine;

import com.dbeaver.ui.editors.spelling.engine.ISpellCheckIterator;
import com.dbeaver.ui.editors.spelling.engine.ISpellChecker;
import com.dbeaver.ui.editors.spelling.engine.ISpellDictionary;
import com.dbeaver.ui.editors.spelling.engine.ISpellEventListener;
import com.dbeaver.ui.editors.spelling.engine.RankedWordProposal;
import com.dbeaver.ui.editors.spelling.engine.SpellEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLSpellingContext;

public class DefaultSpellChecker
implements ISpellChecker {
    public static final String[] URL_PREFIXES = new String[]{"http://", "https://", "www.", "ftp://", "ftps://", "news://", "mailto://"};
    public static final int SHORT_WORD_MAX_LENGTH = 3;
    private final Set<ISpellDictionary> fDictionaries = Collections.synchronizedSet(new HashSet());
    private final Set<String> ignoredWords = Collections.synchronizedSet(new HashSet());
    private final DBPPreferenceStore fPreferences;
    private final Locale fLocale;

    protected static boolean isDigits(String word) {
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isDigit(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isMixedCase(String word, boolean sentence) {
        int length = word.length();
        boolean upper = Character.isUpperCase(word.charAt(0));
        if (sentence && upper && length > 1) {
            upper = Character.isUpperCase(word.charAt(1));
        }
        if (upper) {
            int index = length - 1;
            while (index > 0) {
                if (Character.isLowerCase(word.charAt(index))) {
                    return true;
                }
                --index;
            }
        } else {
            int index = length - 1;
            while (index > 0) {
                if (Character.isUpperCase(word.charAt(index))) {
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    protected static boolean isUpperCase(String word) {
        int index = word.length() - 1;
        while (index >= 0) {
            if (Character.isLowerCase(word.charAt(index))) {
                return false;
            }
            --index;
        }
        return true;
    }

    protected static boolean isUrl(String word) {
        String[] stringArray = URL_PREFIXES;
        int n = URL_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String urlprefix = stringArray[n2];
            if (word.startsWith(urlprefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public DefaultSpellChecker(DBPPreferenceStore store, Locale locale) {
        Assert.isLegal((store != null ? 1 : 0) != 0);
        Assert.isLegal((locale != null ? 1 : 0) != 0);
        this.fPreferences = store;
        this.fLocale = locale;
    }

    @Override
    public final void addDictionary(ISpellDictionary dictionary) {
        this.fDictionaries.add(dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptsWords() {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        for (ISpellDictionary dictionary : copy) {
            if (!dictionary.acceptsWords()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWord(String word) {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        String addable = word.toLowerCase();
        for (ISpellDictionary dictionary : copy) {
            if (!dictionary.acceptsWords()) continue;
            dictionary.addWord(addable);
        }
    }

    @Override
    public final void checkWord(String word) {
        this.ignoredWords.remove(word.toLowerCase());
    }

    @Override
    public void execute(SpellingContext context, ISpellEventListener listener, ISpellCheckIterator iterator) {
        boolean ignoreDigits = this.fPreferences.getBoolean("spelling_ignore_digits");
        boolean ignoreMixed = this.fPreferences.getBoolean("spelling_ignore_mixed");
        boolean ignoreSentence = this.fPreferences.getBoolean("spelling_ignore_sentence");
        boolean ignoreURLS = this.fPreferences.getBoolean("spelling_ignore_urls");
        boolean ignoreSingleLetters = this.fPreferences.getBoolean("spelling_ignore_single_letters");
        int problemsThreshold = this.fPreferences.getInt("spelling_problems_threshold");
        iterator.setIgnoreSingleLetters(ignoreSingleLetters);
        iterator.setIgnoreURLs(ignoreURLS);
        SQLDialect sqlDialect = null;
        if (context instanceof SQLSpellingContext) {
            sqlDialect = ((SQLSpellingContext)context).getEditor().getSQLDialect();
        }
        int problemCount = 0;
        while (problemCount <= problemsThreshold && iterator.hasNext()) {
            String word = (String)iterator.next();
            if (word == null || ignoreSingleLetters && word.length() <= 3 || sqlDialect != null && sqlDialect.getKeywordType(word) != null || this.ignoredWords.contains(word)) continue;
            boolean starts = iterator.startsSentence();
            if (!this.isCorrect(word)) {
                if (!(ignoreMixed || !ignoreURLS && DefaultSpellChecker.isUrl(word))) {
                    String[] subWords = DefaultSpellChecker.splitByCharacterType(word, true);
                    int subWordOffset = 0;
                    String[] stringArray = subWords;
                    int n = subWords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String subWord = stringArray[n2];
                        if (!(subWord.length() <= 1 || this.ignoredWords.contains(subWord) || this.isCorrect(subWord) || DefaultSpellChecker.isDigits(subWord))) {
                            listener.handle(new SpellEvent(this, word, iterator.getBegin() + subWordOffset, iterator.getEnd(), starts, false));
                            ++problemCount;
                        }
                        subWordOffset += subWord.length();
                        ++n2;
                    }
                    continue;
                }
                boolean isMixed = DefaultSpellChecker.isMixedCase(word, true);
                boolean isUpper = DefaultSpellChecker.isUpperCase(word);
                boolean isDigits = DefaultSpellChecker.isDigits(word);
                boolean isURL = DefaultSpellChecker.isUrl(word);
                if (!(!ignoreDigits && isDigits || !ignoreURLS && isURL) && (isMixed || isUpper || isDigits || isURL)) continue;
                listener.handle(new SpellEvent(this, word, iterator.getBegin(), iterator.getEnd(), starts, false));
                ++problemCount;
                continue;
            }
            if (ignoreSentence || !starts || !Character.isLowerCase(word.charAt(0))) continue;
            listener.handle(new SpellEvent(this, word, iterator.getBegin(), iterator.getEnd(), true, true));
            ++problemCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RankedWordProposal> getProposals(String word, boolean sentence) {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        HashSet<RankedWordProposal> proposals = new HashSet<RankedWordProposal>();
        for (ISpellDictionary dictionary : copy) {
            proposals.addAll(dictionary.getProposals(word, sentence));
        }
        return proposals;
    }

    @Override
    public final void ignoreWord(String word) {
        this.ignoredWords.add(word.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isCorrect(String word) {
        HashSet<ISpellDictionary> copy;
        Set<ISpellDictionary> set = this.fDictionaries;
        synchronized (set) {
            copy = new HashSet<ISpellDictionary>(this.fDictionaries);
        }
        if (this.ignoredWords.contains(word.toLowerCase())) {
            return true;
        }
        for (ISpellDictionary dictionary : copy) {
            if (!dictionary.isCorrect(word)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void removeDictionary(ISpellDictionary dictionary) {
        this.fDictionaries.remove(dictionary);
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    private static String[] splitByCharacterType(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new String[0];
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        int pos = tokenStart + 1;
        while (pos < c.length) {
            int type = Character.getType(c[pos]);
            if (type != currentType) {
                if (camelCase && type == 2 && currentType == 1) {
                    int newTokenStart = pos - 1;
                    if (newTokenStart != tokenStart) {
                        list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                        tokenStart = newTokenStart;
                    }
                } else {
                    list.add(new String(c, tokenStart, pos - tokenStart));
                    tokenStart = pos;
                }
                currentType = type;
            }
            ++pos;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[0]);
    }
}

