/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling.engine;

import com.dbeaver.ui.editors.spelling.engine.DefaultPhoneticDistanceAlgorithm;
import com.dbeaver.ui.editors.spelling.engine.DefaultPhoneticHashProvider;
import com.dbeaver.ui.editors.spelling.engine.IPhoneticDistanceAlgorithm;
import com.dbeaver.ui.editors.spelling.engine.IPhoneticHashProvider;
import com.dbeaver.ui.editors.spelling.engine.ISpellDictionary;
import com.dbeaver.ui.editors.spelling.engine.RankedWordProposal;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.dbeaver.Log;

public abstract class AbstractSpellDictionary
implements ISpellDictionary {
    private static final Log log = Log.getLog(AbstractSpellDictionary.class);
    private static final String UTF_8 = "UTF-8";
    protected static final int BUCKET_CAPACITY = 4;
    protected static final int BUFFER_CAPACITY = 32;
    protected static final int DISTANCE_THRESHOLD = 160;
    protected static final float LOAD_FACTOR = 0.85f;
    private IPhoneticDistanceAlgorithm fDistanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    private final Map<ByteArrayWrapper, Object> fHashBuckets = new HashMap<ByteArrayWrapper, Object>(this.getInitialSize(), 0.85f);
    private IPhoneticHashProvider fHashProvider = new DefaultPhoneticHashProvider();
    private boolean fLoaded = false;
    private boolean fMustLoad = true;

    protected int getInitialSize() {
        return 32;
    }

    protected final Object getCandidates(String hash) {
        ByteArrayWrapper hashBytes;
        try {
            hashBytes = new ByteArrayWrapper(hash.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return null;
        }
        return this.fHashBuckets.get(hashBytes);
    }

    protected final Set<RankedWordProposal> getCandidates(String word, boolean sentence, ArrayList<String> hashs) {
        int distance = 0;
        String hash = null;
        StringBuilder buffer = new StringBuilder(32);
        HashSet<RankedWordProposal> result = new HashSet<RankedWordProposal>(4 * hashs.size());
        for (String hash2 : hashs) {
            hash = hash2;
            Object candidates = this.getCandidates(hash);
            if (candidates == null) continue;
            if (candidates instanceof byte[]) {
                String candidate;
                try {
                    candidate = new String((byte[])candidates, UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e);
                    return result;
                }
                distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                if (distance >= 160) continue;
                buffer.setLength(0);
                buffer.append(candidate);
                if (sentence) {
                    buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                }
                result.add(new RankedWordProposal(buffer.toString(), -distance));
                continue;
            }
            ArrayList candidateList = (ArrayList)candidates;
            int candidateSize = Math.min(500, candidateList.size());
            int offset = 0;
            while (offset < candidateSize) {
                String candidate;
                try {
                    candidate = new String((byte[])candidateList.get(offset), UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e);
                    return result;
                }
                distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                if (distance < 160) {
                    buffer.setLength(0);
                    buffer.append(candidate);
                    if (sentence) {
                        buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                    }
                    result.add(new RankedWordProposal(buffer.toString(), -distance));
                }
                ++offset;
            }
        }
        return result;
    }

    protected final void getCandidates(String word, boolean sentence, Set<RankedWordProposal> result) {
        int distance = 0;
        int minimum = Integer.MAX_VALUE;
        StringBuilder buffer = new StringBuilder(32);
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return;
        }
        if (candidates instanceof byte[]) {
            String candidate;
            try {
                candidate = new String((byte[])candidates, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
                return;
            }
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            buffer.append(candidate);
            if (sentence) {
                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
            }
            result.add(new RankedWordProposal(buffer.toString(), -distance));
            return;
        }
        ArrayList candidateList = (ArrayList)candidates;
        ArrayList<RankedWordProposal> matches = new ArrayList<RankedWordProposal>(candidateList.size());
        for (byte[] element : candidateList) {
            String candidate;
            try {
                candidate = new String(element, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
                return;
            }
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            if (distance > minimum) continue;
            if (distance < minimum) {
                matches.clear();
            }
            buffer.setLength(0);
            buffer.append(candidate);
            if (sentence) {
                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
            }
            matches.add(new RankedWordProposal(buffer.toString(), -distance));
            minimum = distance;
        }
        result.addAll(matches);
    }

    protected boolean isEmpty() {
        return this.fHashBuckets.isEmpty();
    }

    protected final IPhoneticDistanceAlgorithm getDistanceAlgorithm() {
        return this.fDistanceAlgorithm;
    }

    protected final IPhoneticHashProvider getHashProvider() {
        return this.fHashProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RankedWordProposal> getProposals(String word, boolean sentence) {
        block13: {
            try {
                if (this.fLoaded) break block13;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        String hash = this.fHashProvider.getHash(word);
        char[] mutators = this.fHashProvider.getMutators();
        ArrayList<String> neighborhood = new ArrayList<String>((word.length() + 1) * (mutators.length + 2));
        neighborhood.add(hash);
        Set<RankedWordProposal> candidates = this.getCandidates(word, sentence, neighborhood);
        neighborhood.clear();
        char previous = '\u0000';
        char next = '\u0000';
        char[] characters = word.toCharArray();
        int index = 0;
        while (index < word.length() - 1) {
            next = characters[index];
            characters[index] = previous = characters[index + 1];
            characters[index + 1] = next;
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            characters[index] = next;
            characters[index + 1] = previous;
            ++index;
        }
        String sentinel = word + " ";
        characters = sentinel.toCharArray();
        int offset = characters.length - 1;
        while (true) {
            char[] cArray = mutators;
            int n = mutators.length;
            int n2 = 0;
            while (n2 < n) {
                char mutator;
                characters[offset] = mutator = cArray[n2];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++n2;
            }
            if (offset == 0) break;
            characters[offset] = characters[offset - 1];
            --offset;
        }
        char mutated = '\u0000';
        characters = word.toCharArray();
        int index2 = 0;
        while (index2 < word.length()) {
            mutated = characters[index2];
            char[] cArray = mutators;
            int n = mutators.length;
            int n3 = 0;
            while (n3 < n) {
                char mutator2;
                characters[index2] = mutator2 = cArray[n3];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++n3;
            }
            characters[index2] = mutated;
            ++index2;
        }
        characters = word.toCharArray();
        char[] deleted = new char[characters.length - 1];
        System.arraycopy(characters, 0, deleted, 0, deleted.length);
        next = characters[characters.length - 1];
        offset = deleted.length;
        while (true) {
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            if (offset == 0) break;
            previous = next;
            next = deleted[offset - 1];
            deleted[offset - 1] = previous;
            --offset;
        }
        neighborhood.remove(hash);
        Set<RankedWordProposal> matches = this.getCandidates(word, sentence, neighborhood);
        if (matches.isEmpty() && candidates.isEmpty()) {
            this.getCandidates(word, sentence, candidates);
        }
        candidates.addAll(matches);
        return candidates;
    }

    protected abstract URL getURL() throws MalformedURLException;

    protected final void hashWord(String word) {
        byte[] wordBytes;
        ByteArrayWrapper hashBytes;
        String hash = this.fHashProvider.getHash(word);
        try {
            hashBytes = new ByteArrayWrapper(hash.getBytes(UTF_8));
            wordBytes = word.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return;
        }
        Object bucket = this.fHashBuckets.get(hashBytes);
        if (bucket == null) {
            this.fHashBuckets.put(hashBytes, wordBytes);
        } else if (bucket instanceof ArrayList) {
            ArrayList bucketList = (ArrayList)bucket;
            bucketList.add(wordBytes);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(bucket);
            list.add(wordBytes);
            this.fHashBuckets.put(hashBytes, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrect(String word) {
        byte[] lowercaseWordBytes;
        byte[] wordBytes;
        block13: {
            word = this.stripNonLetters(word);
            try {
                if (this.fLoaded) break block13;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return false;
        }
        if (candidates instanceof byte[]) {
            String candidate;
            try {
                candidate = new String((byte[])candidates, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
                return false;
            }
            return candidate.equals(word) || candidate.equals(word.toLowerCase());
        }
        ArrayList candidateList = (ArrayList)candidates;
        try {
            wordBytes = word.getBytes(UTF_8);
            lowercaseWordBytes = word.toLowerCase().getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return false;
        }
        for (byte[] candidate : candidateList) {
            if (!Arrays.equals(candidate, wordBytes) && !Arrays.equals(candidate, lowercaseWordBytes)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected String stripNonLetters(String word) {
        i = 0;
        j = word.length() - 1;
        while (i <= j && !Character.isLetter(word.charAt(i))) {
            ++i;
        }
        if (i <= j) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            --j;
lbl9:
            // 2 sources

            ** while (j > i && !Character.isLetter((char)word.charAt((int)j)))
        }
lbl10:
        // 1 sources

        return word.substring(i, j + 1);
    }

    @Override
    public final synchronized boolean isLoaded() {
        return this.fLoaded || this.fHashBuckets.size() > 0;
    }

    /*
     * Exception decompiling
     */
    protected synchronized boolean load(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void compact() {
        for (Object element : this.fHashBuckets.values()) {
            if (!(element instanceof ArrayList)) continue;
            ((ArrayList)element).trimToSize();
        }
    }

    protected final void setDistanceAlgorithm(IPhoneticDistanceAlgorithm algorithm) {
        this.fDistanceAlgorithm = algorithm;
    }

    protected final void setHashProvider(IPhoneticHashProvider provider) {
        this.fHashProvider = provider;
    }

    @Override
    public synchronized void unload() {
        this.fLoaded = false;
        this.fMustLoad = true;
        this.fHashBuckets.clear();
    }

    @Override
    public boolean acceptsWords() {
        return false;
    }

    @Override
    public void addWord(String word) {
    }

    private static class ByteArrayWrapper {
        private byte[] byteArray;

        public ByteArrayWrapper(byte[] byteArray) {
            this.byteArray = byteArray;
        }

        public int hashCode() {
            return 31 + Arrays.hashCode(this.byteArray);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ByteArrayWrapper)) {
                return false;
            }
            ByteArrayWrapper other = (ByteArrayWrapper)obj;
            return Arrays.equals(this.byteArray, other.byteArray);
        }
    }
}

