/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.spelling.HtmlTagDictionary;
import com.dbeaver.ui.editors.spelling.engine.DefaultSpellChecker;
import com.dbeaver.ui.editors.spelling.engine.ISpellCheckEngine;
import com.dbeaver.ui.editors.spelling.engine.ISpellChecker;
import com.dbeaver.ui.editors.spelling.engine.ISpellDictionary;
import com.dbeaver.ui.editors.spelling.engine.LocaleSensitiveSpellDictionary;
import com.dbeaver.ui.editors.spelling.engine.PersistentSpellDictionary;
import com.dbeaver.ui.editors.spelling.internal.SpellingActivator;
import com.dbeaver.ui.editors.spelling.sql.SQLCommentDictionary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener,
DBPPreferenceListener {
    private static final Log log = Log.getLog(SpellCheckEngine.class);
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private static Set<Locale> fgLocalesWithInstalledDictionaries;
    private Set<ISpellDictionary> globalDictionaries = new HashSet<ISpellDictionary>();
    private ISpellChecker checker = null;
    private Map<Locale, ISpellDictionary> localeDictionaries = new HashMap<Locale, ISpellDictionary>();
    private ISpellDictionary userDictionary = null;

    private static Set<Locale> getLocalesWithInstalledDictionaries(URL location) {
        String[] fileNames;
        try {
            URL url = FileLocator.toFileURL((URL)location);
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                return Collections.emptySet();
            }
            fileNames = file.list();
            if (fileNames == null) {
                return Collections.emptySet();
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
            return Collections.emptySet();
        }
        HashSet<Locale> localesWithInstalledDictionaries = new HashSet<Locale>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            int localeEnd = fileName.indexOf(".dictionary");
            if (localeEnd > 1) {
                String localeName = fileName.substring(0, localeEnd);
                int languageEnd = localeName.indexOf(95);
                if (languageEnd == -1) {
                    localesWithInstalledDictionaries.add(new Locale(localeName));
                } else if (languageEnd == 2 && localeName.length() == 5) {
                    localesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3)));
                } else if (localeName.length() > 6 && localeName.charAt(5) == '_') {
                    localesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3, 5), localeName.substring(6)));
                }
            }
            ++n2;
        }
        return localesWithInstalledDictionaries;
    }

    public static Set<Locale> getLocalesWithInstalledDictionaries() {
        Enumeration<URL> locations;
        if (fgLocalesWithInstalledDictionaries != null) {
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            locations = SpellCheckEngine.getDictionaryLocations();
            if (locations == null) {
                fgLocalesWithInstalledDictionaries = Collections.emptySet();
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
            fgLocalesWithInstalledDictionaries = Collections.emptySet();
            return fgLocalesWithInstalledDictionaries;
        }
        fgLocalesWithInstalledDictionaries = new HashSet<Locale>();
        while (locations.hasMoreElements()) {
            URL location = locations.nextElement();
            Set<Locale> locales = SpellCheckEngine.getLocalesWithInstalledDictionaries(location);
            fgLocalesWithInstalledDictionaries.addAll(locales);
        }
        return fgLocalesWithInstalledDictionaries;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public ISpellDictionary findDictionary(Locale locale) {
        ISpellDictionary dictionary = this.localeDictionaries.get(locale);
        if (dictionary != null) {
            return dictionary;
        }
        String language = locale.getLanguage();
        for (Map.Entry<Locale, ISpellDictionary> entry : this.localeDictionaries.entrySet()) {
            Locale dictLocale = entry.getKey();
            if (!dictLocale.getLanguage().equals(language)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Locale findClosestLocale(Locale locale) {
        if (locale == null || locale.toString().length() == 0) {
            return locale;
        }
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale)) {
            return locale;
        }
        String language = locale.getLanguage();
        for (Locale dictLocale : SpellCheckEngine.getLocalesWithInstalledDictionaries()) {
            if (!dictLocale.getLanguage().equals(language)) continue;
            return dictLocale;
        }
        Locale defaultLocale = Locale.US;
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(defaultLocale)) {
            return defaultLocale;
        }
        return null;
    }

    public static Enumeration<URL> getDictionaryLocations() throws IOException {
        SpellingActivator plugin = SpellingActivator.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getResources("/dictionaries/");
        }
        return null;
    }

    public static synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    public static synchronized void shutdownInstance() {
        if (fgEngine != null) {
            fgEngine.shutdown();
            fgEngine = null;
        }
    }

    private SpellCheckEngine() {
        this.globalDictionaries.add(new HtmlTagDictionary());
        this.globalDictionaries.add(new SQLCommentDictionary());
        try {
            Enumeration<URL> locations = SpellCheckEngine.getDictionaryLocations();
            while (locations != null && locations.hasMoreElements()) {
                URL location = locations.nextElement();
                for (Locale locale : SpellCheckEngine.getLocalesWithInstalledDictionaries(location)) {
                    this.localeDictionaries.put(locale, new LocaleSensitiveSpellDictionary(locale, location));
                }
            }
        }
        catch (IOException iOException) {}
        EditorsUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
    }

    @Override
    public final synchronized ISpellChecker getSpellChecker() throws IllegalStateException {
        ISpellDictionary dictionary2;
        if (this.globalDictionaries == null) {
            throw new IllegalStateException("spell checker has been shut down");
        }
        BundlePreferenceStore store = SpellingActivator.getDefault().getPreferences();
        Locale locale = this.getCurrentLocale((DBPPreferenceStore)store);
        if (locale.toString().isEmpty()) {
            locale = SpellCheckEngine.getDefaultLocale();
        }
        if (this.checker != null && this.checker.getLocale().equals(locale)) {
            return this.checker;
        }
        this.resetSpellChecker();
        this.checker = new DefaultSpellChecker((DBPPreferenceStore)store, locale);
        this.resetUserDictionary();
        for (ISpellDictionary dictionary2 : this.globalDictionaries) {
            this.checker.addDictionary(dictionary2);
        }
        dictionary2 = this.findDictionary(this.checker.getLocale());
        if (dictionary2 != null) {
            this.checker.addDictionary(dictionary2);
        }
        return this.checker;
    }

    private Locale getCurrentLocale(DBPPreferenceStore store) {
        return SpellCheckEngine.convertToLocale(store.getString("spelling_locale"));
    }

    public static Locale convertToLocale(String locale) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        if (locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        int length = locale.length();
        if (length >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        if (length == 2 && locale.indexOf(95) == -1) {
            return new Locale(locale);
        }
        if (length == 3 && locale.charAt(0) == '_') {
            return new Locale("", locale.substring(1));
        }
        return new Locale("");
    }

    @Override
    public final synchronized Locale getLocale() {
        if (this.checker == null) {
            return null;
        }
        return this.checker.getLocale();
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        this.propertyChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("spelling_locale".equals(event.getProperty())) {
            this.resetSpellChecker();
            return;
        }
        if ("spelling_user_dictionary".equals(event.getProperty())) {
            this.resetUserDictionary();
            return;
        }
        if ("spellingEnabled".equals(event.getProperty()) && !EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
            if (this == fgEngine) {
                SpellCheckEngine.shutdownInstance();
            } else {
                this.shutdown();
            }
        }
    }

    private synchronized void resetUserDictionary() {
        block15: {
            BundlePreferenceStore store;
            String filePath;
            if (this.checker == null) {
                return;
            }
            if (this.userDictionary != null) {
                this.checker.removeDictionary(this.userDictionary);
                this.userDictionary.unload();
                this.userDictionary = null;
            }
            if (!CommonUtils.isEmpty((String)(filePath = (store = SpellingActivator.getDefault().getPreferences()).getString("spelling_user_dictionary")))) {
                try {
                    File file = new File(filePath);
                    if (!file.exists() && !file.createNewFile()) {
                        return;
                    }
                    URL url = new URL("file", null, filePath);
                    InputStream stream = url.openStream();
                    if (stream == null) break block15;
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try {
                        try {
                            this.userDictionary = new PersistentSpellDictionary(url);
                            this.checker.addDictionary(this.userDictionary);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public final synchronized void registerGlobalDictionary(ISpellDictionary dictionary) {
        this.globalDictionaries.add(dictionary);
        this.resetSpellChecker();
    }

    @Override
    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.localeDictionaries.put(locale, dictionary);
        this.resetSpellChecker();
    }

    @Override
    public final synchronized void shutdown() {
        ISpellDictionary dictionary;
        SpellingActivator.getDefault().getPreferences().removePropertyChangeListener((DBPPreferenceListener)this);
        EditorsUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        Iterator<ISpellDictionary> iterator = this.globalDictionaries.iterator();
        while (iterator.hasNext()) {
            ISpellDictionary globalDictionary;
            dictionary = globalDictionary = iterator.next();
            dictionary.unload();
        }
        this.globalDictionaries = null;
        iterator = this.localeDictionaries.values().iterator();
        while (iterator.hasNext()) {
            ISpellDictionary iSpellDictionary;
            dictionary = iSpellDictionary = iterator.next();
            dictionary.unload();
        }
        this.localeDictionaries = null;
        this.userDictionary = null;
        this.checker = null;
    }

    private synchronized void resetSpellChecker() {
        ISpellDictionary dictionary;
        if (this.checker != null && (dictionary = this.localeDictionaries.get(this.checker.getLocale())) != null) {
            dictionary.unload();
        }
        this.checker = null;
    }

    @Override
    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.globalDictionaries.remove(dictionary);
        this.localeDictionaries.values().remove(dictionary);
        dictionary.unload();
        this.resetSpellChecker();
    }
}

