/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.spelling.SpellCheckEngine;
import com.dbeaver.ui.editors.spelling.WordCorrectionProposal;
import com.dbeaver.ui.editors.spelling.engine.ISpellCheckEngine;
import com.dbeaver.ui.editors.spelling.engine.ISpellChecker;
import com.dbeaver.ui.editors.spelling.internal.SpellingActivator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;

public class AddWordProposal
implements ICompletionProposal {
    private static final String PREF_KEY_DO_NOT_ASK = "do_not_ask_to_install_user_dictionary";
    private final IQuickAssistInvocationContext fContext;
    private final String fWord;

    public AddWordProposal(String word, IQuickAssistInvocationContext context) {
        this.fContext = context;
        this.fWord = word;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker == null) {
            return;
        }
        if (!checker.acceptsWords()) {
            Shell shell = this.fContext != null && this.fContext.getSourceViewer() != null ? this.fContext.getSourceViewer().getTextWidget().getShell() : UIUtils.getActiveWorkbenchShell();
            if (!AddWordProposal.canAskToConfigure() || !this.askUserToConfigureUserDictionary(shell)) {
                return;
            }
            String[] preferencePageIds = new String[]{"org.eclipse.ui.editors.preferencePages.Spelling"};
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePageIds[0], (String[])preferencePageIds, null).open();
        }
        if (checker.acceptsWords()) {
            checker.addWord(this.fWord);
            if (this.fContext != null && this.fContext.getSourceViewer() != null) {
                SpellingProblem.removeAll((ISourceViewer)this.fContext.getSourceViewer(), (String)this.fWord);
            }
        }
    }

    private boolean askUserToConfigureUserDictionary(Shell shell) {
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)"Missing User Dictionary", (String)"A user dictionary is needed to add words.\\nDo you want to configure it now?", (String)"&Do not show 'Add word' proposals if user dictionary is missing", (boolean)false, null, null);
        SpellingActivator.getDefault().getPreferences().setValue(PREF_KEY_DO_NOT_ASK, toggleDialog.getToggleState());
        return toggleDialog.getReturnCode() == 2;
    }

    static boolean canAskToConfigure() {
        return !SpellingActivator.getDefault().getPreferences().getBoolean(PREF_KEY_DO_NOT_ASK);
    }

    public String getAdditionalProposalInfo() {
        return "Adds the word '" + WordCorrectionProposal.getHtmlRepresentation(this.fWord) + "' to the dictionary";
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "Add '" + this.fWord + "' to dictionary";
    }

    public Image getImage() {
        return DBeaverIcons.getImage((DBPImage)UIIcon.ADD);
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getOffset(), this.fContext.getLength());
    }
}

