/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.model;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.utils.Pair;

public class Neo4jUtils {
    public static DBPDataKind getAttributeKind(Object value) {
        if (value instanceof String) {
            return DBPDataKind.STRING;
        }
        if (value instanceof Number) {
            return DBPDataKind.NUMERIC;
        }
        if (value instanceof Boolean) {
            return DBPDataKind.BOOLEAN;
        }
        if (value instanceof Date) {
            return DBPDataKind.DATETIME;
        }
        return DBPDataKind.OBJECT;
    }

    public static Pair<String, Integer> convertValueToColumnType(@NotNull Object value) {
        if (value instanceof Long || value instanceof Integer) {
            return new Pair((Object)"INTEGER", (Object)4);
        }
        if (value instanceof Double) {
            return new Pair((Object)"FLOAT", (Object)6);
        }
        if (value instanceof Boolean) {
            return new Pair((Object)"BOOLEAN", (Object)16);
        }
        if (value instanceof Map) {
            return new Pair((Object)"MAP", (Object)2003);
        }
        if (value instanceof List) {
            return new Pair((Object)"LIST", (Object)2003);
        }
        if (value instanceof byte[]) {
            return new Pair((Object)"BYTE ARRAY", (Object)2003);
        }
        if (value instanceof LocalDate) {
            return new Pair((Object)"DATE", (Object)91);
        }
        if (value instanceof OffsetTime) {
            return new Pair((Object)"TIME", (Object)92);
        }
        if (value instanceof LocalTime) {
            return new Pair((Object)"LocalTime", (Object)92);
        }
        if (value instanceof String) {
            return new Pair((Object)"STRING", (Object)12);
        }
        return null;
    }
}

