/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.neo4j.handler;

import com.dbeaver.db.neo4j.model.Neo4jDataSource;
import com.dbeaver.db.neo4j.model.Neo4jTable;
import com.dbeaver.db.neo4j.model.data.Neo4jDocument;
import com.dbeaver.model.document.data.DBDocumentAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class Neo4jValueHandlerDocument
implements DBDValueHandlerComposite {
    public static final Neo4jValueHandlerDocument INSTANCE = new Neo4jValueHandlerDocument();

    public Class<?> getValueObjectType(DBSTypedObject attribute) {
        return Neo4jDocument.class;
    }

    public String getValueContentType(DBSTypedObject attribute) {
        return "text/json";
    }

    public Object fetchValueObject(DBCSession session, DBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException {
        return this.getValueFromObject(session, type, resultSet.getAttributeValue(index), false, false);
    }

    public void bindValueObject(DBCSession session, DBCStatement statement, DBSTypedObject type, int index, Object value) throws DBCException {
    }

    /*
     * WARNING - void declaration
     */
    public Object getValueFromObject(DBCSession session, DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        Neo4jTable table = this.getTable(type);
        if (object == null) {
            return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, null);
        }
        Object object2 = object;
        if (object2 instanceof Map) {
            void srcMap;
            Map map = (Map)object2;
            Map cfr_ignored_0 = (Map)object2;
            LinkedHashMap<String, Object> ddbMap = new LinkedHashMap<String, Object>(srcMap.size());
            for (Map.Entry entry : srcMap.entrySet()) {
                ddbMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, ddbMap);
        }
        DBSTypedObject dBSTypedObject = type;
        if (dBSTypedObject instanceof JDBCColumnMetaData) {
            void columnMetaData;
            JDBCColumnMetaData ddbMap = (JDBCColumnMetaData)dBSTypedObject;
            JDBCColumnMetaData cfr_ignored_1 = (JDBCColumnMetaData)dBSTypedObject;
            return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, Map.of(columnMetaData.getLabel(), object));
        }
        return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, Map.of(type.getFullTypeName(), object));
    }

    public Object createNewValueObject(DBCSession session, DBSTypedObject type) throws DBCException {
        Neo4jTable table = this.getTable(type);
        LinkedHashMap<String, Object> attrValues = table == null ? null : new LinkedHashMap<String, Object>();
        return new Neo4jDocument((Neo4jDataSource)session.getDataSource(), table, attrValues);
    }

    public void releaseValueObject(Object value) {
    }

    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        if (attribute.getDataKind() == DBPDataKind.DOCUMENT) {
            return new DBCLogicalOperator[0];
        }
        return new DBCLogicalOperator[]{DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.GREATER, DBCLogicalOperator.GREATER_EQUALS, DBCLogicalOperator.LESS, DBCLogicalOperator.LESS_EQUALS, DBCLogicalOperator.IN};
    }

    public String getValueDisplayString(DBSTypedObject column, Object value, DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private Neo4jTable getTable(@NotNull DBSTypedObject type) {
        DBSTypedObject dBSTypedObject;
        Object object;
        JDBCColumnMetaData parentObject;
        DBSTypedObject dBSTypedObject2;
        Neo4jTable table = null;
        DBSTypedObject entityAttribute = type;
        DBSTypedObject dBSTypedObject3 = entityAttribute;
        if (dBSTypedObject3 instanceof DBDAttributeBinding) {
            void dbdBindAttribute;
            DBDAttributeBinding dBDAttributeBinding = (DBDAttributeBinding)dBSTypedObject3;
            DBDAttributeBinding cfr_ignored_0 = (DBDAttributeBinding)dBSTypedObject3;
            entityAttribute = dbdBindAttribute.getEntityAttribute();
        }
        if ((dBSTypedObject2 = entityAttribute) instanceof DBDocumentAttribute) {
            void dbdDocAttribute;
            DBDocumentAttribute dBDocumentAttribute = (DBDocumentAttribute)dBSTypedObject2;
            DBDocumentAttribute cfr_ignored_1 = (DBDocumentAttribute)dBSTypedObject2;
            object = parentObject = dbdDocAttribute.getParentObject();
            if (object instanceof Neo4jTable) {
                void neo4jTable;
                Neo4jTable neo4jTable2 = (Neo4jTable)((Object)object);
                Neo4jTable cfr_ignored_2 = (Neo4jTable)((Object)object);
                table = neo4jTable;
            }
        }
        if ((dBSTypedObject = entityAttribute) instanceof JDBCColumnMetaData) {
            void columnMetaData;
            parentObject = (JDBCColumnMetaData)dBSTypedObject;
            JDBCColumnMetaData cfr_ignored_3 = (JDBCColumnMetaData)dBSTypedObject;
            DBSDataContainer dBSDataContainer = columnMetaData.getSource().getDataContainer();
            if (dBSDataContainer instanceof Neo4jTable) {
                void neo4jTable;
                object = (Neo4jTable)dBSDataContainer;
                Neo4jTable cfr_ignored_4 = (Neo4jTable)dBSDataContainer;
                table = neo4jTable;
            }
        }
        return table;
    }
}

