/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.DataSourceInfo;
import com.dbeaver.ee.qm.db.impl.QMDBEventCursor;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.impl.QMDBUserSessionRecord;
import com.dbeaver.ee.qm.db.model.QMDBUtils;
import com.dbeaver.model.qm.QMEventManager;
import com.dbeaver.model.qm.QMService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMDisposable;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.QMSessionProvider;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.filters.QMAdminCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMQueryFilter;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMProjectInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMUserInfo;
import org.jkiss.dbeaver.model.rm.RMUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class QMEmbeddedService
implements QMService,
QMDisposable,
QMEventManager {
    private static final Log log = Log.getLog(QMEmbeddedService.class);
    private static final int QM_SESSION_ID_WAITING_TIME = 300000;
    private final Map<String, Long> connectionMap = new HashMap<String, Long>();
    private final Map<String, DataSourceInfo> dataSourceCache = new HashMap<String, DataSourceInfo>();
    private final LongKeyMap<QMMConnectionInfo> connectionCache = new LongKeyMap();
    private final LongKeyMap<QMMProjectInfo> projectCache = new LongKeyMap();
    private final Map<String, QMDBUserSessionRecord> qmUserSessionCache = new WeakHashMap<String, QMDBUserSessionRecord>();
    private final Map<String, Long> projectIdsCache = new HashMap<String, Long>();
    private volatile QMDBModel qmdbModel;

    private synchronized QMDBModel getModel() {
        if (this.qmdbModel == null) {
            this.qmdbModel = QMDBModel.getInstance();
        }
        return this.qmdbModel;
    }

    private void initModel(QMDBModel model) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = model.getConnection();){
            if (dbCon == null) {
                return;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public QMEventCursor getQueryHistoryCursor(@NotNull QMCursorFilter cursorFilter) throws DBException {
        QMDBModel model = this.getModel();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection dbCon = model.getConnection();){
                if (dbCon == null) {
                    throw new DBException("QMDB connection is closed - can't read history");
                }
                String qmAppSessionId = cursorFilter.getSessionId();
                if (CommonUtils.isEmpty((String)qmAppSessionId) && DBWorkbench.getPlatform().getApplication() instanceof QMSessionProvider) {
                    qmAppSessionId = this.tryToGetQmSessionId();
                }
                if (qmAppSessionId == null) {
                    throw new DBException("Cannot find QM session info");
                }
                QMDBUserSessionRecord userSessionRecord = this.getUserSessionRecord(dbCon, qmAppSessionId);
                String userName = this.getUserBySession(qmAppSessionId, model, dbCon).getUserName();
                if ("@anonymous@".equals(userName)) {
                    cursorFilter.getCriteria().setSessionId(userSessionRecord.sessionId());
                }
                QMAdminCursorFilter adminFilter = new QMAdminCursorFilter(cursorFilter, Set.of(userName));
                return this.getAdminQueryHistoryCursor(adminFilter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error getting cursor:" + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public QMEventCursor getAdminQueryHistoryCursor(@NotNull QMAdminCursorFilter cursorFilter) throws DBException {
        try {
            return new QMDBEventCursor(this, cursorFilter.getAdminCriteria(), cursorFilter.getFilter(), this.qmdbModel);
        }
        catch (SQLException e) {
            throw new DBException("Error getting filter history", (Throwable)e);
        }
    }

    @NotNull
    public QMEventCursor getSupervisorQueryHistoryCursor(@NotNull QMAdminCursorFilter cursorFilter) throws DBException {
        return this.getAdminQueryHistoryCursor(cursorFilter);
    }

    /*
     * Exception decompiling
     */
    public void saveEvents(List<QMMetaEvent> events) throws DBException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveTransactionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMTransactionInfo transactionInfo, QMEventAction action) throws DBException, SQLException {
        this.createEventInfo(dbConnection, record, (QMMObject)transactionInfo, action, transactionInfo.getConnection());
    }

    private void saveConnectionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMConnectionInfo connectionInfo, QMEventAction action) throws SQLException, DBException {
        if (action != QMEventAction.BEGIN && action != QMEventAction.END) {
            return;
        }
        if (action == QMEventAction.BEGIN) {
            this.saveOpenConnectionInfo(dbConnection, record.sessionId(), connectionInfo);
        }
        this.createEventInfo(dbConnection, record, (QMMObject)connectionInfo, action, connectionInfo);
        if (action == QMEventAction.END) {
            this.closeConnectionInfo(dbConnection, record.sessionId(), connectionInfo);
        }
    }

    private void saveStatementExecutionInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMStatementExecuteInfo executeInfo, QMEventAction action) throws DBException, SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement dbStatStatement = dbConnection.prepareStatement(this.getModel().normalizeTableNames("INSERT INTO {table_prefix}QM_STATEMENT (STATEMENT_ID,STATEMENT_PURPOSE,QUERY_ID,ROW_COUNT,ERROR_CODE,ERROR_MESSAGE,EXECUTE_TIME,FETCH_TIME,QUERY_SCHEMA,QUERY_CATALOG) VALUES(?,?,?,?,?,?,?,?,?,?)"));){
            long eventId = this.createEventInfo(dbConnection, record, (QMMObject)executeInfo, action, executeInfo.getStatement().getConnection());
            if (eventId == -1L) {
                return;
            }
            if (action != QMEventAction.END) {
                return;
            }
            long queryId = this.getQueryId(record.userId(), executeInfo.getQueryString());
            dbStatStatement.setLong(1, eventId);
            dbStatStatement.setInt(2, executeInfo.getStatement().getPurpose().getId());
            dbStatStatement.setLong(3, queryId);
            long rowCount = executeInfo.getUpdateRowCount();
            if (rowCount < 0L) {
                rowCount = executeInfo.getFetchRowCount();
            }
            dbStatStatement.setLong(4, rowCount);
            dbStatStatement.setInt(5, executeInfo.getErrorCode());
            if (CommonUtils.isEmpty((String)executeInfo.getErrorMessage())) {
                dbStatStatement.setNull(6, 12);
            } else {
                dbStatStatement.setString(6, executeInfo.getErrorMessage());
            }
            dbStatStatement.setInt(7, (int)(executeInfo.getCloseTime() - executeInfo.getOpenTime()));
            long fetchEndTime = executeInfo.getFetchEndTime();
            dbStatStatement.setInt(8, (int)(fetchEndTime > 0L ? fetchEndTime - executeInfo.getFetchBeginTime() : 0L));
            dbStatStatement.setString(9, executeInfo.getSchema());
            dbStatStatement.setString(10, executeInfo.getCatalog());
            dbStatStatement.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public Collection<String> getQueryFilterHistory(@NotNull String sessionId, @NotNull String query) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveQueryFilterValue(@NotNull String sessionId, @NotNull QMQueryFilter queryFilter) throws DBException {
        try {
            String query = queryFilter.getQuery();
            String filterValue = queryFilter.getFilterValue();
            QMDBModel model = this.getModel();
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection dbCon = model.getConnection();){
                long userId = this.getUserBySession(sessionId, model, dbCon).getUserId();
                long queryId = this.getQueryId(userId, query);
                long filterHash = QMDBUtils.getHashCode(filterValue);
                String sqlUpdate = model.normalizeTableNames("UPDATE {table_prefix}QM_QUERY_FILTER SET FILTER_TEXT=? WHERE QUERY_ID=? AND FILTER_HASH=?");
                int updatedRows = JDBCUtils.executeUpdate((Connection)dbCon, (String)sqlUpdate, (Object[])new Object[]{filterValue, queryId, filterHash});
                if (updatedRows != 1) {
                    String sqlInsert = model.normalizeTableNames("INSERT INTO {table_prefix}QM_QUERY_FILTER (QUERY_ID,FILTER_HASH,FILTER_TEXT)  VALUES(?,?,?)");
                    JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)sqlInsert, (String)"FILTER_ID", (Object[])new Object[]{queryId, filterHash, filterValue});
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error saving filter history", (Throwable)e);
        }
    }

    public void deleteQueryFilterValue(@NotNull String sessionId, @NotNull QMQueryFilter queryFilter) throws DBException {
        try {
            QMDBModel model = this.getModel();
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection dbCon = model.getConnection();){
                long userId = this.getUserBySession(sessionId, model, dbCon).getUserId();
                long queryId = this.getQueryId(userId, queryFilter.getQuery());
                long filterHash = QMDBUtils.getHashCode(queryFilter.getFilterValue());
                Throwable throwable2 = null;
                Object var14_15 = null;
                try (PreparedStatement dbStat = dbCon.prepareStatement(model.normalizeTableNames("DELETE FROM {table_prefix}QM_QUERY_FILTER WHERE QUERY_ID=? AND FILTER_HASH=? AND (USER_ID IS NULL OR USER_ID=?)"));){
                    dbStat.setLong(1, queryId);
                    dbStat.setLong(2, filterHash);
                    dbStat.setLong(2, userId);
                    dbStat.execute();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error deleting filter history", (Throwable)e);
        }
    }

    private long createEventInfo(Connection dbConnection, QMDBUserSessionRecord record, QMMObject object, QMEventAction action, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        PreparedStatement dbStatEvent = dbConnection.prepareStatement(this.getModel().normalizeTableNames("INSERT INTO {table_prefix}QM_EVENT (CONNECTION_ID,SOURCE_ID,EVENT_ACTION,EVENT_TYPE,EVENT_TIME,USER_ID) VALUES(?,?,?,?,?,?)"), JDBCUtils.getColumnList((String)"EVENT_ID"));
        Long connectionId = this.getConnectionId(dbConnection, record.sessionId(), connectionInfo);
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + connectionInfo.getContainerId() + " for event " + String.valueOf(action) + "."));
            return -1L;
        }
        dbStatEvent.setLong(1, connectionId);
        dbStatEvent.setNull(2, 12);
        dbStatEvent.setInt(3, action.getId());
        dbStatEvent.setInt(4, this.getEventTypeId(object));
        if (QMUtils.getObjectEventTime((QMMObject)object, (QMEventAction)action) <= 0L) {
            dbStatEvent.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            log.debug((Object)(String.valueOf(connectionId) + ":" + connectionInfo.getProjectInfo().getId() + ":" + connectionInfo.getConnectionUserName() + " .Incorrect date for connection close. Connection reopen"));
        } else {
            dbStatEvent.setTimestamp(5, new Timestamp(QMUtils.getObjectEventTime((QMMObject)object, (QMEventAction)action)));
        }
        dbStatEvent.setLong(6, record.userId());
        dbStatEvent.execute();
        return JDBCUtils.getGeneratedKey((PreparedStatement)dbStatEvent);
    }

    private int getEventTypeId(QMMObject object) {
        Class<?> eventClass = object.getClass();
        if (eventClass == QMMConnectionInfo.class) {
            return 1;
        }
        if (eventClass == QMMTransactionInfo.class) {
            return 2;
        }
        if (eventClass == QMMTransactionSavepointInfo.class) {
            return 3;
        }
        if (eventClass == QMMStatementInfo.class) {
            return 4;
        }
        if (eventClass == QMMStatementExecuteInfo.class) {
            return 5;
        }
        return -1;
    }

    private long saveOpenConnectionInfo(Connection dbConnection, Long sessionId, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        QMDBModel model = this.getModel();
        Long projectId = this.getProjectId(connectionInfo);
        Long connectionId = this.getConnectionId(dbConnection, sessionId, connectionInfo);
        if (connectionId != null) {
            log.debug((Object)"Connection info already exists. Mixed events?");
            return connectionId;
        }
        Long runId = model.getRunId();
        String connectionURL = connectionInfo.getConnectionUrl() == null ? "?" : connectionInfo.getConnectionUrl();
        String dsName = (String)JDBCUtils.executeQuery((Connection)dbConnection, (String)model.normalizeTableNames("SELECT NAME FROM {table_prefix}QM_DATASOURCE WHERE DATASOURCE_ID=?"), (Object[])new Object[]{connectionInfo.getContainerId()});
        Long workspaceId = model.getWorkspaceId();
        if (dsName == null) {
            JDBCUtils.executeSQL((Connection)dbConnection, (String)model.normalizeTableNames("INSERT INTO {table_prefix}QM_DATASOURCE (WORKSPACE_ID,DATASOURCE_ID,NAME,URL,DRIVER,UPDATE_TIME) VALUES(?,?,?,?,?,CURRENT_TIMESTAMP)"), (Object[])new Object[]{workspaceId, CommonUtils.truncateString((String)connectionInfo.getContainerId(), (int)255), CommonUtils.truncateString((String)connectionInfo.getContainerName(), (int)255), CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionURL), (int)1024), connectionInfo.getDriverId()});
        } else {
            JDBCUtils.executeSQL((Connection)dbConnection, (String)model.normalizeTableNames("UPDATE {table_prefix}QM_DATASOURCE SET NAME=?,URL=?,DRIVER=?,UPDATE_TIME=CURRENT_TIMESTAMP WHERE WORKSPACE_ID=? AND DATASOURCE_ID=?"), (Object[])new Object[]{CommonUtils.truncateString((String)connectionInfo.getContainerName(), (int)255), CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionURL), (int)1024), connectionInfo.getDriverId(), workspaceId, CommonUtils.truncateString((String)connectionInfo.getContainerId(), (int)255)});
        }
        connectionId = JDBCUtils.executeInsertAutoIncrement((Connection)dbConnection, (String)model.normalizeTableNames("INSERT INTO {table_prefix}QM_CONNECTION (RUN_ID,WORKSPACE_ID,PROJECT_ID,DATASOURCE_ID,SESSION_ID,INSTANCE_ID,CONTEXT_NAME,CONNECTION_USER,CONNECT_TIME) VALUES(?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP)"), (String)"CONNECTION_ID", (Object[])new Object[]{runId, workspaceId, projectId, connectionInfo.getContainerId(), sessionId, CommonUtils.truncateString((String)CommonUtils.notEmpty((String)connectionInfo.getInstanceId()), (int)64), CommonUtils.notEmpty((String)connectionInfo.getContextName()), CommonUtils.notEmpty((String)connectionInfo.getConnectionUserName())});
        this.connectionMap.put(QMEmbeddedService.makeConnectionKey(sessionId, connectionInfo), connectionId);
        return connectionId;
    }

    private void closeConnectionInfo(Connection dbConnection, Long sessionId, QMMConnectionInfo sessionInfo) throws SQLException, DBException {
        QMDBModel model = this.getModel();
        Long connectionId = this.getConnectionId(dbConnection, sessionId, sessionInfo);
        if (connectionId == null) {
            log.debug((Object)("Can't find QMDB connection info " + sessionInfo.getContainerId() + " for close"));
            return;
        }
        JDBCUtils.executeSQL((Connection)dbConnection, (String)model.normalizeTableNames("UPDATE {table_prefix}QM_CONNECTION SET DISCONNECT_TIME=? WHERE CONNECTION_ID=?"), (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), connectionId});
        this.connectionMap.remove(QMEmbeddedService.makeConnectionKey(sessionId, sessionInfo));
    }

    private Long getConnectionId(Connection dbConnection, Long sessionId, QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        String connectionKey = QMEmbeddedService.makeConnectionKey(sessionId, connectionInfo);
        if (this.connectionMap.containsKey(connectionKey)) {
            return this.connectionMap.get(connectionKey);
        }
        QMDBModel model = this.getModel();
        Object sqlScript = "SELECT CONNECTION_ID FROM {table_prefix}QM_CONNECTION WHERE DATASOURCE_ID=? AND SESSION_ID=? AND DISCONNECT_TIME IS NULL";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(connectionInfo.getContainerId());
        params.add(sessionId);
        Long projectId = this.getProjectId(connectionInfo);
        if (projectId != null) {
            sqlScript = (String)sqlScript + " AND PROJECT_ID=?";
            params.add(projectId);
        }
        if (connectionInfo.getInstanceId() != null) {
            sqlScript = (String)sqlScript + " AND INSTANCE_ID=?";
            params.add(connectionInfo.getInstanceId());
        }
        if (connectionInfo.getContextName() != null) {
            sqlScript = (String)sqlScript + " AND CONTEXT_NAME=?";
            params.add(connectionInfo.getContextName());
        }
        return (Long)JDBCUtils.executeQuery((Connection)dbConnection, (String)model.normalizeTableNames((String)sqlScript), (Object[])params.toArray());
    }

    private long createUserSession(Connection dbConnection, @NotNull Long runId, @Nullable Long userId, @NotNull String appSessionId, @NotNull String userIp) throws SQLException {
        QMDBModel model = this.getModel();
        return JDBCUtils.executeInsertAutoIncrement((Connection)dbConnection, (String)model.normalizeTableNames("INSERT INTO {table_prefix}QM_USER_SESSION (RUN_ID,APP_SESSION_ID,USER_ID,USER_IP,START_TIME) VALUES(?,?,?,?,CURRENT_TIMESTAMP)"), (String)"SESSION_ID", (Object[])new Object[]{runId, appSessionId, userId, userIp});
    }

    private QMDBUserSessionRecord getUserSessionRecord(@NotNull Connection dbConnection, @Nullable String qmAppSessionId) throws DBException {
        if (CommonUtils.isEmpty((String)qmAppSessionId)) {
            return null;
        }
        QMDBUserSessionRecord userSession = null;
        try {
            userSession = this.findUserSession(dbConnection, qmAppSessionId);
        }
        catch (SQLException e) {
            log.error((Object)"Error during find qm session", (Throwable)e);
        }
        if (userSession == null) {
            throw new DBException("Session not found in qm: " + qmAppSessionId);
        }
        return userSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    private QMDBUserSessionRecord findUserSession(@NotNull Connection dbConnection, @NotNull String appSessionId) throws SQLException {
        Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
        // MONITORENTER : map
        QMDBModel model = this.getModel();
        if (this.qmUserSessionCache.containsKey(appSessionId)) {
            // MONITOREXIT : map
            return this.qmUserSessionCache.get(appSessionId);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            QMDBUserSessionRecord qMDBUserSessionRecord;
            PreparedStatement dbStat = dbConnection.prepareStatement(model.normalizeTableNames("SELECT USER_ID,SESSION_ID FROM {table_prefix}QM_USER_SESSION WHERE APP_SESSION_ID=?"));
            try {
                dbStat.setObject(1, appSessionId);
                Throwable throwable2 = null;
                Object var9_12 = null;
                try {
                    ResultSet resultSet;
                    block18: {
                        resultSet = dbStat.executeQuery();
                        try {
                            if (!resultSet.next()) break block18;
                            long userId = resultSet.getLong(1);
                            long sessionId = resultSet.getLong(2);
                            QMDBUserSessionRecord record = new QMDBUserSessionRecord(userId, sessionId);
                            this.qmUserSessionCache.put(appSessionId, record);
                            qMDBUserSessionRecord = record;
                            if (resultSet == null) return qMDBUserSessionRecord;
                        }
                        catch (Throwable throwable3) {
                            if (resultSet == null) throw throwable3;
                            resultSet.close();
                            throw throwable3;
                        }
                        resultSet.close();
                        return qMDBUserSessionRecord;
                    }
                    if (resultSet == null) return null;
                    resultSet.close();
                    return null;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            finally {
                if (dbStat == null) {
                    // MONITOREXIT : map
                    return qMDBUserSessionRecord;
                }
                dbStat.close();
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String tryToGetQmSessionId() {
        String qmSessionId;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (!(dBPApplication instanceof QMSessionProvider)) {
            return null;
        }
        QMSessionProvider qMSessionProvider = (QMSessionProvider)dBPApplication;
        QMSessionProvider cfr_ignored_0 = (QMSessionProvider)dBPApplication;
        long startTime = System.currentTimeMillis();
        do {
            void qmSessionReceiver;
            if ((qmSessionId = qmSessionReceiver.getQmSessionId()) != null) {
                return qmSessionId;
            }
            RuntimeUtils.pause((int)100);
        } while (System.currentTimeMillis() - startTime < 300000L);
        return qmSessionId;
    }

    public void dispose() {
    }

    /*
     * Exception decompiling
     */
    private long getQueryId(long userId, String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String openSession(@NotNull QMSessionInfo sessionInfo) throws DBException {
        QMDBModel model = this.getModel();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection dbCon = model.getConnection();){
                if (dbCon == null) {
                    throw new DBException("QMDB database not initialized");
                }
                long userId = model.findOrCreateUser(sessionInfo.getUserName(), sessionInfo.getUserDomain());
                UUID qmSessionUuid = UUID.randomUUID();
                String qmSessionId = qmSessionUuid.toString();
                String userIp = sessionInfo.getUserIp() != null ? sessionInfo.getUserIp().replaceAll("[\\[\\]]", "") : null;
                long sessionId = this.createUserSession(dbCon, model.getRunId(), userId, qmSessionId, userIp);
                Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
                synchronized (map) {
                    this.qmUserSessionCache.put(qmSessionId, new QMDBUserSessionRecord(userId, sessionId));
                }
                return qmSessionId;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error during open new qm session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(String appSessionId) {
        Map<String, QMDBUserSessionRecord> map = this.qmUserSessionCache;
        synchronized (map) {
            this.qmUserSessionCache.remove(appSessionId);
        }
    }

    @NotNull
    private static String makeConnectionKey(Long sessionId, QMMConnectionInfo connectionInfo) {
        return connectionInfo.getContainerId() + ":" + connectionInfo.getInstanceId() + ":" + connectionInfo.getContextName() + ":" + String.valueOf(sessionId) + ":" + connectionInfo.getProjectInfo().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QMMConnectionInfo getConnectionInfo(Connection dbConnection, long projectId, long connectionId, String containerId, String instanceId, String contextName, long eventStart) throws DBException {
        LongKeyMap<QMMConnectionInfo> longKeyMap = this.connectionCache;
        synchronized (longKeyMap) {
            QMMConnectionInfo connectionInfo = (QMMConnectionInfo)this.connectionCache.get(connectionId);
            if (connectionInfo == null) {
                DataSourceInfo dataSourceInfo = this.getDataSourceInfo(dbConnection, containerId);
                QMMProjectInfo projectInfo = this.getProjectInfo(dbConnection, projectId);
                DBPConnectionConfiguration config = new DBPConnectionConfiguration();
                config.setUrl(dataSourceInfo.getUrl());
                connectionInfo = new QMMConnectionInfo(eventStart, eventStart, projectInfo, containerId, dataSourceInfo.getName(), dataSourceInfo.getDriverID(), config, instanceId, contextName, false);
                this.connectionCache.put(connectionId, (Object)connectionInfo);
            }
            return connectionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceInfo getDataSourceInfo(Connection dbConnection, String containerId) throws DBException {
        Map<String, DataSourceInfo> map = this.dataSourceCache;
        synchronized (map) {
            DataSourceInfo dataSourceInfo = this.dataSourceCache.get(containerId);
            if (dataSourceInfo == null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (PreparedStatement stmt = dbConnection.prepareStatement(this.getModel().normalizeTableNames("SELECT * FROM {table_prefix}QM_DATASOURCE WHERE DATASOURCE_ID=?"));){
                        stmt.setString(1, containerId);
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (ResultSet dbResult = stmt.executeQuery();){
                            if (dbResult.next()) {
                                String name = dbResult.getString("NAME");
                                String url = dbResult.getString("URL");
                                String driverID = dbResult.getString("DRIVER");
                                dataSourceInfo = new DataSourceInfo(containerId, driverID, name, url);
                            } else {
                                dataSourceInfo = new DataSourceInfo(containerId);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading datasource info", (Throwable)e);
                }
                this.dataSourceCache.put(containerId, dataSourceInfo);
            }
            return dataSourceInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Long getProjectId(QMMConnectionInfo connectionInfo) throws SQLException, DBException {
        QMMProjectInfo projectInfo = connectionInfo.getProjectInfo();
        String projectUniqueName = projectInfo.getId();
        Map<String, Long> map = this.projectIdsCache;
        synchronized (map) {
            if (this.projectIdsCache.containsKey(projectUniqueName)) {
                return this.projectIdsCache.get(projectUniqueName);
            }
            Long projectId = this.getModel().findOrCreateQMDBeaverProject(projectInfo);
            this.projectIdsCache.put(projectUniqueName, projectId);
            return projectId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QMMProjectInfo getProjectInfo(Connection dbConnection, Long projectId) throws DBException {
        LongKeyMap<QMMProjectInfo> longKeyMap = this.projectCache;
        synchronized (longKeyMap) {
            QMMProjectInfo projectInfo = (QMMProjectInfo)this.projectCache.get((Object)projectId);
            if (projectInfo != null) {
                return projectInfo;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (PreparedStatement stmt = dbConnection.prepareStatement(this.getModel().normalizeTableNames("SELECT * FROM {table_prefix}QM_DBEAVER_PROJECT WHERE PROJECT_ID=?"));){
                    stmt.setLong(1, projectId);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (ResultSet dbResult = stmt.executeQuery();){
                        if (dbResult.next()) {
                            String projectIdString;
                            String projectName = projectIdString = dbResult.getString("PROJECT_NAME");
                            if (DBWorkbench.isDistributed() && projectName.contains("_")) {
                                projectName = RMUtils.getProjectName((String)projectName);
                            }
                            projectInfo = QMMProjectInfo.builder().setId(projectIdString).setName(projectName).setPath(dbResult.getString("PROJECT_PATH")).setAnonymous(dbResult.getBoolean("IS_ANONYMOUS")).build();
                        } else {
                            projectInfo = QMMProjectInfo.builder().build();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error reading project info", (Throwable)e);
            }
            this.projectCache.put(projectId, (Object)projectInfo);
            return projectInfo;
        }
    }

    /*
     * Exception decompiling
     */
    public List<QMTranslationHistoryItem> readSmartCompletionHistory(@NotNull String sessionId, @NotNull String dataSourceId, @NotNull String logicalDataSourceName, @Nullable String currentCatalog, @Nullable String currentSchema, int maxCount) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public QMMUserInfo getUserBySession(@NotNull String sessionId, QMDBModel model, Connection dbConnection) throws DBException {
        QMDBUserSessionRecord userSessionRecord;
        Object object = this.qmUserSessionCache;
        synchronized (object) {
            userSessionRecord = this.qmUserSessionCache.get(sessionId);
        }
        if (userSessionRecord == null) {
            userSessionRecord = this.getUserSessionRecord(dbConnection, sessionId);
        }
        try {
            object = null;
            Object var6_8 = null;
            try (PreparedStatement stmt = dbConnection.prepareStatement(model.normalizeTableNames("SELECT u.USER_ID, u.USER_NAME FROM {table_prefix}QM_USER u LEFT JOIN {table_prefix}QM_USER_SESSION us ON u.USER_ID=us.USER_ID WHERE us.SESSION_ID=?"));){
                QMMUserInfo qMMUserInfo;
                ResultSet dbResult;
                Throwable throwable;
                block26: {
                    stmt.setLong(1, userSessionRecord.sessionId());
                    throwable = null;
                    Object var9_13 = null;
                    dbResult = stmt.executeQuery();
                    if (!dbResult.next()) {
                        throw new DBException("Cannot find connection ID for session " + sessionId);
                    }
                    long userId = dbResult.getLong(1);
                    String userName = dbResult.getString(2);
                    qMMUserInfo = new QMMUserInfo(userId, userName);
                    if (dbResult == null) break block26;
                    dbResult.close();
                }
                return qMMUserInfo;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading datasource info", (Throwable)e);
        }
    }

    public void saveSmartCompletionHistory(@NotNull String sessionId, @NotNull String dataSourceId, @NotNull String logicalDataSourceName, @Nullable String currentCatalog, @Nullable String currentSchema, @NotNull String natualText, @NotNull String sqlText) throws DBException {
        block57: {
            QMDBModel model = this.getModel();
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (Connection dbCon = model.getConnection();){
                    Throwable e2;
                    PreparedStatement stmt;
                    Object var17_24;
                    if (dbCon == null) {
                        throw new DBException("QMDB connection is closed - can't read history");
                    }
                    long userId = this.getUserBySession(sessionId, model, dbCon).getUserId();
                    long completionId = -1L;
                    try {
                        Throwable throwable2 = null;
                        var17_24 = null;
                        try {
                            stmt = dbCon.prepareStatement(model.normalizeTableNames("SELECT COMPLETION_ID FROM {table_prefix}QM_AI_COMPLETION_HISTORY\nWHERE USER_ID=? AND DATASOURCE_ID=? AND LOGICAL_DATASOURCE_NAME=?\nAND DEFAULT_CATALOG=? AND DEFAULT_SCHEMA=? AND %s".formatted(model.getDatabaseDialect().getClobComparingPart("NATURAL_TEXT"))));
                            try {
                                stmt.setLong(1, userId);
                                stmt.setString(2, dataSourceId);
                                stmt.setString(3, logicalDataSourceName);
                                stmt.setString(4, CommonUtils.notEmpty((String)currentCatalog));
                                stmt.setString(5, CommonUtils.notEmpty((String)currentSchema));
                                stmt.setString(6, natualText);
                                Throwable throwable3 = null;
                                Object var20_31 = null;
                                try (ResultSet dbResult = stmt.executeQuery();){
                                    if (dbResult.next()) {
                                        completionId = dbResult.getLong(1);
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (SQLException e2) {
                        throw new DBException("Error reading completion info", (Throwable)e2);
                    }
                    if (completionId == -1L) {
                        try {
                            e2 = null;
                            var17_24 = null;
                            try {
                                stmt = dbCon.prepareStatement(model.normalizeTableNames("INSERT INTO {table_prefix}QM_AI_COMPLETION_HISTORY (USER_ID,DATASOURCE_ID,LOGICAL_DATASOURCE_NAME,DEFAULT_CATALOG,DEFAULT_SCHEMA,NATURAL_TEXT,SQL_TEXT,FIRST_COMPLETION_TIME,LAST_COMPLETION_TIME,COMPLETION_COUNT) VALUES(?,?,?,?,?,?,?,?,?,?)"));
                                try {
                                    stmt.setLong(1, userId);
                                    stmt.setString(2, dataSourceId);
                                    stmt.setString(3, logicalDataSourceName);
                                    stmt.setString(4, CommonUtils.notEmpty((String)currentCatalog));
                                    stmt.setString(5, CommonUtils.notEmpty((String)currentSchema));
                                    stmt.setString(6, natualText);
                                    stmt.setString(7, sqlText);
                                    stmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                                    stmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                                    stmt.setInt(10, 1);
                                    stmt.execute();
                                    break block57;
                                }
                                finally {
                                    if (stmt != null) {
                                        stmt.close();
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (e2 == null) {
                                    e2 = throwable6;
                                } else if (e2 != throwable6) {
                                    e2.addSuppressed(throwable6);
                                }
                                throw e2;
                            }
                        }
                        catch (SQLException e3) {
                            throw new DBException("Error inserting smart completion info: " + e3.getMessage(), (Throwable)e3);
                        }
                    }
                    try {
                        e2 = null;
                        var17_24 = null;
                        try {
                            stmt = dbCon.prepareStatement(model.normalizeTableNames("UPDATE {table_prefix}QM_AI_COMPLETION_HISTORY SET LAST_COMPLETION_TIME=?,COMPLETION_COUNT=COMPLETION_COUNT+1 WHERE USER_ID=? AND COMPLETION_ID=?"));
                            try {
                                stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                                stmt.setLong(2, userId);
                                stmt.setLong(3, completionId);
                                stmt.execute();
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (e2 == null) {
                                e2 = throwable7;
                            } else if (e2 != throwable7) {
                                e2.addSuppressed(throwable7);
                            }
                            throw e2;
                        }
                    }
                    catch (SQLException e4) {
                        throw new DBException("Error inserting smart completion info: " + e4.getMessage(), (Throwable)e4);
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException("Error saving smart completion info: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String ping() {
        return "pong (QM)";
    }
}

