/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.QMConfigurationProviderEE;
import com.dbeaver.ee.qm.db.QMDBDataSourceProvider;
import com.dbeaver.ee.qm.db.impl.EmbeddedDatabase;
import com.dbeaver.ee.qm.db.model.QMDBQueryFilter;
import com.dbeaver.ee.qm.db.model.QMDBQueryRecord;
import com.dbeaver.ee.qm.db.model.QMDatabaseConfig;
import com.dbeaver.ee.qm.internal.QMActivator;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMProjectInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.sql.schema.ClassLoaderScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaManager;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaVersionManager;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class QMDBModel {
    private static final Log log = Log.getLog(QMDBModel.class);
    public static final String DATABASE_DEFAULT_DRIVER_CLASS = "org.h2.Driver";
    public static final String EMBEDDED_DATABASE_ID = "qmdb";
    private static final String EMPTY_DOMAIN_NAME = "*";
    private QMDatabaseConfig databaseConfig;
    private static QMDBModel instance;
    private String schemaName;
    private Long deployId;
    private Long productVersionId;
    private Long workspaceId;
    private Long hostId;
    private Long runId;
    private PoolingDataSource<PoolableConnection> dbConnection;
    private SQLDialect databaseDialect;
    private ClassLoader driverClassLoader;
    private EmbeddedDatabase embeddedDatabase;

    public static synchronized QMDBModel getInstance() {
        if (instance == null) {
            instance = new QMDBModel();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance != null) {
            instance.shutdownModel();
            instance = null;
        }
    }

    public QMDBModel() {
        this.openConnection();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection dbCon = this.getConnection();){
                if (dbCon != null) {
                    DatabaseMetaData metaData = dbCon.getMetaData();
                    this.initializeSchema(dbCon);
                    String dbName = metaData.getDatabaseProductName();
                    String dbVersion = metaData.getDatabaseProductVersion();
                    log.debug((Object)("\tQMDB server started (" + dbName + " " + dbVersion + ")"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error initializing QM database schema", (Throwable)e);
            this.closeConnection();
        }
    }

    public boolean isInitialized() {
        return this.dbConnection != null;
    }

    Long getRunId() {
        return this.runId;
    }

    Long getWorkspaceId() {
        return this.workspaceId;
    }

    public EmbeddedDatabase getEmbeddedDatabase() {
        return this.embeddedDatabase;
    }

    public SQLDialect getDatabaseDialect() {
        return this.databaseDialect;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public synchronized Connection getConnection() {
        block6: {
            try {
                if (this.dbConnection != null) break block6;
                return null;
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        Connection conn = this.dbConnection.getConnection();
        try {
            if (!conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error setting auto-commit state", (Throwable)e);
        }
        return conn;
    }

    private synchronized void openConnection() {
        if (this.dbConnection == null && !DBWorkbench.getPlatform().getApplication().isExclusiveMode()) {
            log.debug((Object)"Initialize QMDB...");
            QMConfigurationProviderEE qmConfigurationProvider = (QMConfigurationProviderEE)DBUtils.getAdapter(QMConfigurationProviderEE.class, (Object)DBWorkbench.getPlatform().getApplication());
            this.databaseConfig = qmConfigurationProvider != null ? qmConfigurationProvider.getQmDatabaseConfig() : QMDatabaseConfig.DESKTOP_CONFIG;
            Properties conProperties = new Properties();
            if (!CommonUtils.isEmpty((String)this.databaseConfig.getUser())) {
                conProperties.put("user", this.databaseConfig.getUser());
                if (!CommonUtils.isEmpty((String)this.databaseConfig.getPassword())) {
                    conProperties.put("password", this.databaseConfig.getPassword());
                }
            }
            if (CommonUtils.isNotEmpty((String)this.databaseConfig.getSchema())) {
                this.schemaName = this.databaseConfig.getSchema();
            }
            DataSourceProviderRegistry dataSourceProviderRegistry = DataSourceProviderRegistry.getInstance();
            try {
                if (this.databaseConfig.isH2Embedded()) {
                    Path dbPath = QMDBModel.getEmbeddedDatabasePath();
                    DBPDriver driver = dataSourceProviderRegistry.findDriver("h2_embedded_v2");
                    if (driver == null) {
                        throw new DBException("QMDB driver 'h2_embedded_v2' not found");
                    }
                    ClassLoader dbClassLoader = driver.getDriverInstance((DBRProgressMonitor)new LoggingProgressMonitor(log)).getClass().getClassLoader();
                    EmbeddedDatabase embeddedDB = new EmbeddedDatabase(this.databaseConfig, dbPath, dbClassLoader, this.dbConnection);
                    embeddedDB.loadQmDefaultConfiguration();
                    embeddedDB.migrateDatabaseToNewVersion(dataSourceProviderRegistry, conProperties);
                    this.connectToDatabase(conProperties, dataSourceProviderRegistry);
                    if (this.dbConnection != null) {
                        this.embeddedDatabase = embeddedDB;
                        this.embeddedDatabase.saveConfigurationFile();
                    }
                } else {
                    this.connectToDatabase(conProperties, dataSourceProviderRegistry);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't start QM embedded database", (Throwable)e);
                return;
            }
            log.debug((Object)"QMDB connected");
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void connectToDatabase(@NotNull Properties conProperties, @NotNull DataSourceProviderRegistry dataSourceProviderRegistry) throws DBException {
        block19: {
            Driver driverInstance;
            LoggingProgressMonitor monitor = new LoggingProgressMonitor(log);
            String driverID = this.databaseConfig.getDriver();
            String conURL = GeneralUtils.replaceVariables((String)this.databaseConfig.getUrl(), (IVariableResolver)SystemVariablesResolver.INSTANCE);
            DBPDriver driver = dataSourceProviderRegistry.findDriver(driverID);
            if (driver == null) {
                throw new DBException("QMDB driver '" + driverID + "' not found");
            }
            driver = driver.createOriginalCopy();
            this.databaseDialect = driver.getScriptDialect().createInstance();
            if (driver.needsExternalDependencies()) {
                log.debug((Object)("JDBC  dependencies are missing for driver " + driver.getFullName() + ". Fallback to default H2 driver."));
                try {
                    driverInstance = (Driver)Class.forName(DATABASE_DEFAULT_DRIVER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    log.error((Object)"Can't load QMDB database driver", e);
                    return;
                }
            } else {
                driverInstance = (Driver)driver.getDriverInstance((DBRProgressMonitor)monitor);
            }
            this.driverClassLoader = driverInstance.getClass().getClassLoader();
            try {
                void schemaController;
                SQLDialect dialect;
                this.dbConnection = this.initConnectionPool(driver, conURL, conProperties, driverInstance);
                SQLDialect sQLDialect = dialect = driver.getScriptDialect().createInstance();
                if (!(sQLDialect instanceof SQLDialectSchemaController)) break block19;
                SQLDialectSchemaController sQLDialectSchemaController = (SQLDialectSchemaController)sQLDialect;
                SQLDialectSchemaController cfr_ignored_0 = (SQLDialectSchemaController)sQLDialect;
                if (!CommonUtils.isNotEmpty((String)this.schemaName)) break block19;
                String schemaExistQuery = schemaController.getSchemaExistQuery(this.schemaName);
                Throwable throwable = null;
                Object var14_16 = null;
                try (Connection dbCon = this.getConnection();){
                    boolean schemaExist;
                    boolean bl = schemaExist = JDBCUtils.executeQuery((Connection)dbCon, (String)schemaExistQuery, (Object[])new Object[0]) != null;
                    if (!schemaExist) {
                        log.info((Object)("Schema " + this.schemaName + " not exist, create new one"));
                        String createSchemaQuery = schemaController.getCreateSchemaQuery(this.schemaName);
                        try {
                            JDBCUtils.executeStatement((Connection)dbCon, (String)createSchemaQuery);
                        }
                        catch (SQLException e) {
                            log.error((Object)("Failed to create schema: " + this.schemaName), (Throwable)e);
                            this.dbConnection.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error opening QMDB database", (Throwable)e);
                if (!this.databaseConfig.isH2Embedded()) break block19;
                this.tryDatabaseRecover(driver, driverInstance, conURL, conProperties, e);
            }
        }
    }

    protected PoolingDataSource<PoolableConnection> initConnectionPool(DBPDriver driver, String dbURL, Properties dbProperties, Driver driverInstance) throws SQLException, DBException {
        log.debug((Object)("\tInitiate connection pool with management database (" + driver.getFullName() + "; " + dbURL + ")"));
        DriverConnectionFactory conFactory = new DriverConnectionFactory(driverInstance, dbURL, dbProperties);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)conFactory, null);
        pcf.setValidationQuery(this.databaseConfig.getPool().getValidationQuery());
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(this.databaseConfig.getPool().getMinIdleConnections());
        config.setMaxIdle(this.databaseConfig.getPool().getMaxIdleConnections());
        config.setMaxTotal(this.databaseConfig.getPool().getMaxConnections());
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf, config);
        pcf.setPool((ObjectPool)connectionPool);
        return new PoolingDataSource((ObjectPool)connectionPool);
    }

    @NotNull
    private static Path getEmbeddedDatabasePath() {
        return DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(EMBEDDED_DATABASE_ID);
    }

    /*
     * WARNING - void declaration
     */
    private void tryDatabaseRecover(DBPDriver driver, Driver driverInstance, String conURL, Properties conProperties, Exception dbError) {
        boolean internalH2Error = false;
        Exception exception = dbError;
        if (exception instanceof SQLException) {
            void sqlException;
            SQLException sQLException = (SQLException)exception;
            SQLException cfr_ignored_0 = (SQLException)exception;
            String sqlState = sqlException.getSQLState();
            if ("90030".equals(sqlState) || SQLState.SQL_HY000.getCode().equals(sqlState)) {
                internalH2Error = true;
            }
        }
        if (!internalH2Error) {
            return;
        }
        Path edbPath = QMDBModel.getEmbeddedDatabasePath();
        if (!Files.exists(edbPath, new LinkOption[0])) {
            return;
        }
        Path backupPath = QMDBModel.getEmbeddedDatabasePath().getParent().resolve("qmdb-backup-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())));
        if (Files.exists(backupPath, new LinkOption[0])) {
            log.error((Object)("Backup directory '" + String.valueOf(backupPath) + "' already exists. Can't backup again."));
            return;
        }
        try {
            Files.move(edbPath, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        log.warn((Object)"Corrupted QMDB database was archived. Creating new empty QMDB database..");
        try {
            this.dbConnection = this.initConnectionPool(driver, conURL, conProperties, driverInstance);
        }
        catch (Exception e) {
            log.error((Object)"Can't create QMDB database after backup", (Throwable)e);
            return;
        }
    }

    private void shutdownModel() {
        try {
            this.endCurrentRun();
        }
        catch (SQLException e) {
            log.warn((Object)e);
        }
        if (this.isInitialized()) {
            log.debug((Object)"Closing QMDB connection.");
            this.closeConnection();
            log.debug((Object)"QMDB stopped.");
        }
    }

    private void closeConnection() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (Exception e) {
                log.warn((Object)"Error while stopping QM embedded database", (Throwable)e);
            }
            this.dbConnection = null;
        }
    }

    public void initializeSchema() throws DBException, SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection dbCon = this.getConnection();){
            this.initializeSchema(dbCon);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void initializeSchema(Connection dbCon) throws DBException, SQLException {
        if (this.schemaName == null) {
            this.schemaName = QMActivator.getDefault().getPreferences().getString("qmdb.database.schema");
        }
        LoggingProgressMonitor monitor = new LoggingProgressMonitor();
        if (dbCon == null) {
            log.error((Object)"No QMDB connection");
            return;
        }
        SQLSchemaManager schemaManager = new SQLSchemaManager("QMDB", (SQLSchemaScriptSource)new ClassLoaderScriptSource(QMDBDataSourceProvider.class.getClassLoader(), "ddl/qm_schema.sql", "ddl/qm_schema_update_"), monitor1 -> dbCon, (SQLSchemaVersionManager)new QMSchemaVersionManager(), this.databaseDialect, null, this.schemaName, 18, 3, (InternalDatabaseConfig)this.databaseConfig);
        schemaManager.updateSchema((DBRProgressMonitor)monitor);
        this.checkVersionConsistency();
        log.debug((Object)"\tCheck QMDB deployment");
        this.checkDBeaverHost();
        this.checkDBeaverDeployment();
        this.checkDBeaverVersion();
        long systemUserId = this.checkDBeaverSystemUser((DBRProgressMonitor)monitor);
        this.workspaceId = this.checkDBeaverPlatformWorkspace();
        this.runId = this.createDBeaverRun(this.workspaceId, systemUserId);
    }

    private long checkDBeaverSystemUser(DBRProgressMonitor monitor) throws DBException, SQLException {
        SMSessionPrincipal globalPrincipal = QMUtils.getWorkspaceSession((DBRProgressMonitor)monitor).getSessionPrincipal();
        return this.findOrCreateUser(globalPrincipal);
    }

    private long checkDBeaverPlatformWorkspace() throws SQLException {
        String workspacePath = Platform.getInstanceLocation().getURL().toString();
        return this.findOrCreateQMDBeaverWorkspace(workspacePath);
    }

    private void checkVersionConsistency() {
    }

    private void checkDBeaverDeployment() throws SQLException {
        String installPath = CommonUtils.truncateString((String)Platform.getInstallLocation().getURL().toString(), (int)1000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = this.getConnection();){
            this.deployId = JDBCUtils.queryLong((Connection)dbCon, (String)this.normalizeTableNames("SELECT DEPLOY_ID FROM {table_prefix}QM_DBEAVER_DEPLOYMENT WHERE HOST_ID=? AND INSTALL_PATH=?"), (Object[])new Object[]{this.hostId, installPath});
            if (this.deployId == null) {
                int appPortNumber = 0;
                this.deployId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_DBEAVER_DEPLOYMENT (HOST_ID,INSTALL_PATH,PORT_NUMBER,UPDATE_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)"), (String)"DEPLOY_ID", (Object[])new Object[]{this.hostId, installPath, appPortNumber});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public String normalizeTableNames(@NotNull String sql) {
        return CommonUtils.normalizeTableNames((String)sql, (String)this.schemaName);
    }

    private void checkDBeaverVersion() throws SQLException {
        String productName = GeneralUtils.getProductName();
        String versionName = GeneralUtils.getProductVersion().toString();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection dbCon = this.getConnection();){
            this.productVersionId = JDBCUtils.queryLong((Connection)dbCon, (String)this.normalizeTableNames("SELECT VERSION_ID FROM {table_prefix}QM_DBEAVER_VERSION WHERE PRODUCT_NAME=? AND VERSION_NAME=?"), (Object[])new Object[]{productName, versionName});
            if (this.productVersionId == null) {
                this.productVersionId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_DBEAVER_VERSION (PRODUCT_NAME,VERSION_NAME,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)"), (String)"VERSION_ID", (Object[])new Object[]{productName, versionName});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    long findOrCreateQMDBeaverWorkspace(String workspacePath) throws SQLException {
        Long workspaceId = this.findQMDBeaverWorkspace(workspacePath);
        if (workspaceId == null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Connection dbCon = this.getConnection();){
                workspaceId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_DBEAVER_WORKSPACE (HOST_ID,WORKSPACE_PATH,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)"), (String)"WORKSPACE_ID", (Object[])new Object[]{this.hostId, workspacePath});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return workspaceId;
    }

    public Long findOrCreateQMDBeaverProject(QMMProjectInfo projectInfo) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = this.getConnection();){
            Long projectId = JDBCUtils.queryLong((Connection)dbCon, (String)this.normalizeTableNames("SELECT PROJECT_ID FROM {table_prefix}QM_DBEAVER_PROJECT WHERE PROJECT_NAME=? AND WORKSPACE_ID=?"), (Object[])new Object[]{projectInfo.getId(), this.workspaceId});
            if (projectId == null) {
                projectId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_DBEAVER_PROJECT(PROJECT_NAME,PROJECT_UUID,PROJECT_PATH,IS_ANONYMOUS,WORKSPACE_ID,UPDATE_TIME) VALUES(?,?,?,?,?,CURRENT_TIMESTAMP)"), (String)"PROJECT_ID", (Object[])new Object[]{projectInfo.getId(), this.databaseDialect.supportsUuid() ? projectInfo.getUuid() : projectInfo.getUuid().toString(), projectInfo.getPath(), projectInfo.isAnonymous(), this.workspaceId});
            }
            return projectId;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    Long findQMDBeaverWorkspace(String workspacePath) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = this.getConnection();){
            return JDBCUtils.queryLong((Connection)dbCon, (String)this.normalizeTableNames("SELECT WORKSPACE_ID FROM {table_prefix}QM_DBEAVER_WORKSPACE WHERE HOST_ID=? AND WORKSPACE_PATH=?"), (Object[])new Object[]{this.hostId, workspacePath});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    Long findOrCreateUser(SMSessionPrincipal globalPrincipal) throws SQLException {
        String osUserName = globalPrincipal.getUserName();
        String osDomainName = globalPrincipal.getUserDomain();
        return this.findOrCreateUser(osUserName, osDomainName);
    }

    Long findOrCreateUser(String userName, String userDomain) throws SQLException {
        if (CommonUtils.isEmpty((String)userDomain)) {
            userDomain = EMPTY_DOMAIN_NAME;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection dbCon = this.getConnection();){
            Long userId = JDBCUtils.queryLong((Connection)dbCon, (String)this.normalizeTableNames("SELECT USER_ID FROM {table_prefix}QM_USER WHERE DOMAIN_NAME=? AND USER_NAME=?"), (Object[])new Object[]{userDomain, userName});
            if (userId == null) {
                userId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_USER (DOMAIN_NAME,USER_NAME,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)"), (String)"USER_ID", (Object[])new Object[]{userDomain, userName});
            }
            return userId;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkDBeaverHost() throws SQLException {
        byte[] hardwareAddress;
        InetAddress localHost = RuntimeUtils.getLocalHostOrLoopback();
        String hostName = localHost.getHostName();
        String hostIP = localHost.getHostAddress();
        try {
            hardwareAddress = RuntimeUtils.getLocalMacAddress();
        }
        catch (IOException iOException) {
            hardwareAddress = new byte[8];
        }
        String macAddress = CommonUtils.toHexString((byte[])hardwareAddress);
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection dbCon = this.getConnection();){
            this.hostId = JDBCUtils.queryLong((Connection)dbCon, (String)this.normalizeTableNames("SELECT HOST_ID FROM {table_prefix}QM_DBEAVER_HOST WHERE MAC_ADDRESS=?"), (Object[])new Object[]{macAddress});
            if (this.hostId == null) {
                this.hostId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_DBEAVER_HOST (MAC_ADDRESS,HOST_NAME,IP_ADDRESS,UPDATE_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)"), (String)"HOST_ID", (Object[])new Object[]{macAddress, hostName, hostIP});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    long createDBeaverRun(long workspaceId, long workspaceUserId) throws SQLException {
        Throwable throwable = null;
        Object var6_5 = null;
        try (Connection dbCon = this.getConnection();){
            return JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)this.normalizeTableNames("INSERT INTO {table_prefix}QM_DBEAVER_RUN (DEPLOY_ID,VERSION_ID,WORKSPACE_ID,USER_ID,START_TIME) VALUES(?,?,?,?,CURRENT_TIMESTAMP)"), (String)"RUN_ID", (Object[])new Object[]{this.deployId, this.productVersionId, workspaceId, workspaceUserId});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void endCurrentRun() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection dbCon = this.getConnection();){
            if (dbCon == null) {
                return;
            }
            JDBCUtils.executeSQL((Connection)dbCon, (String)this.normalizeTableNames("UPDATE {table_prefix}QM_DBEAVER_RUN SET STOP_TIME=CURRENT_TIMESTAMP WHERE RUN_ID=?"), (Object[])new Object[]{this.runId});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<QMDBQueryRecord> searchQueryHistory(DBRProgressMonitor monitor, QMDBQueryFilter filter) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection dbCon = this.getConnection();){
                return this.searchQueryHistory(dbCon, monitor, filter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error searching query history: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<QMDBQueryRecord> searchQueryHistory(Connection dbCon, DBRProgressMonitor monitor, QMDBQueryFilter filter) throws DBException {
        if (dbCon == null) {
            return new ArrayList<QMDBQueryRecord>();
        }
        ArrayList<QMDBQueryRecord> results = new ArrayList<QMDBQueryRecord>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT q.QUERY_ID,q.QUERY_TEXT,s.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,c.DATASOURCE_ID,c.INSTANCE_ID,c.CONTEXT_NAME\nFROM {table_prefix}QM_QUERY q, {table_prefix}QM_STATEMENT s, {table_prefix}QM_EVENT e, {table_prefix}QM_CONNECTION c ");
        sql.append("\nWHERE q.QUERY_ID=s.QUERY_ID AND e.EVENT_ID=s.STATEMENT_ID AND c.CONNECTION_ID=e.CONNECTION_ID");
        if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
            sql.append("\nAND q.QUERY_TEXT LIKE ?");
        }
        if (filter.getRowOffset() > 0 || filter.getMaxRows() > 0) {
            sql.append("\nLIMIT ").append(filter.getRowOffset()).append(", ").append(filter.getMaxRows());
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (PreparedStatement dbStat = dbCon.prepareStatement(sql.toString());){
                int paramIndex = 1;
                if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
                    dbStat.setString(paramIndex++, "%" + filter.getQueryText() + "%");
                }
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (ResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        QMDBQueryRecord record = new QMDBQueryRecord();
                        record.setQueryId(dbResult.getLong("QUERY_ID"));
                        record.setQueryText(dbResult.getString("QUERY_TEXT"));
                        record.setStatementPurpose(dbResult.getInt("STATEMENT_PURPOSE"));
                        record.setErrorCode(dbResult.getLong("ERROR_CODE"));
                        record.setErrorMessage(dbResult.getString("ERROR_MESSAGE"));
                        record.setExecuteTime(dbResult.getLong("EXECUTE_TIME"));
                        record.setFetchTime(dbResult.getLong("FETCH_TIME"));
                        results.add(record);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading query history", (Throwable)e);
        }
        return results;
    }

    void stopDatabase() {
        this.closeConnection();
    }

    PoolingDataSource<PoolableConnection> restartDatabase() {
        this.openConnection();
        return this.dbConnection;
    }

    public ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    private static class QMSchemaVersionManager
    implements SQLSchemaVersionManager {
        private QMSchemaVersionManager() {
        }

        public int getCurrentSchemaVersion(DBRProgressMonitor monitor, Connection connection, String schemaName) {
            try {
                Object version = JDBCUtils.executeQuery((Connection)connection, (String)CommonUtils.normalizeTableNames((String)"SELECT VERSION FROM {table_prefix}QM_INFO", (String)schemaName), (Object[])new Object[0]);
                return CommonUtils.toInt((Object)version);
            }
            catch (SQLException sQLException) {
                return -1;
            }
        }

        public int getLatestSchemaVersion() {
            return 18;
        }

        public void updateCurrentSchemaVersion(DBRProgressMonitor monitor, @NotNull Connection connection, @NotNull String schemaName, int version) throws SQLException {
            int updateCount = JDBCUtils.executeUpdate((Connection)connection, (String)CommonUtils.normalizeTableNames((String)"UPDATE {table_prefix}QM_INFO SET VERSION=?,UPDATE_TIME=CURRENT_TIMESTAMP", (String)schemaName), (Object[])new Object[]{version});
            if (updateCount <= 0) {
                JDBCUtils.executeSQL((Connection)connection, (String)CommonUtils.normalizeTableNames((String)"INSERT INTO {table_prefix}QM_INFO (VERSION,UPDATE_TIME) VALUES(?,CURRENT_TIMESTAMP)", (String)schemaName), (Object[])new Object[]{version});
            }
        }
    }
}

