/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.exec;

import com.dbeaver.db.couchdb.data.CouchDBDocument;
import com.dbeaver.db.couchdb.exec.CouchDBAbstractStatement;
import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.dbeaver.db.couchdb.model.CouchDBDatabase;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CouchDBInsertStatement
extends CouchDBAbstractStatement {
    private CouchDBDatabase database;
    private DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public CouchDBInsertStatement(CouchDBSession session, CouchDBDatabase database, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session);
        this.database = database;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        return null;
    }

    public boolean executeStatement() throws DBCException {
        try {
            if (this.valueAttributes.length != 1 || this.valueAttributes[0].getDataKind() != DBPDataKind.DOCUMENT) {
                throw new DBCException("Unsupported document value: " + Arrays.toString(this.valueAttributes));
            }
            Map<String, Object> json = ((CouchDBDocument)((Object)this.rowValues[0])).getPlainMap();
            JsonObject o = (JsonObject)CouchDBDataSource.GSON.toJsonTree(json);
            this.database.getClient().post((Object)o);
            return false;
        }
        catch (Throwable e) {
            throw new DBCException("Error saving document", e);
        }
    }
}

