/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.cubrid.model.CubridView;
import org.jkiss.dbeaver.ext.cubrid.model.plan.CubridQueryPlanner;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class CubridMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(CubridMetaModel.class);

    public String getTableOrViewName(GenericTableBase base) {
        if (base != null) {
            if (base.isView()) {
                return ((CubridView)base).getUniqueName();
            }
            return ((CubridTable)base).getUniqueName();
        }
        return null;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        ArrayList<GenericSchema> users = new ArrayList<GenericSchema>();
        try {
            JDBCPreparedStatement dbStat = session.prepareStatement("select * from db_user");
            dbStat.executeStatement();
            JDBCResultSet dbResult = dbStat.getResultSet();
            while (dbResult.next()) {
                String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"name");
                String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"comment");
                CubridUser user = new CubridUser(dataSource, name, description);
                users.add(user);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cannot load user", (Throwable)e);
        }
        return users;
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        String sql = "select a.*,a.class_name as TABLE_NAME, case when class_type = 'CLASS' then 'TABLE' \r\nwhen class_type = 'VCLASS' then 'VIEW' end as TABLE_TYPE, \r\nb.current_val from db_class a LEFT JOIN db_serial b on \r\na.class_name = b.class_name where a.owner_name = ?";
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, owner.getName());
        return dbStat;
    }

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        return session.getMetaData().getColumns(null, null, this.getTableOrViewName(forTable), null).getSourceStatement();
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException, DBException {
        return session.getMetaData().getPrimaryKeys(null, null, this.getTableOrViewName(forTable)).getSourceStatement();
    }

    public JDBCStatement prepareForeignKeysLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        return session.getMetaData().getImportedKeys(null, null, this.getTableOrViewName(forTable)).getSourceStatement();
    }

    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
        String tableType = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABLE_TYPE");
        GenericTableBase table = this.createTableOrViewImpl(owner, tableName, tableType, dbResult);
        return table;
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new CubridView(container, tableName, tableType, dbResult);
        }
        return new CubridTable(container, tableName, tableType, dbResult);
    }

    public DBCQueryPlanner getQueryPlanner(@NotNull GenericDataSource dataSource) {
        return new CubridQueryPlanner((CubridDataSource)dataSource);
    }
}

