/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;

public class CubridView
extends GenericView {
    public CubridView(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        String type;
        if (dbResult != null && (type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_system_class")) != null) {
            this.setSystem(type.equals("YES"));
        }
    }

    public CubridDataSource getDataSource() {
        return (CubridDataSource)super.getDataSource();
    }

    public String getUniqueName() {
        if (this.getDataSource().getSupportMultiSchema()) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return this.getName();
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=OwnerListProvider.class, order=2)
    @Nullable
    public GenericSchema getSchema() {
        return super.getSchema();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.isSystem()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    public static class OwnerListProvider
    implements IPropertyValueListProvider<CubridView> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(CubridView object) {
            return object.getDataSource().getSchemas().toArray();
        }
    }
}

