/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridView;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class CubridUser
extends GenericSchema {
    private String name;
    private String comment;

    public CubridUser(GenericDataSource dataSource, String schemaName, String comment) {
        super(dataSource, null, schemaName);
        this.name = schemaName;
        this.comment = comment;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getComment() {
        return this.comment;
    }

    public boolean supportsSystemTable() {
        return this.name.equals("DBA");
    }

    public boolean supportsSystemView() {
        return this.name.equals("DBA");
    }

    public boolean showSystemTableFolder() {
        return this.getDataSource().getContainer().getNavigatorSettings().isShowSystemObjects();
    }

    public List<CubridTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridTable> tables = new ArrayList<CubridTable>();
        for (GenericTable table : super.getPhysicalTables(monitor)) {
            if (table.isSystem()) continue;
            tables.add((CubridTable)table);
        }
        return tables;
    }

    public List<? extends CubridTable> getPhysicalSystemTables(DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridTable> tables = new ArrayList<CubridTable>();
        for (GenericTable table : super.getPhysicalTables(monitor)) {
            if (!table.isSystem()) continue;
            tables.add((CubridTable)table);
        }
        return tables;
    }

    public List<CubridView> getViews(DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridView> views = new ArrayList<CubridView>();
        for (GenericView view : super.getViews(monitor)) {
            if (view.isSystem()) continue;
            views.add((CubridView)view);
        }
        return views;
    }

    public List<CubridView> getSystemViews(DBRProgressMonitor monitor) throws DBException {
        ArrayList<CubridView> views = new ArrayList<CubridView>();
        for (GenericView view : super.getViews(monitor)) {
            if (!view.isSystem()) continue;
            views.add((CubridView)view);
        }
        return views;
    }
}

