/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndexColumn;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public class CubridObjectContainer
extends GenericObjectContainer {
    private final CubridDataSource dataSource;
    private final CubridIndexCache cubridIndexCache;

    protected CubridObjectContainer(CubridDataSource dataSource) {
        super((GenericDataSource)dataSource);
        this.dataSource = dataSource;
        this.cubridIndexCache = new CubridIndexCache(this.getTableCache());
    }

    @NotNull
    public CubridDataSource getDataSource() {
        return this.dataSource;
    }

    public CubridIndexCache getCubridIndexCache() {
        return this.cubridIndexCache;
    }

    public GenericStructContainer getObject() {
        return this;
    }

    public GenericCatalog getCatalog() {
        return null;
    }

    public GenericSchema getSchema() {
        return null;
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(DBRProgressMonitor monitor) throws DBException {
        return CubridTable.class;
    }

    public DBSObject getParentObject() {
        return this.getDataSource().getParentObject();
    }

    public String getName() {
        return this.getDataSource().getName();
    }

    public String getDescription() {
        return this.getDataSource().getDescription();
    }

    public class CubridIndexCache
    extends JDBCCompositeCache<GenericStructContainer, CubridTable, GenericTableIndex, GenericTableIndexColumn> {
        CubridIndexCache(TableCache tableCache) {
            super((JDBCStructCache)tableCache, CubridTable.class, (Object)"TABLE_NAME", (Object)"INDEX_NAME");
        }

        protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer owner, CubridTable forParent) throws SQLException {
            return session.getMetaData().getIndexInfo(null, null, forParent.getUniqueName(), false, true).getSourceStatement();
        }

        protected GenericTableIndex fetchObject(JDBCSession session, GenericStructContainer owner, CubridTable parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            DBSIndexType indexType;
            boolean isNonUnique = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NON_UNIQUE");
            String indexQualifier = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"INDEX_QUALIFIER");
            long cardinality = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CARDINALITY");
            int indexTypeNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"TYPE");
            Object name = indexName;
            switch (indexTypeNum) {
                case 0: {
                    return null;
                }
                case 1: {
                    indexType = DBSIndexType.CLUSTERED;
                    break;
                }
                case 2: {
                    indexType = DBSIndexType.HASHED;
                    break;
                }
                case 3: {
                    indexType = DBSIndexType.OTHER;
                    break;
                }
                default: {
                    indexType = DBSIndexType.UNKNOWN;
                }
            }
            if (CommonUtils.isEmpty((String)name)) {
                name = parent.getName().toUpperCase(Locale.ENGLISH) + "_INDEX";
            }
            return new GenericTableIndex((GenericTableBase)parent, isNonUnique, indexQualifier, cardinality, (String)name, indexType, true);
        }

        protected GenericTableIndexColumn[] fetchObjectRow(JDBCSession session, CubridTable parent, GenericTableIndex object, JDBCResultSet dbResult) throws SQLException, DBException {
            int ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
            String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
            String ascOrDesc = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"ASC_OR_DESC");
            if (CommonUtils.isEmpty((String)columnName)) {
                return null;
            }
            GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
            if (tableColumn == null) {
                return null;
            }
            return new GenericTableIndexColumn[]{new GenericTableIndexColumn(object, tableColumn, ordinalPosition, !"D".equalsIgnoreCase(ascOrDesc))};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, GenericTableIndex object, List<GenericTableIndexColumn> children) {
            object.setColumns(children);
        }
    }
}

