/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridObjectContainer;
import org.jkiss.dbeaver.ext.cubrid.model.CubridSQLDialect;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.cubrid.model.meta.CubridMetaModel;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.dpi.DPIContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;

public class CubridDataSource
extends GenericDataSource {
    private final CubridMetaModel metaModel = new CubridMetaModel();
    private final CubridObjectContainer structureContainer = new CubridObjectContainer(this);
    private boolean supportMultiSchema;

    public CubridDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, CubridMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new CubridSQLDialect());
    }

    @DPIContainer
    @NotNull
    public CubridDataSource getDataSource() {
        return this;
    }

    public List<GenericSchema> getCubridUsers(DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas();
    }

    @Nullable
    public GenericTableBase findTable(@NotNull DBRProgressMonitor monitor, @Nullable String catalogName, @Nullable String schemaName, @NotNull String tableName) throws DBException {
        String[] schema = tableName.split("\\.");
        if (schema.length > 1) {
            CubridUser user = (CubridUser)this.getSchema(schema[0].toUpperCase());
            return user.getTable(monitor, schema[1]);
        }
        return null;
    }

    @NotNull
    public CubridMetaModel getMetaModel() {
        return this.metaModel;
    }

    public Collection<? extends DBSDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        HashMap<String, DBSDataType> types = new HashMap<String, DBSDataType>();
        for (DBSDataType dataType : super.getDataTypes(monitor)) {
            types.put(dataType.getName(), dataType);
        }
        return types.values();
    }

    public CubridObjectContainer getObjectContainer() {
        return this.structureContainer;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
    }

    public boolean getSupportMultiSchema() {
        return this.supportMultiSchema;
    }

    public void setSupportMultiSchema(boolean supportMultiSchema) {
        this.supportMultiSchema = supportMultiSchema;
    }
}

